/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdt.util.map;

import com.sap.sdt.util.map.MapException;
import com.sap.sdt.util.map.MapOverflowException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class ConstMap {
    public static final String RCSINFO = "$Id: //sdt/com.sap.sdt/0.1/src/_util/java/com/sap/sdt/util/map/ConstMap.java#3 $";
    private int mapSize = 0;
    private List map = null;
    private int dimension = 0;

    public Object[] getRow(Object key, int col) throws MapOverflowException {
        if (key == null) {
            return null;
        }
        int inx = this.getIndexOf(key, col);
        if (inx == -1) {
            return null;
        }
        return (Object[])this.map.get(inx);
    }

    public Object[] getRow(Object key) throws MapOverflowException {
        return this.getRow(key, 0);
    }

    public Iterator iterator() {
        if (this.map == null) {
            return null;
        }
        return this.map.iterator();
    }

    public Object getElem(Object key, int keyCol, int getCol) throws MapOverflowException {
        if (keyCol >= this.dimension) {
            throw new MapOverflowException(keyCol, this.dimension);
        }
        if (getCol >= this.dimension) {
            return null;
        }
        if (key == null) {
            return null;
        }
        Object[] row = this.getRow(key, keyCol);
        if (row == null) {
            return null;
        }
        return row[getCol];
    }

    public void addRow(Object[] row) throws MapOverflowException {
        if (row.length > this.dimension) {
            throw new MapOverflowException(row.length, this.dimension);
        }
        this.map.add(row);
        ++this.mapSize;
    }

    public void addRow(List row) throws MapOverflowException, MapException {
        if (row.size() > this.dimension) {
            throw new MapOverflowException(row.size(), this.dimension);
        }
        Object[] newRow = new Object[this.dimension];
        int dim = 0;
        Iterator it = row.iterator();
        while (it.hasNext()) {
            if (dim > this.dimension) {
                throw new MapOverflowException(dim, this.dimension);
            }
            newRow[dim] = it.next();
            ++dim;
        }
        this.addRow(newRow);
    }

    public boolean containsElem(Integer key, int keyCol) throws MapOverflowException {
        return this.getElem(key, keyCol, keyCol) != null;
    }

    public boolean containsElem(Object key, int keyCol) throws MapOverflowException {
        return this.getElem(key, keyCol, keyCol) != null;
    }

    public int getDimension() {
        return this.dimension;
    }

    public ConstMap(int newDimension) {
        this.dimension = newDimension;
        this.map = new ArrayList();
        this.mapSize = 0;
    }

    public int getIndexOf(Object key, int col) throws MapOverflowException {
        if (col >= this.dimension) {
            throw new MapOverflowException(col, this.dimension);
        }
        int rowInx = 0;
        Iterator it = this.map.iterator();
        while (it.hasNext()) {
            Object[] row = (Object[])it.next();
            String keyClass = key.getClass().getName();
            String entryClass = row[col].getClass().getName();
            if (row[col].getClass().equals(key.getClass()) && row[col].toString().compareTo(key.toString()) == 0) {
                return rowInx;
            }
            ++rowInx;
        }
        return -1;
    }
}

