/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdt.util.io;

import com.sap.sdt.util.diag.DiagException;
import com.sap.sdt.util.diag.JavaException;
import com.sap.sdt.util.io.MsgIdConstants;
import com.sap.sdt.util.io.StatusSyncIF;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;

public class StatusSync
implements StatusSyncIF,
MsgIdConstants {
    public static final String RCSINFO = "$Id: //sdt/com.sap.sdt/0.1/src/_util/java/com/sap/sdt/util/io/StatusSync.java#2 $";
    private static final int SLEEPTIME = 2;
    private static final String VERSIONTAG = "V1:";
    private static final String VARNAME_TOOL = "TOOL";
    private static final String VARNAME_EVENT = "EVENT";
    private static final String VARNAME_STATUS = "STATUS";
    private int sleepTime = 2;
    private String toolname;
    private String syncfile;
    private String lockfile;
    private File lckfl = null;

    public StatusSync(String toolname, String syncfile, String lockfile) {
        this.toolname = toolname;
        this.syncfile = syncfile;
        this.lockfile = lockfile;
    }

    public int getSleepTime() {
        return this.sleepTime;
    }

    public void setSleepTime(int sleepTime) {
        this.sleepTime = sleepTime;
    }

    public void setStatus(String event, String status) throws DiagException {
        try {
            this.lock();
            FileWriter out = new FileWriter(this.syncfile, true);
            out.write("V1: TOOL=" + this.toolname + " " + VARNAME_EVENT + "=" + event + " " + VARNAME_STATUS + "=" + status + "\n");
            out.close();
            this.unlock();
        }
        catch (IOException e) {
            this.unlock();
            throw new JavaException(e);
        }
    }

    public String getStatus(String event) throws DiagException {
        return this.getStatus(event, null);
    }

    public String getStatus(String event, String tool) throws DiagException {
        try {
            String line;
            this.lock();
            BufferedReader in = new BufferedReader(new FileReader(this.syncfile));
            String status = null;
            while ((line = in.readLine()) != null) {
                if (line.startsWith("#")) {
                    return status;
                }
                if (line.startsWith(VERSIONTAG)) {
                    status = this.updateStatus(status, line.substring(VERSIONTAG.length()), tool, event);
                    continue;
                }
                throw new DiagException("msg.io.0002", new String[]{line, this.syncfile});
            }
            in.close();
            this.unlock();
            return status;
        }
        catch (IOException ie) {
            this.unlock();
            throw new JavaException(ie);
        }
        catch (DiagException de) {
            this.unlock();
            throw de;
        }
    }

    private String updateStatus(String status, String line, String tool, String event) throws DiagException {
        line = line.trim();
        String[] words = line.split("  *");
        String ltool = null;
        String levent = null;
        String lstatus = null;
        for (int i = 0; i < words.length; ++i) {
            int pos = words[i].indexOf(61);
            if (pos == -1) {
                throw new DiagException("msg.io.0003", new String[]{line, this.syncfile});
            }
            String var = words[i].substring(0, pos);
            String value = words[i].substring(pos + 1);
            if (var.equals(VARNAME_TOOL)) {
                ltool = value;
                continue;
            }
            if (var.equals(VARNAME_EVENT)) {
                levent = value;
                continue;
            }
            if (var.equals(VARNAME_STATUS)) {
                lstatus = value;
                continue;
            }
            throw new DiagException("msg.io.0004", new String[]{var, line, this.syncfile});
        }
        if (ltool == null || levent == null || lstatus == null) {
            throw new DiagException("msg.io.0003", new String[]{line, this.syncfile});
        }
        if (!levent.equals(event)) {
            return status;
        }
        if (tool != null ? !ltool.equals(tool) : ltool.equals(this.toolname)) {
            return status;
        }
        return lstatus;
    }

    private void lock() throws DiagException {
        if (this.lckfl != null) {
            throw new NullPointerException();
        }
        File file = new File(this.lockfile);
        try {
            while (!file.createNewFile()) {
                try {
                    Thread.sleep(this.sleepTime * 1000);
                }
                catch (InterruptedException e) {}
            }
        }
        catch (IOException e) {
            throw new JavaException(e);
        }
        this.lckfl = file;
    }

    private void unlock() throws DiagException {
        if (!this.lckfl.delete()) {
            String name = this.lckfl.getAbsolutePath();
            this.lckfl = null;
            throw new DiagException("msg.io.0001", new String[]{name});
        }
        this.lckfl = null;
    }
}

