/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdt.util.io;

import com.sap.sdt.util.diag.FileException;
import com.sap.sdt.util.diag.FileIOException;
import com.sap.sdt.util.diag.SDTFileNotFoundException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;

public class SFile {
    public static final String RCSINFO = "$Id: //sdt/com.sap.sdt/0.1/src/_util/java/com/sap/sdt/util/io/SFile.java#2 $";
    public static final String COMMENT_STR = "#";

    public static List getFileLines(String pathName) throws FileException {
        return SFile.getFileLines(new File(pathName), true);
    }

    public static List getFileLines(String dirName, String fileName) throws FileException {
        return SFile.getFileLines(new File(dirName, fileName), true);
    }

    public static List getUncommentedFileLines(String pathName) throws FileException {
        return SFile.getFileLines(new File(pathName), false);
    }

    public static List getUncommentedFileLines(String dirName, String fileName) throws FileException {
        return SFile.getFileLines(new File(dirName, fileName), false);
    }

    public static List getUncommentedFileLines(File file) throws FileException {
        return SFile.getFileLines(file, false);
    }

    public static List getFileLines(String pathName, boolean withCommentLines) throws FileException {
        return SFile.getFileLines(new File(pathName), withCommentLines);
    }

    public static List getFileLines(String dirName, String fileName, boolean withCommentLines) throws FileException {
        return SFile.getFileLines(new File(dirName, fileName), withCommentLines);
    }

    public static List getFileLines(File file, boolean withCommentLines) throws FileException {
        BufferedReader in = null;
        try {
            in = new BufferedReader(new InputStreamReader(new FileInputStream(file)));
        }
        catch (FileNotFoundException ex) {
            throw new SDTFileNotFoundException(file.getAbsolutePath());
        }
        ArrayList<String> ret = new ArrayList<String>();
        String line = null;
        try {
            while (in.ready()) {
                line = in.readLine();
                if (!withCommentLines && line.startsWith(COMMENT_STR)) continue;
                ret.add(line);
            }
        }
        catch (IOException ex) {
            throw new FileIOException(ex, file.getAbsolutePath());
        }
        return ret;
    }

    public static Writer getAnyWriter(String outFile) {
        try {
            return SFile.getWriter(outFile);
        }
        catch (SDTFileNotFoundException fnfE) {
            return new PrintWriter(System.out);
        }
    }

    public static Writer getWriter(String outFile) throws SDTFileNotFoundException {
        if (outFile == null) {
            throw new SDTFileNotFoundException("<null>");
        }
        try {
            FileOutputStream fOS = new FileOutputStream(outFile);
            OutputStreamWriter oSW = new OutputStreamWriter(fOS);
            PrintWriter pW = new PrintWriter(oSW);
            return pW;
        }
        catch (FileNotFoundException fnfE) {
            throw new SDTFileNotFoundException(outFile);
        }
    }
}

