/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdt.util.io;

import com.sap.sdt.util.diag.DiagException;
import com.sap.sdt.util.diag.FileIOException;
import com.sap.sdt.util.diag.SDTFileNotFoundException;
import com.sap.sdt.util.misc.CheckSummerFactory;
import com.sap.sdt.util.misc.CheckSummerIF;
import java.io.BufferedWriter;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;

public class CheckSummerWriter
extends Writer {
    public static final String RCSINFO = "$Id: //sdt/com.sap.sdt/0.1/src/_util/java/com/sap/sdt/util/io/CheckSummerWriter.java#2 $";
    private Writer out;
    private CheckSummerIF validator;

    public CheckSummerWriter(String name) throws DiagException {
        this(name, CheckSummerFactory.getValidator(name));
    }

    public CheckSummerWriter(Writer out) {
        this(out, CheckSummerFactory.getXMLValidator());
    }

    public CheckSummerWriter(String name, CheckSummerIF validator) throws SDTFileNotFoundException, FileIOException {
        try {
            this.out = new BufferedWriter(new FileWriter(name));
        }
        catch (FileNotFoundException e) {
            throw new SDTFileNotFoundException(name);
        }
        catch (IOException e) {
            throw new FileIOException(e);
        }
        this.validator = validator;
    }

    public CheckSummerWriter(Writer out, CheckSummerIF validator) {
        this.out = out;
        this.validator = validator;
    }

    public void close() throws IOException {
        if (this.validator != null) {
            this.out.write(this.validator.generateTag(true));
        }
        this.out.close();
        this.out = null;
        this.validator = null;
    }

    public void flush() throws IOException {
        this.out.flush();
    }

    public void write(char[] cbuf, int off, int len) throws IOException {
        for (int i = 0; i < len; ++i) {
            this.write(cbuf[off + i]);
        }
    }

    public void write(int c) throws IOException {
        this.out.write(c);
        if (this.validator != null) {
            this.validator.update(c);
        }
    }

    public void finalize() {
        if (this.out == null) {
            return;
        }
        System.err.println("WARNING CheckSummerWriter: Forgotten close()!");
        try {
            this.close();
        }
        catch (IOException e) {
            System.err.println("ERROR CheckSummerWriter: Got uncatched IOException on close()!");
        }
    }
}

