/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdt.util.io;

import com.sap.sdt.util.diag.DiagException;
import com.sap.sdt.util.diag.SDTFileNotFoundException;
import com.sap.sdt.util.diag.WrapperIOException;
import com.sap.sdt.util.misc.BadCheckSummerException;
import com.sap.sdt.util.misc.CheckSummerFactory;
import com.sap.sdt.util.misc.CheckSummerIF;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;

public class CheckSummerReader
extends Reader {
    public static final String RCSINFO = "$Id: //sdt/com.sap.sdt/0.1/src/_util/java/com/sap/sdt/util/io/CheckSummerReader.java#2 $";
    private Reader in;
    private CheckSummerIF validator;

    public CheckSummerReader(String name) throws DiagException {
        this(name, CheckSummerFactory.getValidator(name));
    }

    public CheckSummerReader(String name, CheckSummerIF validator) throws SDTFileNotFoundException {
        try {
            this.in = new BufferedReader(new FileReader(name));
        }
        catch (FileNotFoundException e) {
            throw new SDTFileNotFoundException(name);
        }
        this.validator = validator;
    }

    public CheckSummerReader(Reader in, CheckSummerIF validator) {
        this.in = in;
        this.validator = validator;
    }

    public void close() throws IOException {
        this.in.close();
        this.in = null;
        this.validator = null;
    }

    public int read(char[] cbuf, int off, int len) throws IOException {
        int c;
        int i;
        for (i = 0; i < len && (c = this.read()) != -1; ++i) {
            cbuf[off + i] = (char)c;
        }
        if (i == 0) {
            return -1;
        }
        return i;
    }

    public int read() throws IOException {
        int c = this.in.read();
        if (this.validator != null) {
            this.validator.update(c);
        }
        if (c == -1 && !this.validator.checkValidation()) {
            throw new WrapperIOException(new BadCheckSummerException());
        }
        return c;
    }
}

