/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdt.util.io;

import com.sap.sdt.util.diag.DiagException;
import com.sap.sdt.util.diag.SDTFileNotFoundException;
import com.sap.sdt.util.misc.CheckSummerFactory;
import com.sap.sdt.util.misc.CheckSummerIF;
import java.io.BufferedOutputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class CheckSummerOutputStream
extends OutputStream {
    public static final String RCSINFO = "$Id: //sdt/com.sap.sdt/0.1/src/_util/java/com/sap/sdt/util/io/CheckSummerOutputStream.java#2 $";
    private OutputStream out;
    private CheckSummerIF validator;

    public CheckSummerOutputStream(String name) throws DiagException {
        this(name, CheckSummerFactory.getValidator(name));
    }

    public CheckSummerOutputStream(String name, CheckSummerIF validator) throws SDTFileNotFoundException {
        try {
            this.out = new BufferedOutputStream(new FileOutputStream(name));
        }
        catch (FileNotFoundException e) {
            throw new SDTFileNotFoundException(name);
        }
        this.validator = validator;
    }

    public CheckSummerOutputStream(OutputStream out) {
        this(out, CheckSummerFactory.getXMLValidator());
    }

    public CheckSummerOutputStream(OutputStream out, CheckSummerIF validator) {
        this.out = out;
        this.validator = validator;
    }

    public void write(int b) throws IOException {
        this.out.write(b);
        if (this.validator != null) {
            this.validator.update(b);
        }
    }

    public void close() throws IOException {
        if (this.validator != null) {
            String tag = this.validator.generateTag(true);
            for (int i = 0; i < tag.length(); ++i) {
                this.out.write((byte)tag.charAt(i));
            }
        }
        this.out.close();
        this.out = null;
    }

    public void finalize() {
        if (this.out == null) {
            return;
        }
        System.err.println("WARNING: Forgotten close() on CheckSummerOutputStream!");
        try {
            this.close();
        }
        catch (IOException e) {
            System.err.println("ERROR: Got uncatched IOException on close()!");
        }
    }
}

