/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdt.util.io;

import com.sap.sdt.util.diag.DiagException;
import com.sap.sdt.util.diag.SDTFileNotFoundException;
import com.sap.sdt.util.diag.WrapperIOException;
import com.sap.sdt.util.misc.BadCheckSummerException;
import com.sap.sdt.util.misc.CheckSummerFactory;
import com.sap.sdt.util.misc.CheckSummerIF;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;

public class CheckSummerInputStream
extends InputStream {
    public static final String RCSINFO = "$Id: //sdt/com.sap.sdt/0.1/src/_util/java/com/sap/sdt/util/io/CheckSummerInputStream.java#2 $";
    private InputStream in;
    private CheckSummerIF validator;

    public CheckSummerInputStream(String name) throws DiagException {
        this(name, CheckSummerFactory.getValidator(name));
    }

    public CheckSummerInputStream(String name, CheckSummerIF validator) throws SDTFileNotFoundException {
        try {
            this.in = new BufferedInputStream(new FileInputStream(name));
        }
        catch (FileNotFoundException e) {
            throw new SDTFileNotFoundException(name);
        }
        this.validator = validator;
    }

    public CheckSummerInputStream(InputStream in, CheckSummerIF validator) {
        this.in = in;
        this.validator = validator;
    }

    public int read() throws IOException {
        int c = this.in.read();
        if (this.validator != null) {
            this.validator.update(c);
        }
        if (c == -1 && !this.validator.checkValidation()) {
            throw new WrapperIOException(new BadCheckSummerException());
        }
        return c;
    }
}

