/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdt.util.info;

import com.sap.sdt.util.diag.DiagException;
import com.sap.sdt.util.diag.DiagMessage;
import com.sap.sdt.util.diag.MessageText;
import com.sap.sdt.util.diag.MissingInfoException;
import com.sap.sdt.util.diag.WrongSyntaxException;
import com.sap.sdt.util.info.AbstractInfoProvider;
import com.sap.sdt.util.info.InfoProviderFactoryProperties;
import com.sap.sdt.util.string.IncompletePairException;
import com.sap.sdt.util.string.PairSearcherNumber;
import com.sap.sdt.util.xml.XMLAdmin;
import com.sap.sdt.util.xml.XMLElementIF;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;

class InfoProvider
extends AbstractInfoProvider {
    public static final String RCSINFO = "$Id: //sdt/com.sap.sdt/0.1/src/_util/java/com/sap/sdt/util/info/InfoProvider.java#2 $";
    private String pattern1 = new String("$(");
    private String pattern2 = new String(")");
    private Map messageCache = null;

    InfoProvider() {
        this.prop = new InfoProviderFactoryProperties();
    }

    InfoProvider(String name) {
        super(name);
        this.prop = new InfoProviderFactoryProperties(name);
    }

    public String replace(String src, String[] params) {
        if (src == null) {
            return null;
        }
        if (params == null) {
            return src;
        }
        PairSearcherNumber psn = new PairSearcherNumber(src);
        int hits = 0;
        try {
            hits = psn.search(this.pattern1, this.pattern2);
        }
        catch (IncompletePairException ex) {
            return src;
        }
        if (hits <= 0) {
            return src;
        }
        return psn.replaceHits(params);
    }

    public String getE(String var) throws MissingInfoException {
        return this.getE(var, (String[])null);
    }

    public String getE(String var, String[] param) throws MissingInfoException {
        String val = this.getProperty(var);
        if (val == null && var.startsWith("msg.")) {
            val = this.getShortText(var);
        }
        if (val == null) {
            throw new MissingInfoException(var);
        }
        return this.replace(val, param);
    }

    protected String getShortText(String var) throws MissingInfoException {
        try {
            MessageText text = this.getMessageCacheEntry(var);
            return text == null ? null : text.getShort();
        }
        catch (DiagException diagEx) {
            MissingInfoException miex = new MissingInfoException(var);
            miex.addChild(diagEx);
            throw miex;
        }
    }

    public MessageText getMessageTextE(DiagException diagEx) throws MissingInfoException {
        DiagMessage diagMsg = diagEx.getDiagMessage();
        if (diagMsg == null) {
            return null;
        }
        return this.getMessageTextE(diagMsg.getMsgID(), diagMsg.getMsgParams());
    }

    public MessageText getMessageTextE(String var, String[] params) throws MissingInfoException {
        try {
            MessageText text = this.getMessageCacheEntry(var);
            String shortText = this.replace(text.getShort(), params);
            if (text.hasLong()) {
                String symptom = this.replace(text.getLong().getSymptom(), params);
                String cause = this.replace(text.getLong().getCause(), params);
                String solution = this.replace(text.getLong().getSolution(), params);
                return new MessageText(shortText, symptom, cause, solution);
            }
            return new MessageText(shortText);
        }
        catch (DiagException diagEx) {
            MissingInfoException miex = new MissingInfoException(var);
            miex.addChild(diagEx);
            throw miex;
        }
        catch (Exception ex) {
            MissingInfoException miex = new MissingInfoException(var);
            miex.addChild(new DiagException(ex.getMessage()));
            throw miex;
        }
    }

    private MessageText getMessageCacheEntry(String var) throws MissingInfoException {
        if (this.messageCache == null) {
            String resourceName = this.prop.getMessagesFile().getAbsolutePath();
            InputStream in = this.getMessageFileInputStream(this.prop.getMessagesFile());
            if (in == null) {
                MissingInfoException fileEx = new MissingInfoException(resourceName);
                resourceName = this.prop.getMessagesFileName();
                in = this.getMessageFileInputStream(resourceName);
                if (in == null) {
                    MissingInfoException resourceEx = new MissingInfoException(resourceName);
                    resourceEx.addChild(fileEx);
                    throw resourceEx;
                }
            }
            try {
                this.messageCache = this.loadXMLMessageFile(in);
            }
            catch (DiagException diagEx) {
                MissingInfoException miEx = new MissingInfoException(resourceName);
                miEx.addChild(diagEx);
                throw miEx;
            }
            catch (Exception ex) {
                MissingInfoException miEx = new MissingInfoException(resourceName);
                miEx.addChild(new DiagException(ex.getMessage()));
                throw miEx;
            }
        }
        MessageText text = (MessageText)this.messageCache.get(var);
        return text;
    }

    private InputStream getMessageFileInputStream(String resourceName) {
        resourceName = resourceName.replace('\\', '/');
        try {
            ClassLoader loader = this.getClass().getClassLoader();
            URL textURL = loader.getResource(resourceName);
            return textURL == null ? null : textURL.openStream();
        }
        catch (IOException ioEx) {
            return null;
        }
    }

    private InputStream getMessageFileInputStream(File file) {
        try {
            return new FileInputStream(file);
        }
        catch (FileNotFoundException fileEx) {
            return null;
        }
    }

    protected Map loadXMLMessageFile(InputStream in) throws DiagException {
        TreeMap<String, MessageText> messMap = new TreeMap<String, MessageText>();
        BufferedReader reader = new BufferedReader(new InputStreamReader(in));
        XMLElementIF rootElem = XMLAdmin.createXMLElement(in);
        if (!rootElem.getName().equalsIgnoreCase("jump-container")) {
            throw new WrongSyntaxException(rootElem.getName(), "jump-container");
        }
        String type = rootElem.getAttrString("type");
        if (!type.equals("message")) {
            throw new WrongSyntaxException(type, "message");
        }
        Iterator subElemIterator = rootElem.getSubElements();
        while (subElemIterator.hasNext()) {
            XMLElementIF messElem = (XMLElementIF)subElemIterator.next();
            try {
                if (!messElem.getName().equalsIgnoreCase("message")) {
                    throw new WrongSyntaxException(messElem.getName(), "message");
                }
                String id = messElem.getAttrString("id");
                MessageText text = this.parseMessageXMLElement(messElem);
                messMap.put(id, text);
            }
            catch (WrongSyntaxException syntaxEx) {}
        }
        return messMap;
    }

    protected MessageText parseMessageXMLElement(XMLElementIF messElem) throws WrongSyntaxException {
        MessageText text = null;
        Iterator textElemIterator = messElem.getSubElements();
        XMLElementIF textElem = (XMLElementIF)textElemIterator.next();
        if (!textElem.getName().equalsIgnoreCase("short")) {
            throw new WrongSyntaxException(textElem.getName(), "short");
        }
        text = new MessageText(textElem.getContent());
        MessageText.LongText longText = null;
        if (textElemIterator.hasNext()) {
            textElem = (XMLElementIF)textElemIterator.next();
            if (!textElem.getName().equalsIgnoreCase("long")) {
                throw new WrongSyntaxException(textElem.getName(), "long");
            }
            Iterator longTextElemIterator = textElem.getSubElements();
            String symptom = null;
            String cause = null;
            String solution = null;
            while (textElemIterator.hasNext()) {
                textElem = (XMLElementIF)textElemIterator.next();
                if (textElem.getName().equalsIgnoreCase("symptom")) {
                    symptom = textElem.getContent();
                    continue;
                }
                if (textElem.getName().equalsIgnoreCase("cause")) {
                    cause = textElem.getContent();
                    continue;
                }
                if (textElem.getName().equalsIgnoreCase("solution")) {
                    solution = textElem.getContent();
                    continue;
                }
                throw new WrongSyntaxException(textElem.getName(), "symptom, cause, solution");
            }
            MessageText messageText = text;
            messageText.getClass();
            longText = messageText.new MessageText.LongText(symptom, cause, solution);
        }
        text.setLong(longText);
        return text;
    }
}

