/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdt.util.info;

import com.sap.sdt.util.diag.DiagException;
import com.sap.sdt.util.diag.JavaException;
import com.sap.sdt.util.diag.MissingInfoException;
import com.sap.sdt.util.diag.SDTFileNotFoundException;
import com.sap.sdt.util.info.InfoProviderFactoryProperties;
import com.sap.sdt.util.info.InfoProviderIF;
import com.sap.sdt.util.io.FileList;
import com.sap.sdt.util.prop.FactoryPropertiesCapableIF;
import com.sap.sdt.util.prop.FactoryPropertiesIF;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.Properties;

public abstract class AbstractInfoProvider
extends Properties
implements InfoProviderIF,
FilenameFilter,
FactoryPropertiesCapableIF {
    public static final String RCSINFO = "$Id: //sdt/com.sap.sdt/0.1/src/_util/java/com/sap/sdt/util/info/AbstractInfoProvider.java#2 $";
    protected InfoProviderFactoryProperties prop;

    AbstractInfoProvider() {
        super(System.getProperties());
        this.prop = new InfoProviderFactoryProperties();
    }

    AbstractInfoProvider(String name) {
        super(System.getProperties());
        this.prop = new InfoProviderFactoryProperties(name);
    }

    public void set(String var, String val) {
        this.setProperty(var, val);
    }

    public String get(String var) {
        try {
            return this.getE(var);
        }
        catch (MissingInfoException e) {
            return null;
        }
    }

    public String get(String var, String p0) {
        try {
            return this.getE(var, p0);
        }
        catch (MissingInfoException e) {
            return null;
        }
    }

    public String get(String var, String p0, String p1) {
        try {
            return this.getE(var, p0, p1);
        }
        catch (MissingInfoException e) {
            return null;
        }
    }

    public String get(String var, String[] params) {
        try {
            return this.getE(var, params);
        }
        catch (MissingInfoException e) {
            return null;
        }
    }

    public abstract String getE(String var1) throws MissingInfoException;

    public abstract String getE(String var1, String[] var2) throws MissingInfoException;

    public String getE(String var, String p0) throws MissingInfoException {
        String[] params = new String[]{p0};
        return this.getE(var, params);
    }

    public String getE(String var, String p0, String p1) throws MissingInfoException {
        String[] params = new String[]{p0, p1};
        return this.getE(var, params);
    }

    public boolean accept(File dir, String name) {
        return name.endsWith(".properties");
    }

    public void load(String pathName) throws DiagException {
        File[] files = FileList.getFileList(this, pathName);
        for (int i = 0; i < files.length; ++i) {
            try {
                FileInputStream stream = new FileInputStream(files[i]);
                this.load(stream);
                continue;
            }
            catch (FileNotFoundException fnfE) {
                throw new SDTFileNotFoundException(files[i].getAbsolutePath());
            }
            catch (IOException ioE) {
                throw new JavaException(ioE);
            }
        }
    }

    public FactoryPropertiesIF getFactoryProperties() {
        return this.prop;
    }

    public void setFactoryProperties(FactoryPropertiesIF prop) {
        this.prop = (InfoProviderFactoryProperties)prop;
    }
}

