/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdt.util.dialog;

import com.sap.sdt.util.diag.DiagException;
import com.sap.sdt.util.dialog.DefaultDialogAdapter;
import com.sap.sdt.util.dialog.UtilDialogCreateException;
import com.sap.sdt.util.dialog.UtilDialogFactory;
import com.sap.sdt.util.dialog.UtilDialogIF;
import com.sap.sdt.util.dialog.UtilDialogMessageException;
import com.sap.sdt.util.xml.XMLAdmin;
import com.sap.sdt.util.xml.XMLElementIF;
import com.sap.sdt.util.xml.XMLException;
import java.io.StringReader;
import java.io.StringWriter;

public class UtilDialogMessageFactory {
    public static final String RCSINFO = "$Id: //sdt/com.sap.sdt/0.1/src/_util/java/com/sap/sdt/util/dialog/UtilDialogMessageFactory.java#2 $";

    public static UtilDialogIF toDialog(String msg) throws UtilDialogCreateException {
        try {
            return UtilDialogMessageFactory.toDialog(UtilDialogMessageFactory.createElement(msg));
        }
        catch (DiagException e) {
            throw new UtilDialogCreateException(e, msg);
        }
    }

    public static UtilDialogIF toDialog(XMLElementIF rootElem) throws UtilDialogCreateException {
        try {
            DefaultDialogAdapter handler = new DefaultDialogAdapter();
            UtilDialogIF dialog = UtilDialogFactory.getDialog(rootElem, handler, null);
            return dialog;
        }
        catch (DiagException e) {
            throw new UtilDialogCreateException(e, rootElem.toString());
        }
    }

    public static String toString(UtilDialogIF dialog) throws UtilDialogMessageException {
        try {
            XMLElementIF rootElem = dialog.serialize(XMLAdmin.getNewElementFactory());
            return UtilDialogMessageFactory.createMessage(rootElem);
        }
        catch (DiagException e) {
            throw new UtilDialogMessageException(dialog, e);
        }
    }

    private static XMLElementIF createElement(String msg) throws XMLException {
        StringReader reader = new StringReader(msg);
        return XMLAdmin.createXMLElement(reader);
    }

    private static String createMessage(XMLElementIF rootElem) throws XMLException {
        StringWriter writer = new StringWriter();
        rootElem.toXML(writer);
        return writer.getBuffer().toString();
    }
}

