/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdt.util.dialog;

import com.sap.sdt.util.diag.DiagException;
import com.sap.sdt.util.diag.WrongSyntaxException;
import com.sap.sdt.util.dialog.CompositeDialog;
import com.sap.sdt.util.dialog.DialogConstants;
import com.sap.sdt.util.dialog.DialogTraceIF;
import com.sap.sdt.util.dialog.ExclusiveSelectionDialog;
import com.sap.sdt.util.dialog.FileInputDialog;
import com.sap.sdt.util.dialog.InfoDialog;
import com.sap.sdt.util.dialog.MultiSelectionDialog;
import com.sap.sdt.util.dialog.MultiTextInputDialog;
import com.sap.sdt.util.dialog.OKCancelDialog;
import com.sap.sdt.util.dialog.PasswordInputDialog;
import com.sap.sdt.util.dialog.SingleTextInputDialog;
import com.sap.sdt.util.dialog.TableInputDialog;
import com.sap.sdt.util.dialog.UtilDialogCreateException;
import com.sap.sdt.util.dialog.UtilDialogIF;
import com.sap.sdt.util.dialog.adapter.DialogAdapterIF;
import com.sap.sdt.util.validate.ValidatorContainer;
import com.sap.sdt.util.xml.XMLElementIF;

public class UtilDialogFactory
implements DialogConstants {
    public static final String RCSINFO = "$Id: //sdt/com.sap.sdt/0.1/src/_util/java/com/sap/sdt/util/dialog/UtilDialogFactory.java#2 $";
    private static final String[] dialogTypes = new String[10];

    public static SingleTextInputDialog getSingleTextInputDialog(String name, DialogAdapterIF handler, String varName) throws UtilDialogCreateException {
        return new SingleTextInputDialog(name, handler, varName);
    }

    public static PasswordInputDialog getPasswordInputDialog(String name, DialogAdapterIF handler, String varName, boolean retypePassword) throws UtilDialogCreateException {
        return new PasswordInputDialog(name, handler, varName, retypePassword);
    }

    public static FileInputDialog getFileInputDialog(String name, DialogAdapterIF handler, String varName) throws UtilDialogCreateException {
        return new FileInputDialog(name, handler, varName);
    }

    public static UtilDialogIF getInfoDialog(String name, String infoText) {
        InfoDialog dialog = new InfoDialog(name, infoText);
        return dialog;
    }

    public static OKCancelDialog getOKCancelDialog(String name, DialogAdapterIF handler, String varName) throws UtilDialogCreateException {
        return new OKCancelDialog(name, handler, varName);
    }

    public static TableInputDialog getTableInputDialog(String name, DialogAdapterIF handler, String varName) throws UtilDialogCreateException {
        return new TableInputDialog(name, handler, varName);
    }

    public static CompositeDialog getCompositeDialog(String name) throws UtilDialogCreateException {
        return new CompositeDialog(name);
    }

    public static UtilDialogIF getDialog(XMLElementIF rootElem, DialogAdapterIF handler, ValidatorContainer container) throws UtilDialogCreateException {
        try {
            return UtilDialogFactory.getDialog(rootElem.getAttrString("name"), rootElem, handler, container);
        }
        catch (DiagException diage) {
            throw new UtilDialogCreateException(diage);
        }
    }

    public static UtilDialogIF getDialog(String name, XMLElementIF rootElem, DialogAdapterIF handler, ValidatorContainer container) throws UtilDialogCreateException {
        try {
            String rootElemName = rootElem.getName();
            if (rootElemName.equals("SingleTextInput")) {
                return new SingleTextInputDialog(name, handler, rootElem, container);
            }
            if (rootElemName.equals("MultiTextInput")) {
                return new MultiTextInputDialog(name, handler, rootElem, container);
            }
            if (rootElemName.equals("ExclusiveSelection")) {
                return new ExclusiveSelectionDialog(name, handler, rootElem, container);
            }
            if (rootElemName.equals("MultiSelection")) {
                return new MultiSelectionDialog(name, handler, rootElem, container);
            }
            if (rootElemName.equals("OKCancel")) {
                return new OKCancelDialog(name, handler, rootElem, container);
            }
            if (rootElemName.equals("InfoText")) {
                return new InfoDialog(name, rootElem, container);
            }
            if (rootElemName.equals("Composite")) {
                return new CompositeDialog(name, handler, rootElem, container);
            }
            if (rootElemName.equals("PasswordInput")) {
                return new PasswordInputDialog(name, handler, rootElem, container);
            }
            if (rootElemName.equals("FileInput")) {
                return new FileInputDialog(name, handler, rootElem, container);
            }
            if (rootElemName.equals("TableInput")) {
                return new TableInputDialog(name, handler, rootElem, container);
            }
            String expected = "SingleTextInput,MultiTextInput,ExclusiveSelection,MultiSelection,OKCancel,Composite,InfoText,PasswordInput,FileInput,TableInput";
            throw new WrongSyntaxException(rootElemName, expected);
        }
        catch (DiagException diage) {
            DialogTraceIF.trc.error(UtilDialogFactory.class, "Unable to create dialog " + name + ": " + diage.getMessage());
            throw new UtilDialogCreateException(name, diage);
        }
    }

    public static int getDialogType(String name) {
        int type = -1;
        for (int i = 0; i < 10; ++i) {
            if (!name.equals(dialogTypes[i])) continue;
            type = i;
            break;
        }
        return type;
    }

    static {
        UtilDialogFactory.dialogTypes[0] = "SingleTextInput";
        UtilDialogFactory.dialogTypes[1] = "MultiTextInput";
        UtilDialogFactory.dialogTypes[2] = "ExclusiveSelection";
        UtilDialogFactory.dialogTypes[3] = "MultiSelection";
        UtilDialogFactory.dialogTypes[4] = "OKCancel";
        UtilDialogFactory.dialogTypes[5] = "InfoText";
        UtilDialogFactory.dialogTypes[6] = "Composite";
        UtilDialogFactory.dialogTypes[7] = "PasswordInput";
        UtilDialogFactory.dialogTypes[8] = "FileInput";
        UtilDialogFactory.dialogTypes[9] = "TableInput";
    }
}

