/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdt.util.dialog;

import com.sap.sdt.util.diag.DiagException;
import com.sap.sdt.util.diag.WrongSyntaxException;
import com.sap.sdt.util.dialog.AbstractVariableDialog;
import com.sap.sdt.util.dialog.UtilDialogCreateException;
import com.sap.sdt.util.dialog.UtilDialogIF;
import com.sap.sdt.util.dialog.UtilDialogSerializeException;
import com.sap.sdt.util.dialog.VariableUpdateException;
import com.sap.sdt.util.dialog.adapter.DialogAdapterIF;
import com.sap.sdt.util.validate.ValidatorContainer;
import com.sap.sdt.util.value.table.StringTable;
import com.sap.sdt.util.value.table.TableDisplayDescription;
import com.sap.sdt.util.value.table.TableIF;
import com.sap.sdt.util.value.table.TableModel;
import com.sap.sdt.util.xml.XMLElementFactoryIF;
import com.sap.sdt.util.xml.XMLElementIF;
import java.util.Iterator;

public class TableInputDialog
extends AbstractVariableDialog {
    public static final String RCSINFO = "$Id: //sdt/com.sap.sdt/0.1/src/_util/java/com/sap/sdt/util/dialog/TableInputDialog.java#2 $";
    protected String heading = null;
    protected TableModel tableModel = null;
    protected TableDisplayDescription tableDisplay = null;

    public TableInputDialog(String name, DialogAdapterIF handler, String varName) throws UtilDialogCreateException {
        super(name, handler, varName);
    }

    public TableInputDialog(String name, DialogAdapterIF handler, XMLElementIF elem, ValidatorContainer container) throws UtilDialogCreateException {
        super(name, handler, elem, container);
        this.deserializeBody(elem);
    }

    protected Object getAutoCreateValue() {
        return new StringTable(new String[]{"COLUMN1"}, 1);
    }

    public String getType() {
        return "TableInput";
    }

    public void setHeading(String heading) {
        this.heading = heading;
    }

    public String getHeading() {
        return this.heading;
    }

    public TableModel getTableModel() {
        return this.tableModel;
    }

    protected void serializeBody(XMLElementFactoryIF xmlFactory, XMLElementIF rootElem) throws UtilDialogSerializeException {
        try {
            XMLElementIF subElem = null;
            if (this.heading != null) {
                subElem = xmlFactory.createXMLElement();
                subElem.setName("HEADING");
                subElem.setContent(this.heading);
                rootElem.add(subElem);
            }
            if (this.tableDisplay != null) {
                this.tableDisplay.serialize(rootElem);
            }
            subElem = xmlFactory.createXMLElement();
            subElem.setName("VARIABLE");
            subElem.setContent(this.variable.getName());
            rootElem.add(subElem);
            this.serializeVariableValue(this.variable.getValue(), rootElem);
        }
        catch (DiagException e) {
            throw new UtilDialogSerializeException(this.getName(), e);
        }
    }

    protected void deserializeBody(XMLElementIF elem) throws UtilDialogCreateException {
        try {
            Iterator subElemIterator = elem.getSubElements();
            boolean setVariableValue = false;
            Object value = null;
            while (subElemIterator.hasNext()) {
                XMLElementIF subElem = (XMLElementIF)subElemIterator.next();
                String subElemName = subElem.getName();
                if (subElemName.equals("HEADING")) {
                    this.setHeading(subElem.getContent());
                    continue;
                }
                if (subElemName.equals("VARIABLE")) {
                    String varName = subElem.getContent();
                    this.autoCreateVariable(varName);
                    this.setVariable(varName);
                    continue;
                }
                if (subElemName.equals("VALUE")) {
                    value = this.deserializeVariableValue(subElem);
                    setVariableValue = true;
                    continue;
                }
                if (subElemName.equals("DISPLAY")) {
                    this.tableDisplay = new TableDisplayDescription(subElem);
                    continue;
                }
                String expected = "HEADING,VARIABLE,VALUE";
                throw new WrongSyntaxException(subElemName, expected);
            }
            if (setVariableValue) {
                this.variable.setValue(value);
            }
            this.createElements();
        }
        catch (DiagException diagEx) {
            UtilDialogCreateException e = new UtilDialogCreateException(this.name, diagEx);
            this.log.error(this.getClass(), e);
            throw e;
        }
    }

    public void createElements() throws UtilDialogCreateException {
        try {
            TableIF table = (TableIF)this.variable.getValue();
            if (this.tableDisplay == null) {
                this.tableModel = new TableModel(table, new TableDisplayDescription(table));
            } else {
                this.tableDisplay.update(table);
                this.tableModel = new TableModel(table, this.tableDisplay);
            }
        }
        catch (DiagException e) {
            throw new UtilDialogCreateException(e);
        }
    }

    public void updateElements(UtilDialogIF fromDialog) {
        TableInputDialog from = (TableInputDialog)fromDialog;
        this.tableModel.updateTable(from.getTableModel().getTable());
    }

    public void updateVariables() throws VariableUpdateException {
        TableIF value = this.tableModel.getTable();
        try {
            this.variable.setValue(value);
            Object[] logParams = new Object[]{this.getName(), this.variable.getName(), "", value};
            this.log.info(this.getClass(), "msg.util.dialog.0008", logParams);
        }
        catch (DiagException e) {
            throw new VariableUpdateException(this.variable.getName(), value);
        }
    }

    public Object getValidateableValue() {
        return this.tableModel.getTable();
    }
}

