/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdt.util.dialog;

import com.sap.sdt.util.diag.DiagException;
import com.sap.sdt.util.diag.WrongSyntaxException;
import com.sap.sdt.util.dialog.AbstractVariableDialog;
import com.sap.sdt.util.dialog.InputField;
import com.sap.sdt.util.dialog.UtilDialogCreateException;
import com.sap.sdt.util.dialog.UtilDialogIF;
import com.sap.sdt.util.dialog.UtilDialogSerializeException;
import com.sap.sdt.util.dialog.VariableUpdateException;
import com.sap.sdt.util.dialog.adapter.DialogAdapterIF;
import com.sap.sdt.util.validate.ValidatorContainer;
import com.sap.sdt.util.xml.XMLElementFactoryIF;
import com.sap.sdt.util.xml.XMLElementIF;
import java.util.Iterator;

public class SingleTextInputDialog
extends AbstractVariableDialog {
    public static final String RCSINFO = "$Id: //sdt/com.sap.sdt/0.1/src/_util/java/com/sap/sdt/util/dialog/SingleTextInputDialog.java#2 $";
    protected String heading = null;
    protected String label = "";
    protected InputField inputField = null;

    public SingleTextInputDialog(String name, DialogAdapterIF handler, String varName) throws UtilDialogCreateException {
        super(name, handler, varName);
    }

    public SingleTextInputDialog(String name, DialogAdapterIF handler, XMLElementIF elem, ValidatorContainer vContainer) throws UtilDialogCreateException {
        super(name, handler, elem, vContainer);
        this.deserializeBody(elem);
    }

    public String getType() {
        return "SingleTextInput";
    }

    protected void serializeBody(XMLElementFactoryIF xmlFactory, XMLElementIF rootElem) throws UtilDialogSerializeException {
        try {
            XMLElementIF subElem = null;
            if (this.heading != null) {
                subElem = xmlFactory.createXMLElement();
                subElem.setName("HEADING");
                subElem.setContent(this.heading);
                rootElem.add(subElem);
            }
            subElem = xmlFactory.createXMLElement();
            subElem.setName("LABEL");
            subElem.setContent(this.label);
            rootElem.add(subElem);
            subElem = xmlFactory.createXMLElement();
            subElem.setName("VARIABLE");
            subElem.setContent(this.variable.getName());
            rootElem.add(subElem);
            this.serializeVariableValue(this.variable.getValue(), rootElem);
        }
        catch (DiagException e) {
            throw new UtilDialogSerializeException(this.getName(), e);
        }
    }

    protected void deserializeBody(XMLElementIF elem) throws UtilDialogCreateException {
        try {
            Iterator subElemIterator = elem.getSubElements();
            boolean setVariableValue = false;
            Object value = null;
            while (subElemIterator.hasNext()) {
                XMLElementIF subElem = (XMLElementIF)subElemIterator.next();
                String subElemName = subElem.getName();
                if (subElemName.equals("HEADING")) {
                    this.setHeading(subElem.getContent());
                    continue;
                }
                if (subElemName.equals("LABEL")) {
                    this.setLabel(subElem.getContent());
                    continue;
                }
                if (subElemName.equals("VARIABLE")) {
                    String varName = subElem.getContent();
                    this.autoCreateVariable(varName);
                    this.setVariable(varName);
                    continue;
                }
                if (subElemName.equals("VALUE")) {
                    value = this.deserializeVariableValue(subElem);
                    setVariableValue = true;
                    continue;
                }
                String expected = "HEADING,LABEL,VARIABLE,VALUE";
                throw new WrongSyntaxException(subElemName, expected);
            }
            if (setVariableValue) {
                this.variable.setValue(value);
            }
            this.createElements();
        }
        catch (DiagException diagEx) {
            UtilDialogCreateException e = new UtilDialogCreateException(this.name, diagEx);
            this.log.error(this.getClass(), e);
            throw e;
        }
    }

    protected Object getAutoCreateValue() {
        return "";
    }

    public void setHeading(String heading) {
        this.heading = heading;
    }

    public String getHeading() {
        return this.heading;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public String getLabel() {
        return this.label;
    }

    public InputField getInputField() {
        return this.inputField;
    }

    public void createElements() {
        this.inputField = new InputField(this.variable.getValue(), this.label);
        this.inputField.setEncryptsValue(this.variable.encryptsValue());
    }

    public void updateElements(UtilDialogIF fromDialog) {
        SingleTextInputDialog from = (SingleTextInputDialog)fromDialog;
        this.inputField.updateValue(from.getInputField().getValue());
    }

    public void updateVariables() throws VariableUpdateException {
        Object value = this.inputField.getValue();
        try {
            this.variable.setValue(value);
            Object[] logParams = new Object[]{this.getName(), this.variable.getName(), this.label, value};
            this.log.info(this.getClass(), "msg.util.dialog.0008", logParams);
        }
        catch (DiagException e) {
            throw new VariableUpdateException(this.variable.getName(), value);
        }
    }

    public Object getValidateableValue() {
        return this.inputField.getValue();
    }
}

