/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdt.util.dialog;

import com.sap.sdt.util.dialog.AbstractDialogElement;
import com.sap.sdt.util.dialog.RadioButton;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class RadioButtonGroup
extends AbstractDialogElement {
    public static final String RCSINFO = "$Id: //sdt/com.sap.sdt/0.1/src/_util/java/com/sap/sdt/util/dialog/RadioButtonGroup.java#2 $";
    private List buttons = new ArrayList();

    public RadioButtonGroup() {
        this.buttons = new ArrayList();
    }

    public RadioButtonGroup(int initialCapacity) {
        this.buttons = new ArrayList(initialCapacity);
    }

    public String toString() {
        return this.getSelection().getLabel().toString();
    }

    public void add(RadioButton button) {
        if (button.isSelected()) {
            this.turnAllOff();
        }
        this.buttons.add(button);
        if (this.getSelection() == null) {
            this.turnOneOn();
        }
    }

    public RadioButton getRadioButton(int index) {
        return (RadioButton)this.buttons.get(index);
    }

    public int getRadioButtonCount() {
        return this.buttons.size();
    }

    public RadioButton getSelection() {
        Iterator it = this.buttons.iterator();
        while (it.hasNext()) {
            RadioButton button = (RadioButton)it.next();
            if (!button.isSelected()) continue;
            return button;
        }
        return null;
    }

    public void remove(RadioButton button) {
        this.buttons.remove(button);
        if (button.isSelected()) {
            this.turnOneOn();
        }
    }

    public void setSelected(RadioButton button) {
        this.setSelected(button, true);
    }

    public void setSelected(RadioButton button, boolean value) {
        boolean previousValue = button.isSelected();
        if (value != previousValue) {
            if (value) {
                this.getSelection().setSelected(false);
                button.setSelected(true);
            } else {
                button.setSelected(false);
                this.turnOneOn();
            }
        }
    }

    protected void turnAllOff() {
        Iterator it = this.buttons.iterator();
        while (it.hasNext()) {
            RadioButton button = (RadioButton)it.next();
            button.setSelected(false);
        }
    }

    protected void turnOneOn() {
        block0: {
            Iterator it = this.buttons.iterator();
            if (!it.hasNext()) break block0;
            RadioButton button = (RadioButton)it.next();
            button.setSelected(true);
        }
    }
}

