/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdt.util.dialog;

import com.sap.sdt.util.dialog.InputField;
import com.sap.sdt.util.dialog.MsgIdConstants;
import com.sap.sdt.util.dialog.SingleTextInputDialog;
import com.sap.sdt.util.dialog.UtilDialogCreateException;
import com.sap.sdt.util.dialog.UtilDialogIF;
import com.sap.sdt.util.dialog.UtilDialogSerializeException;
import com.sap.sdt.util.dialog.VariableUpdateException;
import com.sap.sdt.util.dialog.adapter.DialogAdapterIF;
import com.sap.sdt.util.dialog.adapter.DialogVariableSetException;
import com.sap.sdt.util.validate.ValidationError;
import com.sap.sdt.util.validate.ValidationException;
import com.sap.sdt.util.validate.ValidationFailureException;
import com.sap.sdt.util.validate.ValidationProcessor;
import com.sap.sdt.util.validate.ValidatorContainer;
import com.sap.sdt.util.value.Password;
import com.sap.sdt.util.xml.XMLElementFactoryIF;
import com.sap.sdt.util.xml.XMLElementIF;
import com.sap.sdt.util.xml.XMLException;

public class PasswordInputDialog
extends SingleTextInputDialog
implements MsgIdConstants {
    public static final String RCSINFO = "$Id: //sdt/com.sap.sdt/0.1/src/_util/java/com/sap/sdt/util/dialog/PasswordInputDialog.java#2 $";
    private boolean retypePassword = true;
    protected InputField retypeInputField;

    public PasswordInputDialog(String name, DialogAdapterIF handler, String varName) throws UtilDialogCreateException {
        this(name, handler, varName, true);
    }

    public PasswordInputDialog(String name, DialogAdapterIF handler, String varName, boolean retypePassword) throws UtilDialogCreateException {
        super(name, handler, varName);
        this.setRetypePassword(retypePassword);
    }

    public PasswordInputDialog(String name, DialogAdapterIF handler, XMLElementIF elem, ValidatorContainer vContainer) throws UtilDialogCreateException {
        super(name, handler, elem, vContainer);
        this.deserializeBody(elem);
    }

    public String getType() {
        return "PasswordInput";
    }

    protected void deserializeBody(XMLElementIF elem) throws UtilDialogCreateException {
        try {
            this.setRetypePassword(elem.getAttrBoolean("retype"));
        }
        catch (XMLException e) {
            this.setRetypePassword(true);
        }
        super.deserializeBody(elem);
    }

    protected void serializeBody(XMLElementFactoryIF xmlFactory, XMLElementIF rootElem) throws UtilDialogSerializeException {
        Boolean b = new Boolean(this.retypePassword);
        rootElem.setAttr("retype", b.toString());
        super.serializeBody(xmlFactory, rootElem);
    }

    protected Object getAutoCreateValue() {
        return new Password("");
    }

    public void createElements() {
        this.inputField = new InputField(this.variable.getValue(), this.label);
        this.inputField.setEncryptsValue(true);
        if (this.retypePassword) {
            this.retypeInputField = new InputField(this.variable.getValue(), this.label);
            this.retypeInputField.setEncryptsValue(true);
        }
    }

    public void updateElements(UtilDialogIF fromDialog) {
        PasswordInputDialog from = (PasswordInputDialog)fromDialog;
        this.inputField.updateValue(from.getInputField().getValue());
        if (this.retypePassword) {
            this.retypeInputField.updateValue(from.getRetypeInputField().getValue());
        }
    }

    public void validateInput(ValidationProcessor processor) throws ValidationException, ValidationFailureException {
        super.validateInput(processor);
        if (this.retypePassword && !this.retypeInputField.getValue().equals(this.inputField.getValue())) {
            throw new ValidationException(new ValidationError(this, "msg.util.dialog.0013", "PasswordInputDialog_internal"));
        }
    }

    public void updateVariables() throws VariableUpdateException {
        try {
            Object value = this.inputField.getValue();
            this.variable.setValue(value);
            Object[] logParams = new Object[]{this.getName(), this.variable.getName(), this.label};
            this.log.info(this.getClass(), "msg.util.dialog.0009", logParams);
        }
        catch (DialogVariableSetException e) {
            throw new VariableUpdateException(this.variable.getName(), (Object)e);
        }
    }

    public boolean getRetypePassword() {
        return this.retypePassword;
    }

    public void setRetypePassword(boolean retypePassword) {
        this.retypePassword = retypePassword;
    }

    public InputField getRetypeInputField() {
        return this.retypeInputField;
    }
}

