/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdt.util.dialog;

import com.sap.sdt.util.diag.DiagException;
import com.sap.sdt.util.diag.WrongSyntaxException;
import com.sap.sdt.util.dialog.AbstractVariableDialog;
import com.sap.sdt.util.dialog.PushButton;
import com.sap.sdt.util.dialog.UpdateHandlerException;
import com.sap.sdt.util.dialog.UtilDialogCreateException;
import com.sap.sdt.util.dialog.UtilDialogIF;
import com.sap.sdt.util.dialog.UtilDialogSerializeException;
import com.sap.sdt.util.dialog.VariableUpdateException;
import com.sap.sdt.util.dialog.adapter.DialogAdapterIF;
import com.sap.sdt.util.dialog.adapter.DialogVariableSetException;
import com.sap.sdt.util.validate.ValidatorContainer;
import com.sap.sdt.util.xml.XMLAdmin;
import com.sap.sdt.util.xml.XMLElementFactoryIF;
import com.sap.sdt.util.xml.XMLElementIF;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class OKCancelDialog
extends AbstractVariableDialog {
    public static final String RCSINFO = "$Id: //sdt/com.sap.sdt/0.1/src/_util/java/com/sap/sdt/util/dialog/OKCancelDialog.java#2 $";
    public static final String OK_TEXT = "Continue";
    public static final String CANCEL_TEXT = "Cancel";
    private PushButton okButton = null;
    private PushButton cancelButton = null;

    public OKCancelDialog(String name, DialogAdapterIF handler, String varName) throws UtilDialogCreateException {
        super(name, handler, varName);
    }

    public OKCancelDialog(String name, DialogAdapterIF handler, XMLElementIF elem, ValidatorContainer vContainer) throws UtilDialogCreateException {
        super(name, handler, elem, vContainer);
        this.deserializeBody(elem);
    }

    public String getType() {
        return "OKCancel";
    }

    protected void serializeBody(XMLElementFactoryIF xmlFactory, XMLElementIF rootElem) throws UtilDialogSerializeException {
        try {
            XMLElementIF subElem = XMLAdmin.createXMLElement();
            subElem.setName("VARIABLE");
            subElem.setContent(this.variable.getName());
            rootElem.add(subElem);
            this.serializeVariableValue(this.variable.getValue(), rootElem);
        }
        catch (DiagException e) {
            throw new UtilDialogSerializeException(this.getName(), e);
        }
    }

    protected void deserializeBody(XMLElementIF elem) throws UtilDialogCreateException {
        try {
            Iterator it = elem.getSubElements();
            boolean setVariableValue = false;
            Object value = null;
            while (it.hasNext()) {
                XMLElementIF subElem = (XMLElementIF)it.next();
                if (subElem.getName().equals("VARIABLE")) {
                    String varName = subElem.getContent();
                    this.autoCreateVariable(varName);
                    this.setVariable(varName);
                    continue;
                }
                if (subElem.getName().equals("VALUE")) {
                    value = this.deserializeVariableValue(subElem);
                    setVariableValue = true;
                    continue;
                }
                String expected = "VARIABLE,VALUE";
                throw new WrongSyntaxException(subElem.getName(), expected);
            }
            if (setVariableValue) {
                this.variable.setValue(value);
            }
            this.createElements();
        }
        catch (DiagException diagEx) {
            UtilDialogCreateException e = new UtilDialogCreateException(this.name, diagEx);
            this.log.error(this.getClass(), e);
            throw e;
        }
    }

    protected Object getAutoCreateValue() {
        return OK_TEXT;
    }

    public void createElements() {
        this.okButton = new PushButton();
        this.okButton.setActionCommand(OK_TEXT);
        this.okButton.setText(OK_TEXT);
        if (this.variable.getValue().equals(this.okButton.getActionCommand())) {
            this.okButton.setValue(true);
        }
        this.cancelButton = new PushButton();
        this.cancelButton.setActionCommand(CANCEL_TEXT);
        this.cancelButton.setText(CANCEL_TEXT);
        if (this.variable.getValue().equals(this.cancelButton.getActionCommand())) {
            this.cancelButton.setValue(true);
        }
    }

    public void updateElements(UtilDialogIF fromDialog) {
        OKCancelDialog from = (OKCancelDialog)fromDialog;
        this.okButton.setValue(from.okButton.getValue());
        this.cancelButton.setValue(from.cancelButton.getValue());
    }

    public void updateVariables() throws VariableUpdateException {
        String value;
        String label;
        if (this.okButton.getValue()) {
            label = this.okButton.getText();
            value = this.okButton.getActionCommand();
        } else {
            label = this.cancelButton.getText();
            value = this.cancelButton.getActionCommand();
        }
        try {
            this.variable.setValue(value);
        }
        catch (DialogVariableSetException e) {
            throw new VariableUpdateException(this.variable.getName(), (Object)e);
        }
        Object[] logParams = new Object[]{this.getName(), this.variable.getName(), label, value};
        this.log.info(this.getClass(), "msg.util.dialog.0008", logParams);
        if (this.isConfirmed()) {
            this.log.info(this.getClass(), "msg.util.dialog.0010", this.getName());
        } else {
            this.log.warning(this.getClass(), "msg.util.dialog.0011", this.getName());
            trc.info(this.getClass(), "Dialog name \"{0}\" type \"{1}\" was canceled", this.getName(), this.getType());
            try {
                this.updateHandler();
            }
            catch (UpdateHandlerException e) {
                // empty catch block
            }
        }
    }

    public void setConfirmed(boolean value) {
        this.okButton.setValue(value);
        this.cancelButton.setValue(!value);
    }

    public boolean isConfirmed() {
        boolean isConfirmed = this.okButton.getValue();
        return isConfirmed;
    }

    public List getButtons() {
        ArrayList<PushButton> buttons = new ArrayList<PushButton>(2);
        buttons.add(this.okButton);
        buttons.add(this.cancelButton);
        return buttons;
    }

    public Object getValidateableValue() {
        if (this.okButton.getValue()) {
            return this.okButton.getActionCommand();
        }
        return this.cancelButton.getText();
    }
}

