/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdt.util.dialog;

import com.sap.sdt.util.diag.DiagException;
import com.sap.sdt.util.diag.WrongSyntaxException;
import com.sap.sdt.util.dialog.AbstractVariableDialog;
import com.sap.sdt.util.dialog.InputField;
import com.sap.sdt.util.dialog.UtilDialogCreateException;
import com.sap.sdt.util.dialog.UtilDialogIF;
import com.sap.sdt.util.dialog.UtilDialogSerializeException;
import com.sap.sdt.util.dialog.VariableUpdateException;
import com.sap.sdt.util.dialog.adapter.DialogAdapterIF;
import com.sap.sdt.util.dialog.adapter.DialogVariableNotFoundException;
import com.sap.sdt.util.dialog.adapter.DialogVariableSetException;
import com.sap.sdt.util.validate.ValidatorContainer;
import com.sap.sdt.util.value.StringArray;
import com.sap.sdt.util.value.UnknownTypeException;
import com.sap.sdt.util.value.ValueDeserializeException;
import com.sap.sdt.util.xml.XMLElementFactoryIF;
import com.sap.sdt.util.xml.XMLElementIF;
import com.sap.sdt.util.xml.XMLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class MultiTextInputDialog
extends AbstractVariableDialog {
    public static final String RCSINFO = "$Id: //sdt/com.sap.sdt/0.1/src/_util/java/com/sap/sdt/util/dialog/MultiTextInputDialog.java#2 $";
    private String heading = null;
    private String label = "";
    private List labelList = null;
    private String replacement = "$(inx)";
    private LabelFormatIF format = null;
    private InputField[] inputField = null;

    public MultiTextInputDialog(String name, DialogAdapterIF handler, String varName) throws UtilDialogCreateException {
        super(name, handler, varName);
    }

    public MultiTextInputDialog(String name, DialogAdapterIF handler, XMLElementIF elem, ValidatorContainer vContainer) throws UtilDialogCreateException {
        super(name, handler, elem, vContainer);
        this.deserializeBody(elem);
    }

    public String getType() {
        return "MultiTextInput";
    }

    protected void serializeBody(XMLElementFactoryIF xmlFactory, XMLElementIF rootElem) throws UtilDialogSerializeException {
        try {
            XMLElementIF subElem = null;
            if (this.heading != null) {
                subElem = xmlFactory.createXMLElement();
                subElem.setName("HEADING");
                subElem.setContent(this.heading);
                rootElem.add(subElem);
            }
            StringArray value = this.getStringArray();
            for (int i = 0; i < this.inputField.length; ++i) {
                subElem = xmlFactory.createXMLElement();
                subElem.setName("INPUT");
                XMLElementIF varElem = xmlFactory.createXMLElement();
                varElem.setName("LABEL");
                varElem.setContent(this.inputField[i].getLabel().getText());
                subElem.add(varElem);
                varElem = xmlFactory.createXMLElement();
                varElem.setName("VARIABLE");
                varElem.setContent(this.variable.getName());
                varElem.setAttr("index", "" + i);
                subElem.add(varElem);
                this.serializeVariableValue(value.get(i), subElem);
                rootElem.add(subElem);
            }
        }
        catch (DiagException e) {
            throw new UtilDialogSerializeException(this.getName(), e);
        }
    }

    protected void deserializeBody(XMLElementIF elem) throws UtilDialogCreateException {
        try {
            Iterator subElemIterator = elem.getSubElements();
            Object value = null;
            boolean setVariableValue = false;
            while (subElemIterator.hasNext()) {
                XMLElementIF subElem = (XMLElementIF)subElemIterator.next();
                String subElemName = subElem.getName();
                if (subElemName.equals("HEADING")) {
                    this.setHeading(subElem.getContent());
                    continue;
                }
                if (subElemName.equals("LABEL")) {
                    this.setLabel(subElem.getContent());
                    continue;
                }
                if (subElemName.equals("VARIABLE")) {
                    String varName = subElem.getContent();
                    this.autoCreateVariable(varName);
                    this.setVariable(varName);
                    continue;
                }
                if (subElem.getName().equals("VALUE")) {
                    value = this.deserializeVariableValue(subElem);
                    setVariableValue = true;
                    continue;
                }
                if (subElem.getName().equals("INPUT")) {
                    this.deserializeInput(subElem);
                    continue;
                }
                String expected = "HEADING,LABEL,VARIABLE,VALUE,INPUT";
                throw new WrongSyntaxException(subElemName, expected);
            }
            if (setVariableValue) {
                this.variable.setValue(value);
            }
            this.createElements();
        }
        catch (DiagException diagEx) {
            UtilDialogCreateException e = new UtilDialogCreateException(this.name, diagEx);
            this.log.error(this.getClass(), e);
            throw e;
        }
    }

    protected void deserializeInput(XMLElementIF subElem) throws NumberFormatException, UnknownTypeException, ValueDeserializeException, DialogVariableNotFoundException, XMLException, WrongSyntaxException, DialogVariableSetException {
        Iterator inputElements = subElem.getSubElements();
        String labelElement = null;
        boolean setLabelElement = false;
        String varName = null;
        int index = -1;
        Object elementValue = null;
        boolean setVariableValueElement = false;
        while (inputElements.hasNext()) {
            XMLElementIF inputElem = (XMLElementIF)inputElements.next();
            if (inputElem.getName().equals("LABEL")) {
                labelElement = inputElem.getContent();
                setLabelElement = true;
                continue;
            }
            if (inputElem.getName().equals("VARIABLE")) {
                varName = inputElem.getContent();
                this.autoCreateVariable(varName);
                this.setVariable(varName);
                index = Integer.parseInt(inputElem.getAttrString("index"));
                continue;
            }
            if (inputElem.getName().equals("VALUE")) {
                elementValue = this.deserializeVariableValue(inputElem);
                setVariableValueElement = true;
                continue;
            }
            String expected = "LABEL,VARIABLE,VALUE";
            throw new WrongSyntaxException(inputElem.getName(), expected);
        }
        if (index >= 0) {
            if (setLabelElement) {
                this.setLabel(index, labelElement);
            }
            if (setVariableValueElement) {
                StringArray value = this.getStringArray();
                if (value.size() < index + 1) {
                    value.add(index, elementValue.toString());
                } else {
                    value.set(index, elementValue.toString());
                }
                this.variable.setValue(value);
            }
        }
    }

    protected Object getAutoCreateValue() {
        StringArray value = new StringArray();
        value.add("");
        return value;
    }

    private StringArray getStringArray() {
        return (StringArray)this.variable.getValue();
    }

    public void setHeading(String heading) {
        this.heading = heading;
    }

    public String getHeading() {
        return this.heading;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public String getLabel() {
        return this.label;
    }

    public InputField[] getInputFieldArray() {
        return this.inputField;
    }

    protected String getLabel(int index) {
        if (this.format != null) {
            return this.format.format(this.label, index + 1);
        }
        if (this.labelList != null) {
            return (String)this.labelList.get(index);
        }
        int fromIndex = this.label.indexOf(this.replacement);
        if (fromIndex < 0) {
            return this.label;
        }
        int toIndex = fromIndex + this.replacement.length();
        return this.label.substring(0, fromIndex) + Integer.toString(index + 1) + this.label.substring(toIndex);
    }

    private void setLabel(int index, String label) {
        if (this.labelList == null) {
            this.labelList = new ArrayList();
        }
        if (index < this.labelList.size()) {
            this.labelList.set(index, label);
        } else {
            this.labelList.add(index, label);
        }
    }

    public void setReplacement(String replacement) {
        this.replacement = replacement;
    }

    public String getReplacement() {
        return this.replacement;
    }

    public void setLabelFormat(LabelFormatIF format) {
        this.format = format;
    }

    public void createElements() {
        StringArray value = this.getStringArray();
        this.inputField = new InputField[value.size()];
        for (int i = 0; i < this.inputField.length; ++i) {
            this.inputField[i] = new InputField(value.get(i), this.getLabel(i));
        }
    }

    public void updateElements(UtilDialogIF fromDialog) {
        MultiTextInputDialog from = (MultiTextInputDialog)fromDialog;
        InputField[] fromInputField = from.getInputFieldArray();
        for (int i = 0; i < this.inputField.length; ++i) {
            this.inputField[i].updateValue(fromInputField[i].getValue());
        }
    }

    public void updateVariables() throws VariableUpdateException {
        StringArray value = this.getStringArray();
        for (int i = 0; i < this.inputField.length; ++i) {
            String s = (String)this.inputField[i].getValue();
            value.set(i, s);
        }
        try {
            this.variable.setValue(value);
        }
        catch (DialogVariableSetException e) {
            throw new VariableUpdateException(this.variable.getName(), (Object)e);
        }
        Object[] logParams = new Object[]{this.getName(), this.variable.getName(), this.label, value};
        this.log.info(this.getClass(), "msg.util.dialog.0008", logParams);
    }

    public Object getValidateableValue() {
        ArrayList<String> values = new ArrayList<String>(this.inputField.length);
        for (int i = 0; i < this.inputField.length; ++i) {
            values.add((String)this.inputField[i].getValue());
        }
        return values;
    }

    public static interface LabelFormatIF {
        public String format(String var1, int var2);
    }
}

