/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdt.util.dialog;

import com.sap.sdt.util.diag.DiagException;
import com.sap.sdt.util.diag.WrongSyntaxException;
import com.sap.sdt.util.dialog.AbstractDialog;
import com.sap.sdt.util.dialog.ButtonVariable;
import com.sap.sdt.util.dialog.CheckBox;
import com.sap.sdt.util.dialog.InputDescription;
import com.sap.sdt.util.dialog.UpdateHandlerException;
import com.sap.sdt.util.dialog.UtilDialogCreateException;
import com.sap.sdt.util.dialog.UtilDialogIF;
import com.sap.sdt.util.dialog.UtilDialogSerializeException;
import com.sap.sdt.util.dialog.VariableTypeException;
import com.sap.sdt.util.dialog.VariableUpdateException;
import com.sap.sdt.util.dialog.adapter.DialogAdapterIF;
import com.sap.sdt.util.dialog.adapter.DialogVariableIF;
import com.sap.sdt.util.dialog.adapter.DialogVariableNotFoundException;
import com.sap.sdt.util.dialog.adapter.DialogVariableSetException;
import com.sap.sdt.util.validate.ValidatorContainer;
import com.sap.sdt.util.value.UnknownTypeException;
import com.sap.sdt.util.value.ValueDeserializeException;
import com.sap.sdt.util.value.ValueTypeMismatchException;
import com.sap.sdt.util.xml.XMLElementFactoryIF;
import com.sap.sdt.util.xml.XMLElementIF;
import com.sap.sdt.util.xml.XMLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class MultiSelectionDialog
extends AbstractDialog {
    public static final String RCSINFO = "$Id: //sdt/com.sap.sdt/0.1/src/_util/java/com/sap/sdt/util/dialog/MultiSelectionDialog.java#2 $";
    private String heading = null;
    private List boxes = new ArrayList();
    private Map variables = new HashMap();
    private InputDescription id = null;

    public MultiSelectionDialog(String name, DialogAdapterIF handler, XMLElementIF elem, ValidatorContainer vContainer) throws UtilDialogCreateException {
        this(name, handler, elem, null, vContainer);
    }

    public MultiSelectionDialog(String name, DialogAdapterIF handler, XMLElementIF elem, InputDescription id, ValidatorContainer vContainer) throws UtilDialogCreateException {
        super(name, elem, vContainer);
        this.setHandler(handler);
        this.setInputDescription(id);
        this.deserializeBody(elem);
    }

    public String getType() {
        return "MultiSelection";
    }

    protected void serializeBody(XMLElementFactoryIF xmlFactory, XMLElementIF rootElem) throws UtilDialogSerializeException {
        try {
            XMLElementIF subElem = null;
            if (this.heading != null) {
                subElem = xmlFactory.createXMLElement();
                subElem.setName("HEADING");
                subElem.setContent(this.heading);
                rootElem.add(subElem);
            }
            for (int i = 0; i < this.boxes.size(); ++i) {
                subElem = xmlFactory.createXMLElement();
                subElem.setName("INPUT");
                CheckBox checkBox = (CheckBox)this.boxes.get(i);
                ButtonVariable buttonVariable = (ButtonVariable)this.variables.get(checkBox);
                XMLElementIF varElem = xmlFactory.createXMLElement();
                varElem.setName("LABEL");
                varElem.setContent(checkBox.getLabel().getText());
                subElem.add(varElem);
                varElem = xmlFactory.createXMLElement();
                varElem.setName("VARIABLE");
                varElem.setContent(buttonVariable.getVariable().getName());
                subElem.add(varElem);
                this.serializeVariableValue(buttonVariable.getVariable().getValue(), subElem);
                rootElem.add(subElem);
            }
        }
        catch (DiagException e) {
            throw new UtilDialogSerializeException(this.getName(), e);
        }
    }

    protected void deserializeBody(XMLElementIF elem) throws UtilDialogCreateException {
        try {
            Iterator subElemIterator = elem.getSubElements();
            while (subElemIterator.hasNext()) {
                XMLElementIF subElem = (XMLElementIF)subElemIterator.next();
                if (subElem.getName().equals("HEADING")) {
                    this.setHeading(subElem.getContent());
                    continue;
                }
                if (subElem.getName().equals("INPUT")) {
                    this.deserializeInput(subElem);
                    continue;
                }
                String expected = "HEADING,INPUT";
                throw new WrongSyntaxException(subElem.getName(), expected);
            }
        }
        catch (DiagException diagEx) {
            UtilDialogCreateException e = new UtilDialogCreateException(this.name, diagEx);
            this.log.error(this.getClass(), e);
            throw e;
        }
    }

    private void deserializeInput(XMLElementIF subElem) throws ValueTypeMismatchException, VariableTypeException, WrongSyntaxException, UnknownTypeException, ValueDeserializeException, XMLException, DialogVariableSetException, DialogVariableNotFoundException {
        String varName;
        String label;
        InputDescription.Entry[] entry = this.getInputDescriptionEntry();
        if (entry == null) {
            entry = this.getInputDescriptionEntry(subElem, this.handler);
        }
        if (entry != null) {
            for (int i = 0; i < entry.length; ++i) {
                label = entry[i].label;
                varName = entry[i].varName;
                this.autoCreateVariable(varName);
                this.addVariable(new ButtonVariable(this.handler.getVariableE(varName)), label);
            }
        }
        Iterator inputElements = subElem.getSubElements();
        label = null;
        varName = null;
        while (inputElements.hasNext()) {
            XMLElementIF inputElem = (XMLElementIF)inputElements.next();
            if (inputElem.getName().equals("LABEL")) {
                label = inputElem.getContent();
                continue;
            }
            if (inputElem.getName().equals("VARIABLE")) {
                varName = inputElem.getContent();
                this.autoCreateVariable(varName);
                continue;
            }
            if (inputElem.getName().equals("VALUE")) {
                Object value = this.deserializeVariableValue(inputElem);
                this.handler.getVariableE(varName).setValue(value);
                continue;
            }
            String expected = "LABEL,VARIABLE,VALUE";
            throw new WrongSyntaxException(inputElem.getName(), expected);
        }
        if (label != null && varName != null) {
            this.addVariable(new ButtonVariable(this.handler.getVariableE(varName)), label);
        } else if (entry == null) {
            if (label == null) {
                throw new WrongSyntaxException("", "LABEL");
            }
            if (varName == null) {
                throw new WrongSyntaxException("", "VARIABLE");
            }
        }
    }

    protected Object getAutoCreateValue() {
        return Boolean.FALSE;
    }

    protected void autoCreateVariable(String varName) throws DialogVariableSetException {
        if (MultiSelectionDialog.isAutoCreateVariablesOn()) {
            Object value = this.getAutoCreateValue();
            if (!this.handler.handlesVariable(varName)) {
                this.handler.addVariable(varName, value);
            } else {
                DialogVariableIF variable = this.handler.getVariable(varName);
                if (variable.getValue() == null) {
                    variable.setValue(value);
                }
            }
        }
    }

    public void updateElements(UtilDialogIF fromDialog) {
        MultiSelectionDialog from = (MultiSelectionDialog)fromDialog;
        CheckBox[] fromCheckBoxes = from.getCheckBoxArray();
        for (int i = 0; i < this.boxes.size(); ++i) {
            CheckBox checkBox = (CheckBox)this.boxes.get(i);
            checkBox.setSelected(fromCheckBoxes[i].isSelected());
        }
    }

    public void updateVariables() throws VariableUpdateException {
        for (int i = 0; i < this.boxes.size(); ++i) {
            CheckBox checkBox = (CheckBox)this.boxes.get(i);
            ButtonVariable buttonVariable = (ButtonVariable)this.variables.get(checkBox);
            Boolean value = new Boolean(checkBox.isSelected());
            try {
                buttonVariable.setValue(value);
            }
            catch (DialogVariableSetException e) {
                throw new VariableUpdateException(buttonVariable.getVariable().getName(), (Object)e);
            }
            Object[] logParams = new Object[]{this.getName(), buttonVariable.getVariable().getName(), checkBox.getLabel(), value};
            this.log.info(this.getClass(), "msg.util.dialog.0008", logParams);
        }
    }

    public void updateHandler() throws UpdateHandlerException {
        String varName = "";
        try {
            for (int i = 0; i < this.boxes.size(); ++i) {
                CheckBox checkBox = (CheckBox)this.boxes.get(i);
                ButtonVariable buttonVariable = (ButtonVariable)this.variables.get(checkBox);
                DialogVariableIF variable = buttonVariable.getVariable();
                varName = variable.getName();
                this.handler.setVariable(variable);
            }
        }
        catch (DiagException e) {
            throw new UpdateHandlerException(this.handler.getParentName(), varName, e);
        }
    }

    public void setHeading(String heading) {
        this.heading = heading;
    }

    public String getHeading() {
        return this.heading;
    }

    public CheckBox[] getCheckBoxArray() {
        return this.boxes.toArray(new CheckBox[this.boxes.size()]);
    }

    public void addVariable(ButtonVariable variable, String labelText) {
        CheckBox checkBox = new CheckBox(variable.getValue(), labelText);
        this.boxes.add(checkBox);
        this.variables.put(checkBox, variable);
    }

    public DialogVariableIF getVariable(String name) {
        for (int i = 0; i < this.boxes.size(); ++i) {
            CheckBox checkBox = (CheckBox)this.boxes.get(i);
            ButtonVariable buttonVariable = (ButtonVariable)this.variables.get(checkBox);
            DialogVariableIF variable = buttonVariable.getVariable();
            if (!name.equals(variable.getName())) continue;
            return variable;
        }
        return null;
    }

    public boolean hasVariable(String name) {
        for (int i = 0; i < this.boxes.size(); ++i) {
            CheckBox checkBox = (CheckBox)this.boxes.get(i);
            ButtonVariable buttonVariable = (ButtonVariable)this.variables.get(checkBox);
            DialogVariableIF variable = buttonVariable.getVariable();
            if (!name.equals(variable.getName())) continue;
            return true;
        }
        return false;
    }

    private InputDescription.Entry[] getInputDescriptionEntry() {
        return this.id == null ? null : this.id.getAll();
    }

    private void setInputDescription(InputDescription id) {
        this.id = id;
    }

    public Object getValidateableValue() {
        return null;
    }
}

