/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdt.util.dialog;

import com.sap.sdt.util.dialog.OutputField;
import com.sap.sdt.util.misc.SDTBool;
import com.sap.sdt.util.value.Password;
import java.io.File;

public class InputField
extends OutputField {
    public static final String RCSINFO = "$Id: //sdt/com.sap.sdt/0.1/src/_util/java/com/sap/sdt/util/dialog/InputField.java#2 $";
    protected Object[] possibleValues = null;

    public InputField(Object value) {
        this(value, null);
    }

    public InputField(Object value, String labelText) {
        super(value, labelText);
        this.setEditable(true);
    }

    public void updateValue(Object value) {
        this.value = value;
    }

    public void updateValue(String value) {
        if (this.value instanceof String) {
            this.value = value;
        } else if (this.value instanceof Boolean) {
            this.value = new Boolean(SDTBool.getBoolean(value));
        } else if (this.value instanceof Long) {
            this.value = new Long(Long.parseLong(value));
        } else if (this.value instanceof File) {
            this.value = new File(value);
        } else if (this.value instanceof Password) {
            this.value = new Password(value);
        } else {
            throw new IllegalArgumentException(this.value.getClass().getName());
        }
    }

    public void setPossibleValues(Object[] possibleValues) {
        this.possibleValues = possibleValues;
    }

    public Object[] getPossibleValues() {
        return this.possibleValues;
    }

    public boolean hasPossibleValues() {
        return this.possibleValues != null;
    }

    public boolean checkInputValue(Object value) {
        if (this.hasPossibleValues()) {
            for (int i = 0; i < this.possibleValues.length; ++i) {
                if (!value.equals(this.possibleValues[i])) continue;
                return true;
            }
            return false;
        }
        return true;
    }
}

