/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdt.util.dialog;

import com.sap.sdt.util.dialog.adapter.DialogAdapterIF;
import com.sap.sdt.util.dialog.adapter.DialogVariableIF;
import com.sap.sdt.util.dialog.adapter.DialogVariableNotFoundException;
import com.sap.sdt.util.value.ValueTypeMismatchException;
import com.sap.sdt.util.value.table.StringTable;
import com.sap.sdt.util.value.table.StringTableRowIF;
import java.text.DecimalFormat;

public class InputDescription {
    public static final String RCSINFO = "$Id: //sdt/com.sap.sdt/0.1/src/_util/java/com/sap/sdt/util/dialog/InputDescription.java#2 $";
    public static final String INDEX = "INDEX";
    public static final String LABEL = "LABEL";
    public static final String VARIABLE = "VARIABLE";
    private String name;
    private StringTable value;
    private int labelIndex;
    private int variableIndex;

    public InputDescription(String name) {
        this.name = name;
        this.value = new StringTable(new String[]{INDEX, LABEL, VARIABLE}, 1);
        this.setColumnIndexVariables();
    }

    public InputDescription(DialogAdapterIF handler, String name) throws DialogVariableNotFoundException, ValueTypeMismatchException {
        this.name = name;
        DialogVariableIF var = handler.getVariableE(name);
        if (!(var.getValue() instanceof StringTable)) {
            throw new ValueTypeMismatchException(var.getType(), "StringTable");
        }
        this.value = (StringTable)var.getValue();
        this.setColumnIndexVariables();
    }

    public String getName() {
        return this.name;
    }

    public StringTable getStringTable() {
        return this.value;
    }

    public void add(String label, String varName) {
        this.add(new Entry(label, varName));
    }

    public void add(Entry entry) {
        StringTableRowIF row = this.value.getStringRow();
        row.add(this.getNextIndex());
        row.add(entry.label);
        row.add(entry.varName);
        this.value.add(row);
    }

    public void clear() {
        this.value.clear();
    }

    public Entry[] getAll() {
        Entry[] result = new Entry[this.value.size()];
        StringTable.StringRowIterator it = this.value.stringRowIterator();
        int i = 0;
        while (it.hasNext()) {
            StringTableRowIF row = it.next();
            result[i] = new Entry(row.getString(this.labelIndex), row.getString(this.variableIndex));
            ++i;
        }
        return result;
    }

    private String getNextIndex() {
        int index = this.value.size() + 1;
        DecimalFormat df = new DecimalFormat("0000000000");
        return df.format(index);
    }

    public static boolean addVariable(String name, DialogAdapterIF handler) {
        StringTable value = new StringTable(new String[]{INDEX, LABEL, VARIABLE}, 1);
        return handler.addVariable(name, value);
    }

    private void setColumnIndexVariables() {
        this.labelIndex = this.value.getColumnIndex(LABEL);
        this.variableIndex = this.value.getColumnIndex(VARIABLE);
    }

    public class Entry {
        public String label;
        public String varName;

        public Entry(String label, String varName) {
            this.label = label;
            this.varName = varName;
        }
    }
}

