/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdt.util.dialog;

import com.sap.sdt.util.diag.DiagException;
import com.sap.sdt.util.diag.WrongSyntaxException;
import com.sap.sdt.util.dialog.AbstractDialog;
import com.sap.sdt.util.dialog.ButtonVariable;
import com.sap.sdt.util.dialog.InputDescription;
import com.sap.sdt.util.dialog.RadioButton;
import com.sap.sdt.util.dialog.RadioButtonGroup;
import com.sap.sdt.util.dialog.UpdateHandlerException;
import com.sap.sdt.util.dialog.UtilDialogCreateException;
import com.sap.sdt.util.dialog.UtilDialogIF;
import com.sap.sdt.util.dialog.UtilDialogSerializeException;
import com.sap.sdt.util.dialog.VariableTypeException;
import com.sap.sdt.util.dialog.VariableUpdateException;
import com.sap.sdt.util.dialog.adapter.DialogAdapterIF;
import com.sap.sdt.util.dialog.adapter.DialogVariableIF;
import com.sap.sdt.util.dialog.adapter.DialogVariableNotFoundException;
import com.sap.sdt.util.dialog.adapter.DialogVariableSetException;
import com.sap.sdt.util.validate.ValidatorContainer;
import com.sap.sdt.util.value.UnknownTypeException;
import com.sap.sdt.util.value.ValueDeserializeException;
import com.sap.sdt.util.value.ValueTypeMismatchException;
import com.sap.sdt.util.xml.XMLElementFactoryIF;
import com.sap.sdt.util.xml.XMLElementIF;
import com.sap.sdt.util.xml.XMLException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class ExclusiveSelectionDialog
extends AbstractDialog {
    public static final String RCSINFO = "$Id: //sdt/com.sap.sdt/0.1/src/_util/java/com/sap/sdt/util/dialog/ExclusiveSelectionDialog.java#2 $";
    private RadioButtonGroup buttonGroup = new RadioButtonGroup();
    private Map variables = new HashMap();
    private String heading = null;
    private InputDescription id = null;

    public ExclusiveSelectionDialog(String name, DialogAdapterIF handler, XMLElementIF elem, ValidatorContainer vContainer) throws UtilDialogCreateException {
        this(name, handler, elem, null, vContainer);
    }

    public ExclusiveSelectionDialog(String name, DialogAdapterIF handler, XMLElementIF elem, InputDescription id, ValidatorContainer vContainer) throws UtilDialogCreateException {
        super(name, elem, vContainer);
        this.setHandler(handler);
        this.setInputDescription(id);
        this.deserializeBody(elem);
    }

    public String getType() {
        return "ExclusiveSelection";
    }

    protected void serializeBody(XMLElementFactoryIF xmlFactory, XMLElementIF rootElem) throws UtilDialogSerializeException {
        try {
            XMLElementIF subElem = null;
            if (this.heading != null) {
                subElem = xmlFactory.createXMLElement();
                subElem.setName("HEADING");
                subElem.setContent(this.heading);
                rootElem.add(subElem);
            }
            for (int i = 0; i < this.buttonGroup.getRadioButtonCount(); ++i) {
                subElem = xmlFactory.createXMLElement();
                subElem.setName("INPUT");
                RadioButton button = this.buttonGroup.getRadioButton(i);
                ButtonVariable buttonVariable = (ButtonVariable)this.variables.get(button);
                XMLElementIF varElem = xmlFactory.createXMLElement();
                varElem.setName("LABEL");
                varElem.setContent(button.getLabel().getText());
                subElem.add(varElem);
                varElem = xmlFactory.createXMLElement();
                varElem.setName("VARIABLE");
                varElem.setContent(buttonVariable.getVariable().getName());
                subElem.add(varElem);
                this.serializeVariableValue(buttonVariable.getVariable().getValue(), subElem);
                rootElem.add(subElem);
            }
        }
        catch (DiagException e) {
            throw new UtilDialogSerializeException(this.getName(), e);
        }
    }

    protected void deserializeBody(XMLElementIF elem) throws UtilDialogCreateException {
        try {
            Iterator subElemIterator = elem.getSubElements();
            while (subElemIterator.hasNext()) {
                XMLElementIF subElem = (XMLElementIF)subElemIterator.next();
                if (subElem.getName().equals("HEADING")) {
                    this.setHeading(subElem.getContent());
                    continue;
                }
                if (subElem.getName().equals("INPUT")) {
                    this.deserializeInput(subElem);
                    continue;
                }
                String expected = "HEADING,INPUT";
                throw new WrongSyntaxException(subElem.getName(), expected);
            }
        }
        catch (DiagException diagEx) {
            UtilDialogCreateException e = new UtilDialogCreateException(this.name, diagEx);
            this.log.error(this.getClass(), e);
            throw e;
        }
    }

    private void deserializeInput(XMLElementIF subElem) throws ValueTypeMismatchException, VariableTypeException, DialogVariableNotFoundException, DialogVariableSetException, WrongSyntaxException, UnknownTypeException, ValueDeserializeException, XMLException {
        String varName;
        String label;
        InputDescription.Entry[] entry = this.getInputDescriptionEntry();
        if (entry == null) {
            entry = this.getInputDescriptionEntry(subElem, this.handler);
        }
        if (entry != null) {
            for (int i = 0; i < entry.length; ++i) {
                label = entry[i].label;
                varName = entry[i].varName;
                this.autoCreateVariable(varName);
                this.addVariable(new ButtonVariable(this.handler.getVariableE(varName)), label);
            }
        }
        Iterator inputElements = subElem.getSubElements();
        label = null;
        varName = null;
        while (inputElements.hasNext()) {
            XMLElementIF inputElem = (XMLElementIF)inputElements.next();
            if (inputElem.getName().equals("LABEL")) {
                label = inputElem.getContent();
                continue;
            }
            if (inputElem.getName().equals("VARIABLE")) {
                varName = inputElem.getContent();
                this.autoCreateVariable(varName);
                continue;
            }
            if (inputElem.getName().equals("VALUE")) {
                Object value = this.deserializeVariableValue(inputElem);
                this.handler.getVariableE(varName).setValue(value);
                continue;
            }
            String expected = "LABEL,VARIABLE,VALUE";
            throw new WrongSyntaxException(inputElem.getName(), expected);
        }
        if (label != null && varName != null) {
            this.addVariable(new ButtonVariable(this.handler.getVariableE(varName)), label);
        } else if (entry == null) {
            if (label == null) {
                throw new WrongSyntaxException("", "LABEL");
            }
            if (varName == null) {
                throw new WrongSyntaxException("", "VARIABLE");
            }
        }
    }

    protected Object getAutoCreateValue() {
        return Boolean.FALSE;
    }

    public void setHeading(String heading) {
        this.heading = heading;
    }

    public String getHeading() {
        return this.heading;
    }

    public RadioButtonGroup getRadioButtonGroup() {
        return this.buttonGroup;
    }

    public void setSelectedRadioButton(RadioButton button) {
        this.buttonGroup.setSelected(button);
    }

    public void setSelectedRadioButton(String variableName) {
        for (int i = 0; i < this.buttonGroup.getRadioButtonCount(); ++i) {
            RadioButton button = this.buttonGroup.getRadioButton(i);
            ButtonVariable buttonVariable = (ButtonVariable)this.variables.get(button);
            if (!variableName.equals(buttonVariable.getVariable().getName())) continue;
            this.buttonGroup.setSelected(button);
        }
    }

    public void updateElements(UtilDialogIF fromDialog) {
        ExclusiveSelectionDialog from = (ExclusiveSelectionDialog)fromDialog;
        RadioButton fromButton = from.getRadioButtonGroup().getSelection();
        ButtonVariable fromButtonVariable = (ButtonVariable)from.variables.get(fromButton);
        DialogVariableIF fromVariable = fromButtonVariable.getVariable();
        this.setSelectedRadioButton(fromVariable.getName());
    }

    public void updateVariables() throws VariableUpdateException {
        for (int i = 0; i < this.buttonGroup.getRadioButtonCount(); ++i) {
            RadioButton button = this.buttonGroup.getRadioButton(i);
            ButtonVariable variable = (ButtonVariable)this.variables.get(button);
            Boolean value = new Boolean(button.isSelected());
            try {
                variable.setValue(value);
            }
            catch (DialogVariableSetException e) {
                throw new VariableUpdateException(variable.getVariable().getName(), (Object)e);
            }
            Object[] logParams = new Object[]{this.getName(), variable.getVariable().getName(), button.getLabel(), value};
            this.log.info(this.getClass(), "msg.util.dialog.0008", logParams);
        }
    }

    public void updateHandler() throws UpdateHandlerException {
        String varName = "";
        try {
            for (int i = 0; i < this.buttonGroup.getRadioButtonCount(); ++i) {
                RadioButton button = this.buttonGroup.getRadioButton(i);
                ButtonVariable buttonVariable = (ButtonVariable)this.variables.get(button);
                DialogVariableIF variable = buttonVariable.getVariable();
                varName = variable.getName();
                this.handler.setVariable(variable);
            }
        }
        catch (DiagException e) {
            throw new UpdateHandlerException(this.handler.getParentName(), varName, e);
        }
    }

    public void addVariable(ButtonVariable variable, String labelText) {
        RadioButton button = new RadioButton(variable.getValue(), labelText);
        this.buttonGroup.add(button);
        this.variables.put(button, variable);
    }

    public DialogVariableIF getVariable(String name) {
        for (int i = 0; i < this.buttonGroup.getRadioButtonCount(); ++i) {
            RadioButton button = this.buttonGroup.getRadioButton(i);
            ButtonVariable buttonVariable = (ButtonVariable)this.variables.get(button);
            DialogVariableIF variable = buttonVariable.getVariable();
            if (!name.equals(variable.getName())) continue;
            return variable;
        }
        return null;
    }

    public boolean hasVariable(String name) {
        for (int i = 0; i < this.buttonGroup.getRadioButtonCount(); ++i) {
            RadioButton button = this.buttonGroup.getRadioButton(i);
            ButtonVariable buttonVariable = (ButtonVariable)this.variables.get(button);
            DialogVariableIF variable = buttonVariable.getVariable();
            if (!name.equals(variable.getName())) continue;
            return true;
        }
        return false;
    }

    private InputDescription.Entry[] getInputDescriptionEntry() {
        return this.id == null ? null : this.id.getAll();
    }

    private void setInputDescription(InputDescription id) {
        this.id = id;
    }

    public Object getValidateableValue() {
        for (int i = 0; i < this.buttonGroup.getRadioButtonCount(); ++i) {
            RadioButton button = this.buttonGroup.getRadioButton(i);
            if (!button.isSelected()) continue;
            return button.getLabel();
        }
        return null;
    }

    protected void autoCreateVariable(String varName) throws DialogVariableSetException {
        if (ExclusiveSelectionDialog.isAutoCreateVariablesOn()) {
            Object value = this.getAutoCreateValue();
            if (!this.handler.handlesVariable(varName)) {
                this.handler.addVariable(varName, value);
            } else {
                DialogVariableIF variable = this.handler.getVariable(varName);
                if (variable.getValue() == null) {
                    variable.setValue(value);
                }
            }
        }
    }
}

