/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdt.util.dialog;

import com.sap.sdt.util.diag.DiagException;
import com.sap.sdt.util.diag.WrongSyntaxException;
import com.sap.sdt.util.dialog.AbstractDialog;
import com.sap.sdt.util.dialog.ExclusiveSelectionDialog;
import com.sap.sdt.util.dialog.FileInputDialog;
import com.sap.sdt.util.dialog.InfoDialog;
import com.sap.sdt.util.dialog.MultiSelectionDialog;
import com.sap.sdt.util.dialog.MultiTextInputDialog;
import com.sap.sdt.util.dialog.OKCancelDialog;
import com.sap.sdt.util.dialog.PasswordInputDialog;
import com.sap.sdt.util.dialog.SingleTextInputDialog;
import com.sap.sdt.util.dialog.TableInputDialog;
import com.sap.sdt.util.dialog.UpdateHandlerException;
import com.sap.sdt.util.dialog.UtilDialogCreateException;
import com.sap.sdt.util.dialog.UtilDialogIF;
import com.sap.sdt.util.dialog.UtilDialogSerializeException;
import com.sap.sdt.util.dialog.VariableUpdateException;
import com.sap.sdt.util.dialog.adapter.DialogAdapterIF;
import com.sap.sdt.util.dialog.adapter.DialogVariableIF;
import com.sap.sdt.util.validate.ValidationException;
import com.sap.sdt.util.validate.ValidationFailureException;
import com.sap.sdt.util.validate.ValidationProcessor;
import com.sap.sdt.util.validate.ValidatorContainer;
import com.sap.sdt.util.xml.XMLElementFactoryIF;
import com.sap.sdt.util.xml.XMLElementIF;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class CompositeDialog
extends AbstractDialog {
    public static final String RCSINFO = "$Id: //sdt/com.sap.sdt/0.1/src/_util/java/com/sap/sdt/util/dialog/CompositeDialog.java#2 $";
    private List dialogs = new ArrayList();

    public CompositeDialog(String name) {
        super(name);
    }

    public CompositeDialog(String name, DialogAdapterIF handler, XMLElementIF elem, ValidatorContainer vContainer) throws UtilDialogCreateException {
        super(name, elem, vContainer);
        this.setHandler(handler);
        this.deserializeBody(elem);
    }

    public String getType() {
        return "Composite";
    }

    public boolean getExpertMode() {
        Iterator it = this.dialogs.iterator();
        while (it.hasNext()) {
            UtilDialogIF dialog = (UtilDialogIF)it.next();
            if (dialog.getExpertMode()) continue;
            return false;
        }
        return true;
    }

    public void createElements() throws UtilDialogCreateException {
        Iterator it = this.dialogs.iterator();
        while (it.hasNext()) {
            UtilDialogIF dialog = (UtilDialogIF)it.next();
            dialog.createElements();
        }
    }

    public void updateElements(UtilDialogIF fromDialog) {
        Iterator fromIt = ((CompositeDialog)fromDialog).dialogs.iterator();
        Iterator it = this.dialogs.iterator();
        while (it.hasNext()) {
            UtilDialogIF dialog = (UtilDialogIF)it.next();
            UtilDialogIF from = (UtilDialogIF)fromIt.next();
            dialog.updateElements(from);
        }
    }

    public void updateVariables() throws VariableUpdateException {
        Iterator it = this.dialogs.iterator();
        while (it.hasNext()) {
            UtilDialogIF dialog = (UtilDialogIF)it.next();
            dialog.updateVariables();
        }
    }

    public void updateHandler() throws UpdateHandlerException {
        Iterator it = this.dialogs.iterator();
        while (it.hasNext()) {
            UtilDialogIF dialog = (UtilDialogIF)it.next();
            dialog.updateHandler();
        }
    }

    public void addDialog(UtilDialogIF dialog) {
        this.dialogs.add(dialog);
    }

    public DialogVariableIF getVariable(String name) {
        Iterator it = this.dialogs.iterator();
        while (it.hasNext()) {
            UtilDialogIF dialog = (UtilDialogIF)it.next();
            if (!dialog.hasVariable(name)) continue;
            return dialog.getVariable(name);
        }
        return null;
    }

    public boolean hasVariable(String name) {
        Iterator it = this.dialogs.iterator();
        while (it.hasNext()) {
            UtilDialogIF dialog = (UtilDialogIF)it.next();
            if (!dialog.hasVariable(name)) continue;
            return true;
        }
        return false;
    }

    public boolean isConfirmed() {
        boolean isConfirmed = true;
        Iterator it = this.dialogs.iterator();
        while (it.hasNext()) {
            UtilDialogIF dialog = (UtilDialogIF)it.next();
            isConfirmed = dialog.isConfirmed();
        }
        if (isConfirmed) {
            this.log.info(this.getClass(), "msg.util.dialog.0010", this.getName());
        } else {
            this.log.warning(this.getClass(), "msg.util.dialog.0011", this.getName());
        }
        return isConfirmed;
    }

    public void validateInput(ValidationProcessor processor) throws ValidationException, ValidationFailureException {
        Iterator it = this.dialogs.iterator();
        while (it.hasNext()) {
            UtilDialogIF dialog = (UtilDialogIF)it.next();
            dialog.validateInput(processor);
        }
    }

    public boolean hasChilds() {
        return this.dialogs != null && this.dialogs.size() > 0;
    }

    public List getChilds() {
        return this.dialogs;
    }

    protected void serializeBody(XMLElementFactoryIF xmlFactory, XMLElementIF rootElem) throws UtilDialogSerializeException {
        Iterator it = this.dialogs.iterator();
        while (it.hasNext()) {
            UtilDialogIF dialog = (UtilDialogIF)it.next();
            rootElem.add(dialog.serialize(xmlFactory));
        }
    }

    protected void deserializeBody(XMLElementIF rootElem) throws UtilDialogCreateException {
        try {
            Iterator subElemIterator = rootElem.getSubElements();
            while (subElemIterator.hasNext()) {
                XMLElementIF subElem = (XMLElementIF)subElemIterator.next();
                String type = subElem.getName();
                String name = subElem.getAttrString("name");
                if (type.equals("SingleTextInput")) {
                    this.addDialog(new SingleTextInputDialog(name, this.handler, subElem, this.getValidatorContainer()));
                    continue;
                }
                if (type.equals("MultiTextInput")) {
                    this.addDialog(new MultiTextInputDialog(name, this.handler, subElem, this.getValidatorContainer()));
                    continue;
                }
                if (type.equals("ExclusiveSelection")) {
                    this.addDialog(new ExclusiveSelectionDialog(name, this.handler, subElem, this.getValidatorContainer()));
                    continue;
                }
                if (type.equals("MultiSelection")) {
                    this.addDialog(new MultiSelectionDialog(name, this.handler, subElem, this.getValidatorContainer()));
                    continue;
                }
                if (type.equals("OKCancel")) {
                    this.addDialog(new OKCancelDialog(name, this.handler, subElem, this.getValidatorContainer()));
                    continue;
                }
                if (type.equals("InfoText")) {
                    this.addDialog(new InfoDialog(name, subElem, this.getValidatorContainer()));
                    continue;
                }
                if (type.equals("Composite")) {
                    this.addDialog(new CompositeDialog(name, this.handler, subElem, this.getValidatorContainer()));
                    continue;
                }
                if (type.equals("PasswordInput")) {
                    this.addDialog(new PasswordInputDialog(name, this.handler, subElem, this.getValidatorContainer()));
                    continue;
                }
                if (type.equals("FileInput")) {
                    this.addDialog(new FileInputDialog(name, this.handler, subElem, this.getValidatorContainer()));
                    continue;
                }
                if (type.equals("TableInput")) {
                    this.addDialog(new TableInputDialog(name, this.handler, subElem, this.getValidatorContainer()));
                    continue;
                }
                String expected = "SingleTextInput,MultiTextInput,ExclusiveSelection,MultiSelection,OKCancel,InfoText,Composite,PasswordInput,FileInput,TableInput";
                throw new WrongSyntaxException(type, expected);
            }
        }
        catch (DiagException diagEx) {
            UtilDialogCreateException e = new UtilDialogCreateException(this.name, diagEx);
            this.log.error(this.getClass(), e);
            throw e;
        }
    }

    public Object getValidateableValue() {
        return null;
    }
}

