/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdt.util.dialog;

import com.sap.sdt.util.dialog.VariableTypeException;
import com.sap.sdt.util.dialog.adapter.DialogVariableIF;
import com.sap.sdt.util.dialog.adapter.DialogVariableSetException;
import com.sap.sdt.util.value.ValueFactory;

public class ButtonVariable {
    public static final String RCSINFO = "$Id: //sdt/com.sap.sdt/0.1/src/_util/java/com/sap/sdt/util/dialog/ButtonVariable.java#2 $";
    public static final String TRUE_VALUE = "on";
    public static final String FALSE_VALUE = "off";
    private DialogVariableIF variable;
    private String trueValue = "on";
    private String falseValue = "off";

    public ButtonVariable(DialogVariableIF variable) throws VariableTypeException {
        String[] expectedType = new String[]{"String", "Boolean"};
        String valueType = ValueFactory.getValueType(variable.getValue());
        if (!valueType.equals(expectedType[0]) && !valueType.equals(expectedType[1])) {
            throw new VariableTypeException(variable.getName(), valueType, expectedType);
        }
        this.variable = variable;
    }

    public ButtonVariable(DialogVariableIF variable, String trueValue, String falseValue) throws VariableTypeException {
        String expectedType = "String";
        if (!ValueFactory.getValueType(variable.getValue()).equals(expectedType)) {
            throw new VariableTypeException(variable.getName(), variable.getType(), expectedType);
        }
        this.variable = variable;
        this.trueValue = trueValue;
        this.falseValue = falseValue;
    }

    public DialogVariableIF getVariable() {
        return this.variable;
    }

    public Boolean getValue() {
        if (this.variable.getValue() instanceof Boolean) {
            return (Boolean)this.variable.getValue();
        }
        if (this.variable.getValue().equals(this.trueValue)) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public void setValue(Boolean value) throws DialogVariableSetException {
        if (this.variable.getValue() instanceof Boolean) {
            this.variable.setValue(value);
        } else if (value.booleanValue()) {
            this.variable.setValue(this.trueValue);
        } else {
            this.variable.setValue(this.falseValue);
        }
    }
}

