/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdt.util.dialog;

import com.sap.sdt.util.diag.DiagException;
import com.sap.sdt.util.dialog.AbstractDialog;
import com.sap.sdt.util.dialog.UpdateHandlerException;
import com.sap.sdt.util.dialog.UtilDialogCreateException;
import com.sap.sdt.util.dialog.adapter.DialogAdapterIF;
import com.sap.sdt.util.dialog.adapter.DialogVariableIF;
import com.sap.sdt.util.dialog.adapter.DialogVariableNotFoundException;
import com.sap.sdt.util.dialog.adapter.DialogVariableSetException;
import com.sap.sdt.util.validate.ValidatorContainer;
import com.sap.sdt.util.xml.XMLElementIF;

public abstract class AbstractVariableDialog
extends AbstractDialog {
    public static final String RCSINFO = "$Id: //sdt/com.sap.sdt/0.1/src/_util/java/com/sap/sdt/util/dialog/AbstractVariableDialog.java#2 $";
    protected DialogVariableIF variable;

    public AbstractVariableDialog(String name, DialogAdapterIF handler) {
        super(name);
        this.setHandler(handler);
    }

    public AbstractVariableDialog(String name, DialogAdapterIF handler, String varName) throws UtilDialogCreateException {
        this(name, handler);
        try {
            this.setVariable(varName);
        }
        catch (DialogVariableNotFoundException varEx) {
            UtilDialogCreateException e = new UtilDialogCreateException(name, varEx);
            this.log.error(this.getClass(), e);
            throw e;
        }
        catch (DialogVariableSetException varSetEx) {
            UtilDialogCreateException e = new UtilDialogCreateException(name, varSetEx);
            throw e;
        }
    }

    public AbstractVariableDialog(String name, DialogAdapterIF handler, XMLElementIF elem, ValidatorContainer container) throws UtilDialogCreateException {
        super(name, elem, container);
        this.setHandler(handler);
    }

    protected void autoCreateVariable(String varName) throws DialogVariableSetException {
        if (AbstractVariableDialog.isAutoCreateVariablesOn()) {
            Object value = this.getAutoCreateValue();
            if (!this.handler.handlesVariable(varName)) {
                this.handler.addVariable(varName, value);
            } else if (!this.handler.hasValidValue(varName)) {
                this.handler.setVariable(varName, value);
            }
        }
    }

    protected abstract Object getAutoCreateValue();

    public void setVariable(String varName) throws DialogVariableNotFoundException, DialogVariableSetException {
        try {
            this.autoCreateVariable(varName);
            this.variable = this.handler.getVariableE(varName);
        }
        catch (DialogVariableNotFoundException e) {
            this.log.error(this.getClass(), e);
            throw e;
        }
    }

    public DialogVariableIF getVariable(String varName) {
        return this.hasVariable(varName) ? this.variable : null;
    }

    public boolean hasVariable(String varName) {
        return varName.equals(this.variable.getName());
    }

    public void updateHandler() throws UpdateHandlerException {
        try {
            this.handler.setVariable(this.variable);
        }
        catch (DiagException e) {
            throw new UpdateHandlerException(this.handler.getParentName(), this.variable.getName(), e);
        }
    }
}

