/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdt.util.dialog;

import com.sap.sdt.trace.LoggerAdmin;
import com.sap.sdt.trace.LoggerIF;
import com.sap.sdt.util.diag.DiagException;
import com.sap.sdt.util.diag.MessageLogger;
import com.sap.sdt.util.diag.WrongSyntaxException;
import com.sap.sdt.util.dialog.DialogConstants;
import com.sap.sdt.util.dialog.DialogTraceIF;
import com.sap.sdt.util.dialog.InputDescription;
import com.sap.sdt.util.dialog.UpdateHandlerException;
import com.sap.sdt.util.dialog.UtilDialogCreateException;
import com.sap.sdt.util.dialog.UtilDialogIF;
import com.sap.sdt.util.dialog.UtilDialogSerializeException;
import com.sap.sdt.util.dialog.VariableUpdateException;
import com.sap.sdt.util.dialog.adapter.DialogAdapterIF;
import com.sap.sdt.util.dialog.adapter.DialogVariableNotFoundException;
import com.sap.sdt.util.validate.ValidateableIF;
import com.sap.sdt.util.validate.ValidationException;
import com.sap.sdt.util.validate.ValidationFailureException;
import com.sap.sdt.util.validate.ValidationProcessor;
import com.sap.sdt.util.validate.ValidatorContainer;
import com.sap.sdt.util.value.UnknownTypeException;
import com.sap.sdt.util.value.ValueDeserializeException;
import com.sap.sdt.util.value.ValueFactory;
import com.sap.sdt.util.value.ValueSerializeException;
import com.sap.sdt.util.value.ValueTypeMismatchException;
import com.sap.sdt.util.xml.XMLAdmin;
import com.sap.sdt.util.xml.XMLElementFactoryIF;
import com.sap.sdt.util.xml.XMLElementIF;
import com.sap.sdt.util.xml.XMLException;
import java.util.List;

public abstract class AbstractDialog
implements UtilDialogIF,
DialogConstants,
DialogTraceIF,
ValidateableIF {
    public static final String RCSINFO = "$Id: //sdt/com.sap.sdt/0.1/src/_util/java/com/sap/sdt/util/dialog/AbstractDialog.java#2 $";
    private ValidatorContainer validatorContainer = null;
    private static boolean autoCreateVariables = true;
    protected String name;
    protected String title;
    protected String description;
    protected boolean expertMode;
    protected transient DialogAdapterIF handler;
    protected transient LoggerIF log;

    public AbstractDialog(String name) {
        this.setName(name);
        this.setLogger();
    }

    public AbstractDialog(String name, XMLElementIF elem, ValidatorContainer vContainer) throws UtilDialogCreateException {
        try {
            String type = elem.getName();
            if (!this.getType().equals(type)) {
                throw new WrongSyntaxException(type, this.getType());
            }
            this.setName(name);
            this.setLogger();
            this.setValidatorContainer(vContainer);
            String foundName = elem.getAttrString("name");
            if (!this.getName().equals(foundName)) {
                throw new WrongSyntaxException(foundName, this.getName());
            }
            try {
                String expert = elem.getAttrString("expert");
                this.setExpertMode(Boolean.valueOf(expert));
            }
            catch (XMLException e) {
                this.setExpertMode(false);
            }
            try {
                this.title = elem.getAttrString("title");
            }
            catch (XMLException e) {
                this.title = "";
            }
            try {
                this.description = elem.getAttrString("description");
            }
            catch (XMLException e) {
                this.description = "";
            }
        }
        catch (DiagException diagEx) {
            UtilDialogCreateException e = new UtilDialogCreateException(name, diagEx);
            this.log.error(this.getClass(), e);
            throw e;
        }
    }

    public final void setName(String name) {
        this.name = name;
    }

    public final String getName() {
        return this.name;
    }

    public final String getTitle() {
        return this.title;
    }

    public final String getDescription() {
        return this.description;
    }

    public abstract String getType();

    public final void setExpertMode(boolean expertMode) {
        this.expertMode = expertMode;
    }

    public boolean getExpertMode() {
        return this.expertMode;
    }

    public void setLogger() {
        this.log = new MessageLogger(LoggerAdmin.getDialogLogger());
    }

    public final XMLElementIF serialize(XMLElementFactoryIF xmlFactory) throws UtilDialogSerializeException {
        XMLElementIF rootElem = xmlFactory.createXMLElement();
        rootElem.setName(this.getType());
        rootElem.setAttr("name", this.getName());
        rootElem.setAttr("title", this.getTitle());
        rootElem.setAttr("description", this.getDescription());
        rootElem.setAttr("expert", new Boolean(this.getExpertMode()).toString());
        this.serializeBody(xmlFactory, rootElem);
        return rootElem;
    }

    protected abstract void serializeBody(XMLElementFactoryIF var1, XMLElementIF var2) throws UtilDialogSerializeException;

    protected abstract void deserializeBody(XMLElementIF var1) throws UtilDialogCreateException;

    protected final XMLElementIF serializeVariableValue(Object value, XMLElementIF rootElem) throws UnknownTypeException, ValueSerializeException {
        XMLElementIF valueElem = XMLAdmin.createXMLElement();
        valueElem.setName("VALUE");
        valueElem.setAttr("type", ValueFactory.getValueType(value));
        valueElem = ValueFactory.serializeValue(value, valueElem);
        rootElem.add(valueElem);
        return rootElem;
    }

    protected final Object deserializeVariableValue(XMLElementIF valueElem) throws XMLException, UnknownTypeException, ValueDeserializeException, DialogVariableNotFoundException {
        String type = valueElem.getAttrString("type");
        Object value = ValueFactory.deserializeValue(type, valueElem);
        return value;
    }

    protected final InputDescription.Entry[] getInputDescriptionEntry(XMLElementIF subElem, DialogAdapterIF handler) throws DialogVariableNotFoundException, ValueTypeMismatchException {
        try {
            String description = subElem.getAttrString("description");
            if (autoCreateVariables && !handler.handlesVariable(description)) {
                InputDescription.addVariable(description, handler);
            }
            InputDescription id = new InputDescription(handler, description);
            return id.getAll();
        }
        catch (XMLException xMLException) {
            return null;
        }
    }

    public void setHandler(DialogAdapterIF handler) {
        this.handler = handler;
    }

    public final DialogAdapterIF getHandler() {
        return this.handler;
    }

    public static final void setAutoCreateVariables(boolean b) {
        autoCreateVariables = b;
    }

    public static final boolean isAutoCreateVariablesOn() {
        return autoCreateVariables;
    }

    public boolean hasChilds() {
        return false;
    }

    public List getChilds() {
        return null;
    }

    public boolean isConfirmed() {
        return true;
    }

    public boolean requestsInput() {
        return true;
    }

    public void validateInput(ValidationProcessor processor) throws ValidationException, ValidationFailureException {
        if (processor == null) {
            trc.warning(this.getClass(), "Supplied null value instead of valid ValidationProcessor. No validation will be performed!", this.getName());
            return;
        }
        if (this.getValidatorContainer() == null) {
            trc.warning(this.getClass(), "No validatorContainer assigned to the dialog: {0}!", this.getName());
            return;
        }
        List validators = this.getValidatorContainer().getValidatorsForName(this.getValidateableName());
        if (validators == null) {
            trc.warning(this.getClass(), "There are no validators assigned to the field with name: {0}!", this.getValidateableName());
            return;
        }
        processor.validate(this, validators);
    }

    public void createElements() throws UtilDialogCreateException {
    }

    public abstract void updateElements(UtilDialogIF var1);

    public abstract void updateVariables() throws VariableUpdateException;

    public abstract void updateHandler() throws UpdateHandlerException;

    protected void finalize() {
    }

    public ValidatorContainer getValidatorContainer() {
        return this.validatorContainer;
    }

    public void setValidatorContainer(ValidatorContainer container) {
        this.validatorContainer = container;
    }

    public String getValidateableName() {
        return this.getName();
    }

    public abstract Object getValidateableValue();
}

