/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdt.util.diag;

import com.sap.sdt.trace.Logger;
import com.sap.sdt.trace.LoggerIF;
import com.sap.sdt.util.diag.MessageText;
import com.sap.sdt.util.diag.MissingInfoException;
import com.sap.sdt.util.info.IP;
import com.sap.sdt.util.info.InfoProviderIF;

public class MessageLogger
extends Logger {
    public static final String RCSINFO = "$Id: //sdt/com.sap.sdt/0.1/src/_util/java/com/sap/sdt/util/diag/MessageLogger.java#2 $";
    private InfoProviderIF ip;

    public MessageLogger(LoggerIF logger) {
        this(logger, IP.getIP());
    }

    public MessageLogger(LoggerIF logger, InfoProviderIF ip) {
        super(logger.getCategory());
        super.setEvalStackTrace(true);
        this.ip = ip;
    }

    protected String format(String msg, Object[] args) {
        String text;
        block4: {
            text = msg;
            try {
                String[] param = new String[args.length];
                for (int i = 0; i < args.length; ++i) {
                    param[i] = "{" + i + "}";
                }
                MessageText messageText = this.ip.getMessageTextE(msg, param);
                text = messageText.getShort();
            }
            catch (MissingInfoException e) {
                if (args == null || args.length <= 0) break block4;
                for (int i = 0; i < args.length; ++i) {
                    text = text + " {" + i + "}";
                }
            }
        }
        return text;
    }
}

