/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdt.util.diag;

import com.sap.sdt.util.diag.DiagException;
import com.sap.sdt.util.diag.DiagMessage;
import com.sap.sdt.util.diag.MessageText;
import com.sap.sdt.util.diag.MissingInfoException;
import com.sap.sdt.util.info.IP;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.DateFormat;
import java.util.Iterator;

public final class HTMLProvider {
    public static final String RCSINFO = "$Id: //sdt/com.sap.sdt/0.1/src/_util/java/com/sap/sdt/util/diag/HTMLProvider.java#2 $";

    public static URL getErrorLogURL(DiagException ex) {
        try {
            File outFile = new File(HTMLProvider.getPath() + "errorlog" + ".html");
            URL url = new URL("file:" + outFile.getAbsolutePath());
            BufferedWriter outWriter = new BufferedWriter(new FileWriter(outFile));
            outWriter.write("<html><body>");
            outWriter.write("<h2>Error Log</h2>");
            outWriter.write("<table>");
            outWriter.write(HTMLProvider.getExceptionChilds(ex, url));
            outWriter.write("</table>");
            outWriter.write("</body></html>");
            outWriter.close();
            return url;
        }
        catch (MalformedURLException e) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    protected static String getExceptionChilds(DiagException ex, URL root) {
        String msg = "";
        msg = msg + "<tr align=\"left\" valign=\"top\">";
        DateFormat fmt = DateFormat.getDateInstance(3);
        msg = msg + "<td>" + fmt.format(ex.getMsgDate()) + "</td>";
        fmt = DateFormat.getTimeInstance(2);
        msg = msg + "<td>" + fmt.format(ex.getMsgDate()) + "</td>";
        msg = ex.getDiagMessage() == null ? msg + "<td>" + ex.getMsgText() + "</td>" : msg + "<td>" + HTMLProvider.getMessageTag(ex.getDiagMessage(), root) + "</td>";
        msg = msg + "</tr>\n";
        Iterator it = ex.getChilds();
        while (it.hasNext()) {
            DiagException child = (DiagException)it.next();
            msg = msg + HTMLProvider.getExceptionChilds(child, root);
        }
        return msg;
    }

    protected static String getMessageTag(DiagMessage msg, URL root) {
        StringBuffer tag = new StringBuffer();
        URL url = HTMLProvider.getDiagMessageURL(msg.getMsgID(), msg.getMsgParams(), root);
        String message = msg.getMessage();
        if (url == null) {
            tag.append(message);
        } else {
            tag.append("<a href=\"" + url + "\">" + message + "</a>");
        }
        tag.append("<br>");
        return tag.toString();
    }

    protected static URL getDiagMessageURL(String msgID, String[] msgParams, URL root) {
        try {
            MessageText text = IP.getIP().getMessageTextE(msgID, msgParams);
            if (!text.hasLong()) {
                return null;
            }
            File outFile = new File(HTMLProvider.getPath() + msgID + ".html");
            BufferedWriter outWriter = new BufferedWriter(new FileWriter(outFile));
            outWriter.write("<body>\n");
            outWriter.write("<H2>Symptom</H2>");
            outWriter.write("<p>" + text.getLong().getSymptom() + "</p>");
            outWriter.write("<H2>Cause and preconditions</H2>");
            outWriter.write("<p>" + text.getLong().getCause() + "</p>");
            outWriter.write("<H2>Solution</H2>");
            outWriter.write("<p>" + text.getLong().getSolution() + "</p>");
            outWriter.write("\n<br><a href=\"" + root + "\">Back to Error Log</a>");
            outWriter.write("</body>\n");
            outWriter.close();
            return new URL("file:" + outFile.getAbsolutePath());
        }
        catch (MissingInfoException e) {
        }
        catch (MalformedURLException e) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    protected static String getPath() {
        return System.getProperty("user.dir") + System.getProperty("file.separator");
    }
}

