/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdt.util.diag;

import com.sap.sdt.util.diag.DiagException;
import com.sap.sdt.util.diag.HTMLProvider;
import com.sap.sdt.util.diag.SDTFileNotFoundException;
import com.sap.sdt.util.info.IP;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.net.URL;
import javax.swing.BoxLayout;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;

public class ErrorLogFrame
extends JFrame
implements ActionListener {
    public static final String RCSINFO = "$Id: //sdt/com.sap.sdt/0.1/src/_util/java/com/sap/sdt/util/diag/ErrorLogFrame.java#2 $";
    private URL url;

    public ErrorLogFrame(URL url) {
        super("Error Log");
        this.url = url;
        JEditorPane editorPane = this.createEditorPane();
        JScrollPane editorScrollPane = new JScrollPane(editorPane);
        editorScrollPane.setVerticalScrollBarPolicy(22);
        editorScrollPane.setPreferredSize(new Dimension(500, 300));
        editorScrollPane.setMinimumSize(new Dimension(10, 10));
        editorPane.addHyperlinkListener(new LinkFollower(editorPane));
        JPanel contentPane = new JPanel();
        BoxLayout box = new BoxLayout(contentPane, 0);
        contentPane.setLayout(box);
        contentPane.add(editorScrollPane);
        this.setContentPane(contentPane);
    }

    private JEditorPane createEditorPane() {
        JEditorPane editorPane = new JEditorPane();
        editorPane.setEditable(false);
        this.displayURL(this.url, editorPane);
        return editorPane;
    }

    private void displayURL(URL url, JEditorPane editorPane) {
        try {
            editorPane.setPage(url);
        }
        catch (IOException e) {
            System.err.println("Attempted to read a bad URL: " + url);
        }
    }

    public void actionPerformed(ActionEvent e) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void main(String[] args) {
        ErrorLogFrame frame2222;
        String fileName = "properties/message.properties";
        SDTFileNotFoundException showEx = null;
        try {
            try {
                IP.load(ClassLoader.getSystemResourceAsStream(fileName));
                IP.load(ClassLoader.getSystemResourceAsStream("mnmnasdmn"));
            }
            catch (DiagException ex) {
                showEx = new SDTFileNotFoundException(fileName);
                showEx.addChild(ex);
                Object var5_4 = null;
                if (showEx == null) return;
                ErrorLogFrame frame2222 = new ErrorLogFrame(HTMLProvider.getErrorLogURL(showEx));
                frame2222.addWindowListener(new WindowAdapter(){

                    public void windowClosing(WindowEvent e) {
                        System.exit(0);
                    }
                });
                frame2222.pack();
                frame2222.setVisible(true);
                return;
            }
            catch (NullPointerException ex) {
                showEx = new SDTFileNotFoundException(fileName);
                showEx.addChild(new DiagException(ex.toString()));
                Object var5_5 = null;
                if (showEx == null) return;
                ErrorLogFrame frame2222 = new ErrorLogFrame(HTMLProvider.getErrorLogURL(showEx));
                frame2222.addWindowListener(new /* invalid duplicate definition of identical inner class */);
                frame2222.pack();
                frame2222.setVisible(true);
                return;
            }
            Object var5_3 = null;
            if (showEx == null) return;
            frame2222 = new ErrorLogFrame(HTMLProvider.getErrorLogURL(showEx));
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            if (showEx == null) throw throwable;
            ErrorLogFrame frame2222 = new ErrorLogFrame(HTMLProvider.getErrorLogURL(showEx));
            frame2222.addWindowListener(new /* invalid duplicate definition of identical inner class */);
            frame2222.pack();
            frame2222.setVisible(true);
            throw throwable;
        }
        frame2222.addWindowListener(new /* invalid duplicate definition of identical inner class */);
        frame2222.pack();
        frame2222.setVisible(true);
    }

    public class LinkFollower
    implements HyperlinkListener {
        private JEditorPane pane;

        public LinkFollower(JEditorPane pane) {
            this.pane = pane;
        }

        public void hyperlinkUpdate(HyperlinkEvent evt) {
            if (evt.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                try {
                    this.pane.setPage(evt.getURL());
                }
                catch (Exception e) {
                    System.out.println(e);
                }
            }
        }
    }
}

