/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdt.util.diag;

import com.sap.sdt.util.diag.MessageProvider;
import com.sap.sdt.util.diag.SeverityConstants;
import java.util.Arrays;

public class DiagMessage
implements SeverityConstants {
    public static final String RCSINFO = "$Id: //sdt/com.sap.sdt/0.1/src/_util/java/com/sap/sdt/util/diag/DiagMessage.java#3 $";
    private String msgID;
    private String[] msgParams;
    private String helpID;
    private String[] helpParams;
    private int severity;

    DiagMessage() {
        this.setMsgID(null);
        this.setMsgParams((String[])null);
        this.setHelpID(null);
        this.setHelpParams(null);
        this.setSeverity(-1);
    }

    DiagMessage(String msgID, String[] msgParams) {
        this();
        this.setMsgID(msgID);
        this.setMsgParams(msgParams);
    }

    void setMsgID(String msgID) {
        this.msgID = msgID;
    }

    public String getMsgID() {
        return this.msgID;
    }

    void setMsgParams(String msgParam0) {
        this.msgParams = new String[1];
        this.msgParams[0] = msgParam0;
    }

    void setMsgParams(String msgParam0, String msgParam1) {
        this.msgParams = new String[2];
        this.msgParams[0] = msgParam0;
        this.msgParams[1] = msgParam1;
    }

    void setMsgParams(String[] msgParams) {
        this.msgParams = msgParams;
    }

    public String[] getMsgParams() {
        return this.msgParams;
    }

    void setHelpID(String helpID) {
        this.helpID = helpID;
    }

    public String gethelpID() {
        return this.helpID;
    }

    void setHelpParams(String[] helpParams) {
        this.helpParams = helpParams;
    }

    public String[] getHelpParams() {
        return this.helpParams;
    }

    void setSeverity(int severity) {
        this.severity = severity;
    }

    public int getSeverity() {
        return this.severity;
    }

    String getMessage() {
        return MessageProvider.getMessage(this.getMsgID(), this.getMsgParams());
    }

    public Object clone() {
        DiagMessage clone = new DiagMessage();
        clone.helpID = this.helpID;
        clone.helpParams = this.copy(this.helpParams);
        clone.msgID = this.msgID;
        clone.msgParams = this.copy(this.msgParams);
        clone.severity = this.severity;
        return clone;
    }

    private String[] copy(String[] from) {
        if (from == null) {
            return null;
        }
        String[] to = new String[from.length];
        for (int i = 0; i < from.length; ++i) {
            to[i] = from[i];
        }
        return to;
    }

    public boolean equals(Object o) {
        if (o instanceof DiagMessage) {
            DiagMessage other = (DiagMessage)o;
            return (this.helpID == null ? other.helpID == null : this.helpID.equals(other.helpID)) && (this.helpParams == null ? other.helpParams == null : Arrays.equals(this.helpParams, other.helpParams)) && (this.msgID == null ? other.msgID == null : this.msgID.equals(other.msgID)) && (this.msgParams == null ? other.msgParams == null : Arrays.equals(this.msgParams, other.msgParams)) && this.severity == other.severity;
        }
        throw new ClassCastException();
    }
}

