/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdt.util.diag;

import com.sap.sdt.trace.LoggableExceptionIF;
import com.sap.sdt.util.diag.DiagMessage;
import com.sap.sdt.util.diag.SeverityConstants;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class DiagException
extends Exception
implements SeverityConstants,
LoggableExceptionIF {
    public static final String RCSINFO = "$Id: //sdt/com.sap.sdt/0.1/src/_util/java/com/sap/sdt/util/diag/DiagException.java#3 $";
    private static final String MSG_INDENT = "    ";
    private static final List EMPTY_LIST = new LinkedList();
    private List childs;
    DiagMessage msg = null;
    String msgText = null;
    Date msgDate = new Date();
    private transient Throwable throwable;

    public DiagException() {
        this.childs = EMPTY_LIST;
    }

    public DiagException(String msgID, String[] msgParams) {
        this(msgID, msgParams, (String)null);
    }

    public DiagException(String msgText) {
        this(null, null, msgText);
    }

    public DiagException(String msgID, Throwable throwable) {
        this(msgID, null, throwable);
    }

    public DiagException(String msgID, String[] msgParams, Throwable throwable) {
        this(msgID, msgParams, DiagException.getMsgText(throwable));
        this.setThrowable(throwable);
    }

    private DiagException(String msgID, String[] msgParams, String msgText) {
        this();
        if (msgID != null) {
            this.setDiagMessage(new DiagMessage(msgID, msgParams));
            return;
        }
        if (msgText != null) {
            this.setMsgText(msgText);
            return;
        }
    }

    public void addChild(DiagException child) {
        if (child == null) {
            throw new Error("null");
        }
        if (this.childs == EMPTY_LIST) {
            this.childs = new LinkedList();
        }
        this.childs.add(child);
    }

    public Iterator getChilds() {
        return this.childs.iterator();
    }

    public boolean hasChilds() {
        return !this.childs.isEmpty();
    }

    private DiagException getFirstChild() {
        if (this.hasChilds()) {
            DiagException child = (DiagException)this.childs.get(0);
            return child.getFirstChild();
        }
        return this;
    }

    public void setDiagMessage(DiagMessage msg) {
        this.msg = msg;
    }

    public void setDiagMessage(String msgID) {
        this.msg = new DiagMessage();
        this.msg.setMsgID(msgID);
    }

    public void setDiagMessage(String msgID, String msgParam0) {
        this.setDiagMessage(msgID);
        this.msg.setMsgParams(msgParam0);
    }

    public void setDiagMessage(String msgID, String msgParam0, String msgParam1) {
        this.setDiagMessage(msgID);
        this.msg.setMsgParams(msgParam0, msgParam1);
    }

    public void setDiagMessage(String msgID, String[] msgParams) {
        this.setDiagMessage(msgID);
        this.msg.setMsgParams(msgParams);
    }

    public DiagMessage getDiagMessage() {
        return this.msg;
    }

    public void setMsgText(String msgText) {
        this.msgText = msgText;
    }

    public String getMsgText() {
        return this.msgText;
    }

    public Date getMsgDate() {
        return this.msgDate;
    }

    public String getMessage() {
        return this.getMessageChilds("");
    }

    String getMessageChilds(String indent) {
        String msg = "";
        if (this.getMsgText() != null) {
            msg = msg + indent + this.getMsgText() + "\n";
        }
        if (this.getDiagMessage() != null) {
            msg = msg + this.getDiagMessage().getMessage() + "\n";
        }
        String newIndent = msg.length() > 0 ? indent + MSG_INDENT : indent;
        Iterator it = this.getChilds();
        while (it.hasNext()) {
            msg = msg + ((DiagException)it.next()).getMessageChilds(newIndent);
        }
        return msg;
    }

    public String getStackTraceString() {
        StringWriter sw = new StringWriter();
        if (this.hasThrowable()) {
            this.getThrowable().printStackTrace(new PrintWriter(sw));
        } else {
            this.printStackTrace(new PrintWriter(sw));
        }
        return sw.getBuffer().toString();
    }

    public String getLogMessage() {
        String logMessage = this.msg == null ? this.msgText : this.msg.getMessage();
        return logMessage == null ? this.getClass().getName() : logMessage;
    }

    public final Throwable getThrowable() {
        return this.throwable;
    }

    public final boolean hasThrowable() {
        return this.throwable != null;
    }

    protected final void setThrowable(Throwable throwable) {
        this.throwable = throwable;
        if (this.msgText == null) {
            this.setMsgText(DiagException.getMsgText(throwable));
        }
    }

    private static String getMsgText(Throwable throwable) {
        String message = throwable.getMessage() == null ? "" : ": " + throwable.getMessage();
        return throwable.getClass().getName() + message;
    }

    public Object clone() {
        DiagException clone = new DiagException();
        clone.msg = this.msg == null ? null : (DiagMessage)this.msg.clone();
        clone.msgDate = this.msgDate == null ? null : (Date)this.msgDate.clone();
        clone.msgText = this.msgText;
        clone.throwable = this.throwable;
        Iterator it = this.getChilds();
        while (it.hasNext()) {
            DiagException child = (DiagException)it.next();
            clone.addChild((DiagException)child.clone());
        }
        return clone;
    }

    public boolean equals(Object o) {
        if (o instanceof DiagException) {
            DiagException other = (DiagException)o;
            return (this.msg == null ? other.msg == null : this.msg.equals(other.msg)) && (this.msgDate == null ? other.msgDate == null : this.msgDate.equals(other.msgDate)) && (this.msgText == null ? other.msgText == null : this.msgText.equals(other.msgText)) && (this.childs == null ? other.childs == null : ((Object)this.childs).equals(other.childs)) && this.throwable == other.throwable;
        }
        throw new ClassCastException();
    }
}

