/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdt.util.comp;

import com.sap.sdt.util.comp.AbstractPlatformRange;
import com.sap.sdt.util.comp.PlatformRange;
import com.sap.sdt.util.comp.PlatformRangeIF;
import com.sap.sdt.util.comp.XMLConstantsIF;
import com.sap.sdt.util.comp.XMLTags;
import com.sap.sdt.util.vers.VersionFactory;
import com.sap.sdt.util.vers.VersionRangeIF;
import com.sap.sdt.util.xml.IllegalTagException;
import com.sap.sdt.util.xml.InvalidTagException;
import com.sap.sdt.util.xml.MissingTagException;
import com.sap.sdt.util.xml.XMLElementIF;
import com.sap.sdt.util.xml.XMLException;
import com.sap.sdt.util.xml.XMLTagException;
import java.util.Iterator;

public class PlatformRangeFactory
implements XMLConstantsIF {
    public static final String RCSINFO = "$Id: //sdt/com.sap.sdt/0.1/src/_util/java/com/sap/sdt/util/comp/PlatformRangeFactory.java#2 $";

    private PlatformRangeFactory() {
    }

    private PlatformRange getInstance(String os, String db) {
        return new PlatformRange(os, db);
    }

    public PlatformRangeIF createFromXml(XMLElementIF rootElem) throws InvalidTagException {
        XMLElementIF subElem = null;
        String osName = null;
        String dbName = null;
        try {
            osName = rootElem.getAttrString("os");
            dbName = rootElem.getAttrString("db");
        }
        catch (XMLException xmlE) {
            InvalidTagException ex = new InvalidTagException(rootElem);
            ex.addChild(xmlE);
            throw ex;
        }
        PlatformRange pr = this.getInstance(osName, dbName);
        try {
            Iterator it = rootElem.getSubElements();
            if (it.hasNext()) {
                subElem = (XMLElementIF)it.next();
                switch (XMLTags.getCode(subElem)) {
                    case 1: {
                        this.addPair(subElem, pr);
                    }
                }
                throw new IllegalTagException(subElem, rootElem);
            }
        }
        catch (XMLTagException xEx) {
            InvalidTagException ex = new InvalidTagException(rootElem);
            ex.addChild(xEx);
            throw ex;
        }
        return pr;
    }

    private void addPair(XMLElementIF rootElem, AbstractPlatformRange pr) throws IllegalTagException, MissingTagException {
        XMLElementIF subElem = null;
        VersionRangeIF v1 = null;
        VersionRangeIF v2 = null;
        if (!"VersionPair".equals(rootElem.getName())) {
            throw new IllegalTagException(rootElem.getName());
        }
        Iterator it = rootElem.getSubElements();
        if (it.hasNext()) {
            subElem = (XMLElementIF)it.next();
            v1 = VersionFactory.createVersionRange(subElem);
        }
        if (it.hasNext()) {
            subElem = (XMLElementIF)it.next();
            v2 = VersionFactory.createVersionRange(subElem);
        }
        if (v1 == null || v2 == null) {
            throw new MissingTagException("\"Specific\"Range", "VersionPair");
        }
        pr.add(v1, v2);
    }
}

