/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdt.util.comp;

import com.sap.sdt.util.comp.AbstractPlatformRange;
import com.sap.sdt.util.vers.VersionIF;
import com.sap.sdt.util.vers.VersionRangeIF;
import java.util.Arrays;
import java.util.Iterator;

public class PlatformRange
extends AbstractPlatformRange {
    public static final String RCSINFO = "$Id: //sdt/com.sap.sdt/0.1/src/_util/java/com/sap/sdt/util/comp/PlatformRange.java#2 $";
    private int mOsDbInx = 0;
    private int mOsInx = 0;
    private int mDbInx = 0;
    private int aInx = 0;
    private int bInx = 0;
    private AbstractPlatformRange.VPair[] matchesOsDb = null;
    private AbstractPlatformRange.VPair[] matchesOs = null;
    private AbstractPlatformRange.VPair[] matchesDb = null;
    private AbstractPlatformRange.VPair[] above = null;
    private AbstractPlatformRange.VPair[] below = null;
    private AbstractPlatformRange.VPair vComparator = new AbstractPlatformRange.VPair();

    public PlatformRange(String _osName, String _dbName) {
        super(_osName, _dbName);
    }

    public VersionRangeIF[] getMatchingRange(VersionIF osVers, VersionIF dbVers) {
        VersionRangeIF[] result = new VersionRangeIF[2];
        this.rateRanges(osVers, dbVers);
        if (this.mOsDbInx > 0) {
            result[0] = this.matchesOsDb[0].os;
            result[1] = this.matchesOsDb[0].db;
            return result;
        }
        return null;
    }

    public VersionRangeIF[] getUpgradeDbRange(VersionIF osVers, VersionIF dbVers) {
        VersionRangeIF[] result = new VersionRangeIF[2];
        this.rateRanges(osVers, dbVers);
        if (this.mOsInx > 0) {
            result[0] = this.matchesOs[0].os;
            result[1] = this.matchesOs[0].db;
            return result;
        }
        return null;
    }

    public VersionRangeIF[] getUpgradeOsRange(VersionIF osVers, VersionIF dbVers) {
        VersionRangeIF[] result = new VersionRangeIF[2];
        this.rateRanges(osVers, dbVers);
        if (this.mDbInx > 0) {
            result[0] = this.matchesDb[0].os;
            result[1] = this.matchesDb[0].db;
            return result;
        }
        return null;
    }

    public VersionRangeIF[] getUpgradeOsDbRange(VersionIF osVers, VersionIF dbVers) {
        VersionRangeIF[] result = new VersionRangeIF[2];
        this.rateRanges(osVers, dbVers);
        if (this.aInx > 0) {
            result[0] = this.above[0].os;
            result[1] = this.above[0].db;
            return result;
        }
        return null;
    }

    public VersionRangeIF[] getDowngradeRange(VersionIF osVers, VersionIF dbVers) {
        VersionRangeIF[] result = new VersionRangeIF[2];
        this.rateRanges(osVers, dbVers);
        if (this.bInx > 0) {
            result[0] = this.below[this.bInx - 1].os;
            result[1] = this.below[this.bInx - 1].db;
            return result;
        }
        return null;
    }

    private void rateRanges(VersionIF osVers, VersionIF dbVers) {
        AbstractPlatformRange.VPair vp = null;
        this.matchesOsDb = new AbstractPlatformRange.VPair[this.combinations.size()];
        this.matchesOs = new AbstractPlatformRange.VPair[this.combinations.size()];
        this.matchesDb = new AbstractPlatformRange.VPair[this.combinations.size()];
        this.above = new AbstractPlatformRange.VPair[this.combinations.size()];
        this.below = new AbstractPlatformRange.VPair[this.combinations.size()];
        this.mOsDbInx = 0;
        this.mOsInx = 0;
        this.mDbInx = 0;
        this.aInx = 0;
        this.bInx = 0;
        Iterator it = this.combinations.iterator();
        while (it.hasNext()) {
            vp = (AbstractPlatformRange.VPair)it.next();
            if (PlatformRange.match(vp.os, osVers) && PlatformRange.match(vp.db, dbVers)) {
                this.matchesOsDb[this.mOsDbInx] = vp;
                ++this.mOsDbInx;
                continue;
            }
            if (PlatformRange.match(vp.db, dbVers) && PlatformRange.compareLow(vp.os, osVers) >= 0) {
                this.matchesDb[this.mDbInx] = vp;
                ++this.mDbInx;
                continue;
            }
            if (PlatformRange.match(vp.os, osVers) && PlatformRange.compareLow(vp.db, dbVers) >= 0) {
                this.matchesOs[this.mOsInx] = vp;
                ++this.mOsInx;
                continue;
            }
            if (PlatformRange.compareLow(vp.os, osVers) >= 0 && PlatformRange.compareLow(vp.db, dbVers) >= 0) {
                this.above[this.aInx] = vp;
                ++this.aInx;
                continue;
            }
            this.below[this.bInx] = vp;
            ++this.bInx;
        }
        Arrays.sort(this.matchesOsDb, 0, this.mOsDbInx, this.vComparator);
        Arrays.sort(this.matchesOs, 0, this.mOsInx, this.vComparator);
        Arrays.sort(this.matchesDb, 0, this.mDbInx, this.vComparator);
        Arrays.sort(this.above, 0, this.aInx, this.vComparator);
        Arrays.sort(this.below, 0, this.bInx, this.vComparator);
    }

    class VComparator
    extends AbstractPlatformRange.VComp {
        VComparator() {
        }

        public int compare(Object a, Object b) {
            return this.checkVers((VersionRangeIF)a, (VersionRangeIF)b);
        }

        public boolean equals(Object a, Object b) {
            return this.compare(a, b) == 0;
        }
    }
}

