/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdt.util.comp;

import com.sap.sdt.util.comp.NoSuchOsNameException;
import com.sap.sdt.util.comp.OSArchitecture;
import com.sap.sdt.util.comp.OSFamily;
import com.sap.sdt.util.misc.AbstractEnumeratedElement;
import com.sap.sdt.util.misc.EnumerationElementIF;

public class OSName
extends AbstractEnumeratedElement {
    public static final String RCSINFO = "$Id: //sdt/com.sap.sdt/0.1/src/_util/java/com/sap/sdt/util/comp/OSName.java#2 $";
    private final String enum_name;
    public static final OSName alphaosf = new OSName("alphaosf");
    public static final OSName hp_32 = new OSName("hp_32");
    public static final OSName hp_64 = new OSName("hp_64");
    public static final OSName hpia64_32 = new OSName("hpia64_32");
    public static final OSName hpia64 = new OSName("hpia64");
    public static final OSName linuxintel = new OSName("linuxintel");
    public static final OSName linuxia64_32 = new OSName("linuxia64_32");
    public static final OSName linuxia64 = new OSName("linuxia64");
    public static final OSName linuxppc64_32 = new OSName("linuxppc64_32");
    public static final OSName linuxppc64 = new OSName("linuxppc64");
    public static final OSName linuxx86_64 = new OSName("linuxx86_64");
    public static final OSName linuxs390x = new OSName("linuxs390x");
    public static final OSName ntamd64_32 = new OSName("ntamd64_32");
    public static final OSName ntamd64 = new OSName("ntamd64");
    public static final OSName ntia64_32 = new OSName("ntia64_32");
    public static final OSName ntia64 = new OSName("ntia64");
    public static final OSName ntintel = new OSName("ntintel");
    public static final OSName os390 = new OSName("os390");
    public static final OSName rs6000 = new OSName("rs6000");
    public static final OSName rs6000_64 = new OSName("rs6000_64");
    public static final OSName sun = new OSName("sun");
    public static final OSName sun_64 = new OSName("sun_64");
    public static final OSName as400_pase_64 = new OSName("as400_pase_64");

    private OSName(String name) {
        this.enum_name = name;
    }

    public String toString() {
        return this.enum_name;
    }

    public EnumerationElementIF parseElement(String s) throws NoSuchOsNameException {
        return OSName.parseOSName(s);
    }

    public EnumerationElementIF[] getElements() {
        return OSName.getAll();
    }

    public static OSName[] getAll() {
        OSName[] names = new OSName[22];
        names[0] = rs6000;
        names[1] = rs6000_64;
        names[2] = ntamd64_32;
        names[2] = ntamd64;
        names[3] = as400_pase_64;
        names[4] = alphaosf;
        names[5] = hp_32;
        names[6] = hp_64;
        names[7] = hpia64_32;
        names[8] = hpia64;
        names[9] = ntintel;
        names[10] = ntia64_32;
        names[11] = ntia64;
        names[12] = linuxintel;
        names[13] = linuxia64_32;
        names[14] = linuxia64;
        names[15] = linuxppc64_32;
        names[16] = linuxppc64;
        names[17] = linuxx86_64;
        names[18] = os390;
        names[19] = linuxs390x;
        names[20] = sun;
        names[21] = sun_64;
        return names;
    }

    public static OSName parseOSName(String s) throws NoSuchOsNameException {
        Object[] names = OSName.getAll();
        for (int i = 0; i < names.length; ++i) {
            if (!s.equals(names[i].toString())) continue;
            return names[i];
        }
        throw new NoSuchOsNameException(s, names);
    }

    public static OSName getOSName(OSFamily family, OSArchitecture arch) throws NoSuchOsNameException {
        boolean is64bit;
        boolean bl = is64bit = arch == OSArchitecture._64;
        if (OSFamily.HPIA64 == family) {
            return is64bit ? hpia64 : hpia64_32;
        }
        if (OSFamily.HP11_32 == family) {
            return hp_32;
        }
        if (OSFamily.HP11_64 == family) {
            return is64bit ? hp_64 : hp_32;
        }
        if (OSFamily.SUNOS_32 == family) {
            return sun;
        }
        if (OSFamily.SUNOS_64 == family) {
            return is64bit ? sun_64 : sun;
        }
        if (OSFamily.S390X_64 == family) {
            return linuxs390x;
        }
        if (OSFamily.LINUX_32 == family) {
            return linuxintel;
        }
        if (OSFamily.LINUXIA64_64 == family) {
            return is64bit ? linuxia64 : linuxia64_32;
        }
        if (OSFamily.LINUXPPC64_64 == family) {
            return is64bit ? linuxppc64 : linuxppc64_32;
        }
        if (OSFamily.LINUXX86_64 == family) {
            return linuxx86_64;
        }
        if (OSFamily.DEC_64 == family) {
            return alphaosf;
        }
        if (OSFamily.AIX_32 == family) {
            return rs6000;
        }
        if (OSFamily.AIX_64 == family) {
            return is64bit ? rs6000_64 : rs6000;
        }
        if (OSFamily.AIX4_32 == family) {
            return rs6000;
        }
        if (OSFamily.AIX4_64 == family) {
            return is64bit ? rs6000_64 : rs6000;
        }
        if (OSFamily.IA64 == family) {
            return is64bit ? ntia64 : ntia64_32;
        }
        if (OSFamily.AMD64 == family) {
            return is64bit ? ntamd64 : ntamd64_32;
        }
        if (OSFamily.I386 == family) {
            return ntintel;
        }
        if (OSFamily.AS400 == family) {
            return as400_pase_64;
        }
        if (OSFamily.OS390_32 == family) {
            return os390;
        }
        throw new NoSuchOsNameException(family, arch);
    }
}

