/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdt.util.comp;

import com.sap.sdt.util.comp.CompInfo;
import com.sap.sdt.util.comp.NoSuchOsNameException;
import com.sap.sdt.util.comp.OSArchitecture;
import com.sap.sdt.util.comp.OSCode;
import com.sap.sdt.util.comp.OSFamily;
import com.sap.sdt.util.comp.OSInfoIF;
import com.sap.sdt.util.comp.OSName;
import com.sap.sdt.util.comp.OSType;

public class OSInfo
extends CompInfo
implements OSInfoIF {
    public static final String RCSINFO = "$Id: //sdt/com.sap.sdt/0.1/src/_util/java/com/sap/sdt/util/comp/OSInfo.java#2 $";
    private OSCode code = null;
    private OSType type = null;
    private OSFamily family = null;
    private OSName name = null;
    private OSArchitecture architecture = null;
    private boolean unicode;

    OSInfo(OSCode _code, OSType _type, OSFamily _family, OSArchitecture _architecture, boolean _unicode) throws NoSuchOsNameException {
        super(0);
        this.setOsCode(_code);
        this.setOsType(_type);
        this.setOsFamily(_family);
        this.setOsArchitecture(_architecture);
        this.setUnicode(_unicode);
        this.setOsName(OSName.getOSName(_family, _architecture));
    }

    public OSCode getOsCode() {
        return this.code;
    }

    void setOsCode(OSCode _code) {
        this.code = _code;
    }

    public OSType getOsType() {
        return this.type;
    }

    void setOsType(OSType _type) {
        if (!(this.code.equals(OSCode.OS4) && _type.equals(OSType.OS400) || this.code.equals(OSCode.UNX) && _type.equals(OSType.UNIX) || this.code.equals(OSCode.WIN) && _type.equals(OSType.NT))) {
            throw new IllegalArgumentException();
        }
        this.type = _type;
    }

    public OSFamily getOsFamily() {
        return this.family;
    }

    void setOsFamily(OSFamily _family) {
        this.family = _family;
    }

    public OSName getOsName() {
        return this.name;
    }

    void setOsName(OSName _name) {
        this.name = _name;
    }

    public OSArchitecture getOsArchitecture() {
        return this.architecture;
    }

    void setOsArchitecture(OSArchitecture _architecture) {
        this.architecture = _architecture;
    }

    public boolean isUnicode() {
        return this.unicode;
    }

    void setUnicode(boolean _unicode) {
        this.unicode = _unicode;
    }

    public boolean isWindows() {
        return this.code == OSCode.WIN;
    }

    public boolean isUnix() {
        return this.code == OSCode.UNX;
    }

    public boolean isOs400() {
        return this.code == OSCode.OS4;
    }

    public String toString() {
        return "" + this.type + ' ' + this.family + ' ' + this.architecture + ' ' + (this.unicode ? "unicode" : "non-unicode");
    }
}

