/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdt.util.comp;

import com.sap.sdt.util.comp.CodeFormatException;
import com.sap.sdt.util.misc.AbstractEnumeratedElement;
import com.sap.sdt.util.misc.EnumerationElementIF;

public class DBCode
extends AbstractEnumeratedElement {
    public static final String RCSINFO = "$Id: //sdt/com.sap.sdt/0.1/src/_util/java/com/sap/sdt/util/comp/DBCode.java#2 $";
    private final String enum_name;
    public static final DBCode ORA = new DBCode("ORA");
    public static final DBCode INF = new DBCode("INF");
    public static final DBCode MSS = new DBCode("MSS");
    public static final DBCode MAX = new DBCode("MAX");
    public static final DBCode DB2 = new DBCode("DB2");
    public static final DBCode DB4 = new DBCode("DB4");
    public static final DBCode DB6 = new DBCode("DB6");

    private DBCode(String name) {
        this.enum_name = name;
    }

    public String toString() {
        return this.enum_name;
    }

    public EnumerationElementIF parseElement(String s) throws CodeFormatException {
        return DBCode.parseDBCode(s);
    }

    public EnumerationElementIF[] getElements() {
        return DBCode.getAll();
    }

    public int getId() {
        return DBCode.getId(this.enum_name);
    }

    public static DBCode[] getAll() {
        DBCode[] codes = new DBCode[]{ORA, INF, MSS, MAX, DB2, DB4, DB6};
        return codes;
    }

    public static DBCode parseDBCode(String s) throws CodeFormatException {
        if (s.equals(ORA.toString())) {
            return ORA;
        }
        if (s.equals(INF.toString())) {
            return INF;
        }
        if (s.equals(MSS.toString())) {
            return MSS;
        }
        if (s.equals(MAX.toString())) {
            return MAX;
        }
        if (s.equals(DB2.toString())) {
            return DB2;
        }
        if (s.equals(DB4.toString())) {
            return DB4;
        }
        if (s.equals(DB6.toString())) {
            return DB6;
        }
        throw new CodeFormatException(s, DBCode.getAll());
    }

    public static int getIdE(String s) throws CodeFormatException {
        if (s.equals(ORA.toString())) {
            return 6;
        }
        if (s.equals(INF.toString())) {
            return 3;
        }
        if (s.equals(MSS.toString())) {
            return 5;
        }
        if (s.equals(MAX.toString())) {
            return 4;
        }
        if (s.equals(DB2.toString())) {
            return 0;
        }
        if (s.equals(DB4.toString())) {
            return 1;
        }
        if (s.equals(DB6.toString())) {
            return 2;
        }
        throw new CodeFormatException(s, DBCode.getAll());
    }

    public static String getIdStr(int code) {
        switch (code) {
            case 0: {
                return DB2.toString();
            }
            case 1: {
                return DB4.toString();
            }
            case 2: {
                return DB6.toString();
            }
            case 3: {
                return INF.toString();
            }
            case 4: {
                return MAX.toString();
            }
            case 5: {
                return MSS.toString();
            }
            case 6: {
                return ORA.toString();
            }
        }
        return "NON";
    }

    public static int getId(String s) {
        try {
            return DBCode.getIdE(s);
        }
        catch (CodeFormatException e) {
            return -1;
        }
    }
}

