/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdt.util.comp;

import com.sap.sdt.util.comp.PlatformRangeIF;
import com.sap.sdt.util.vers.VersionException;
import com.sap.sdt.util.vers.VersionIF;
import com.sap.sdt.util.vers.VersionRangeIF;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public abstract class AbstractPlatformRange
implements PlatformRangeIF {
    public static final String RCSINFO = "$Id: //sdt/com.sap.sdt/0.1/src/_util/java/com/sap/sdt/util/comp/AbstractPlatformRange.java#2 $";
    private String osName = null;
    private String dbName = null;
    List combinations = new LinkedList();

    public AbstractPlatformRange(String _osName, String _dbName) {
        this.osName = _osName;
        this.dbName = _dbName;
    }

    static boolean match(VersionRangeIF a, VersionIF b) {
        try {
            return a.contains(b);
        }
        catch (VersionException versionException) {
            return false;
        }
    }

    static int compareLow(VersionRangeIF a, VersionIF b) {
        try {
            return a.getLowLimit().compare(b);
        }
        catch (VersionException versionException) {
            return 0;
        }
    }

    static int compareHigh(VersionRangeIF a, VersionIF b) {
        try {
            return a.getHighLimit().compare(b);
        }
        catch (VersionException versionException) {
            return 0;
        }
    }

    public boolean contains(VersionIF osVers, VersionIF dbVers) {
        if (osVers == null || dbVers == null) {
            return false;
        }
        VPair vp = null;
        Iterator it = this.combinations.iterator();
        while (it.hasNext()) {
            vp = (VPair)it.next();
            try {
                if (!vp.os.contains(osVers) || !vp.db.contains(dbVers)) continue;
                return true;
            }
            catch (VersionException ex) {
            }
        }
        return false;
    }

    void add(VersionRangeIF osVers, VersionRangeIF dbVers) {
        this.combinations.add(new VPair(osVers, dbVers));
    }

    class VPair
    extends VComp {
        VersionRangeIF os;
        VersionRangeIF db;

        VPair() {
            this.os = null;
            this.db = null;
        }

        VPair(VersionRangeIF _os, VersionRangeIF _db) {
            this.os = null;
            this.db = null;
            this.os = _os;
            this.db = _db;
        }

        public int compare(Object a, Object b) {
            return this.checkVPairOS((VPair)a, (VPair)b);
        }

        public boolean equals(Object a, Object b) {
            return this.compare(a, b) == 0;
        }

        private int checkVPairOS(VPair a, VPair b) {
            return this.checkVers(a.os, b.os);
        }
    }

    abstract class VComp
    implements Comparator {
        VComp() {
        }

        int checkVers(VersionRangeIF a, VersionRangeIF b) {
            try {
                VersionIF v1 = null;
                VersionIF v2 = null;
                v1 = a.getLowLimit();
                v2 = b.getLowLimit();
                if (v1 == null && v2 == null) {
                    return 0;
                }
                if (v1 == null) {
                    return -1;
                }
                if (v2 == null) {
                    return 1;
                }
                return v1.compare(v2);
            }
            catch (VersionException versionException) {
                return 0;
            }
        }
    }
}

