/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdt.util.arg;

import com.sap.sdt.util.arg.AbstractArg;
import com.sap.sdt.util.arg.ParameterIF;
import com.sap.sdt.util.string.StringFilter;
import java.util.List;

public class Parameter
extends AbstractArg
implements ParameterIF {
    public static final String RCSINFO = "$Id: //sdt/com.sap.sdt/0.1/src/_util/java/com/sap/sdt/util/arg/Parameter.java#2 $";
    private String value = null;
    private int index = 0;
    private String defaultValue = null;
    private boolean optional = false;
    private StringFilter filter = null;

    public Parameter() {
    }

    public Parameter(String name) {
        super(name);
        this.setName(name);
    }

    public Parameter(String name, boolean _optional) {
        super(name);
        this.optional = _optional;
    }

    public Parameter(String name, String desc) {
        super(name, new String[]{desc});
        this.setName(name);
    }

    public Parameter(String name, String[] desc) {
        super(name, desc);
        this.setName(name);
    }

    public Parameter(String name, boolean _optional, String desc) {
        super(name, new String[]{desc});
        this.optional = _optional;
    }

    public Parameter(String name, boolean _optional, String[] desc) {
        super(name, desc);
        this.optional = _optional;
    }

    public void setName(String arg) {
        if (arg == null || arg.length() == 0) {
            return;
        }
        if (arg.charAt(0) == '[' && arg.charAt(arg.length() - 1) == ']') {
            super.setName(arg.substring(1, arg.length() - 1));
            this.optional = true;
        }
    }

    public String getValue() {
        if (this.value != null) {
            return this.value;
        }
        return this.defaultValue;
    }

    public void setValue(String _value) {
        this.value = _value;
    }

    public void setIndex(int inx) {
        this.index = inx;
    }

    public int getIndex() {
        return this.index;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(String _value) {
        this.defaultValue = _value;
    }

    public boolean isSet() {
        return this.value != null;
    }

    public boolean isOptional() {
        return this.optional;
    }

    public boolean hasValidValue() {
        return this.isAllowedValue(this.value);
    }

    public boolean isAllowedValue(String value) {
        if (this.filter == null) {
            return true;
        }
        return this.filter.isAllowed(value);
    }

    public void addAllowedValues(String[] vals) {
        if (this.filter == null) {
            this.filter = new StringFilter();
        }
        this.filter.addAllowed(vals);
    }

    public void addValueRegex(String regex) {
        if (this.filter == null) {
            this.filter = new StringFilter();
        }
        this.filter.setRegex(regex);
    }

    public void writeHelpAppend(List msg, String ident1, String ident2) {
        if (msg == null) {
            return;
        }
        StringBuffer line = new StringBuffer();
        String[] desc = null;
        boolean optPrinted = false;
        int inx = 0;
        line.append(ident1);
        line.append(this.getName());
        desc = this.getDescription();
        if (line.length() <= ident2.length()) {
            while (line.length() < ident2.length()) {
                line.append(' ');
            }
        } else {
            msg.add(line.toString());
            line = new StringBuffer();
            line.append(ident2);
        }
        if (this.optional && desc.length == 1 && line.length() < 75) {
            line.append("(opt)");
            optPrinted = true;
        }
        if (desc.length > 0) {
            line.append(desc[0]);
        }
        msg.add(line.toString());
        for (inx = 1; inx < desc.length; ++inx) {
            line = new StringBuffer();
            line.append(ident2);
            line.append(desc[inx]);
            msg.add(line.toString());
        }
        if (this.optional && !optPrinted) {
            line = new StringBuffer();
            line.append(ident2);
            line.append("(The parameter is optional.)");
            msg.add(line.toString());
        }
    }
}

