/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdt.util.arg;

import com.sap.sdt.util.arg.AbstractArg;
import com.sap.sdt.util.arg.OptionIF;
import com.sap.sdt.util.string.StringFilter;
import java.util.List;

public class Option
extends AbstractArg
implements OptionIF {
    public static final String RCSINFO = "$Id: //sdt/com.sap.sdt/0.1/src/_util/java/com/sap/sdt/util/arg/Option.java#2 $";
    private static final char MINUS = '-';
    private static final char EQUAL = '=';
    private static final String TRUE_STR = "true";
    private static final String FALSE_STR = "false";
    private String value = null;
    private boolean booleanValue = false;
    private String defaultValue = null;
    private StringFilter filter = null;

    public Option() {
    }

    public Option(String name) {
        super(name);
    }

    public Option(String name, boolean defVal) {
        super(name);
        this.setDefaultValue(defVal);
    }

    public Option(String name, String defVal) {
        super(name);
        this.setDefaultValue(defVal);
    }

    public Option(String name, boolean defVal, String desc) {
        super(name, new String[]{desc});
        this.setDefaultValue(defVal);
    }

    public Option(String name, String defVal, String desc) {
        super(name, new String[]{desc});
        this.setDefaultValue(defVal);
    }

    public Option(String name, boolean defVal, String[] desc) {
        super(name, desc);
        this.setDefaultValue(defVal);
    }

    public Option(String name, String defVal, String[] desc) {
        super(name, desc);
        this.setDefaultValue(defVal);
    }

    public void parse(String inBuffer) {
        if (inBuffer == null) {
            return;
        }
        String buffer = inBuffer.trim();
        if (buffer.length() <= 0) {
            return;
        }
        int offs = 0;
        if (buffer.charAt(offs) == '-') {
            ++offs;
        }
        int eqPos = buffer.indexOf(61);
        String name = null;
        String value = null;
        if (eqPos < 0) {
            name = buffer.substring(offs, buffer.length());
            value = TRUE_STR;
        } else {
            name = buffer.substring(offs, eqPos);
            value = buffer.substring(eqPos + 1, buffer.length());
        }
        if (this.getName() != null) {
            if (!name.equals(this.getName())) {
                return;
            }
            this.setValue(value);
        } else {
            this.setName(name);
            this.setValue(value);
        }
    }

    public String getValue() {
        if (this.value != null) {
            return this.value;
        }
        return this.defaultValue;
    }

    public void setValue(String _value) {
        this.booleanValue = _value.equalsIgnoreCase(TRUE_STR) || _value.equalsIgnoreCase(FALSE_STR);
        this.value = this.booleanValue ? _value.toLowerCase() : _value;
    }

    public void setValue(boolean val) {
        this.booleanValue = true;
        this.value = val ? TRUE_STR : FALSE_STR;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(String _value) {
        this.defaultValue = _value;
    }

    public void setDefaultValue(boolean _value) {
        this.booleanValue = true;
        this.defaultValue = _value ? TRUE_STR : FALSE_STR;
    }

    public boolean isSet() {
        if (this.value == null) {
            return false;
        }
        return this.booleanValue ? this.value.equals(TRUE_STR) : true;
    }

    public boolean isBoolean() {
        return this.booleanValue;
    }

    public boolean checkValue() {
        return this.isAllowedValue(this.value);
    }

    public boolean isAllowedValue(String value) {
        if (this.filter == null) {
            return true;
        }
        return this.filter.isAllowed(value);
    }

    public void addAllowedValues(String[] vals) {
        if (this.filter == null) {
            this.filter = new StringFilter();
        }
        this.filter.addAllowed(vals);
    }

    public void addValueRegex(String regex) {
        if (this.filter == null) {
            this.filter = new StringFilter();
        }
        this.filter.setRegex(regex);
    }

    public void writeHelpAppend(List msg, String ident1, String ident2) {
        StringBuffer line = new StringBuffer();
        String[] desc = null;
        line.append(ident1);
        line.append('-');
        line.append(this.getName());
        if (this.isBoolean()) {
            line.append("[='bool']");
        } else {
            line.append("='val'");
        }
        desc = this.getDescription();
        if (line.length() <= ident2.length()) {
            while (line.length() < ident2.length()) {
                line.append(' ');
            }
        } else {
            msg.add(line.toString());
            line = new StringBuffer();
            line.append(ident2);
        }
        if (desc.length > 0) {
            line.append(desc[0]);
        }
        msg.add(line.toString());
        for (int descInx = 1; descInx < desc.length; ++descInx) {
            line = new StringBuffer();
            line.append(ident2);
            line.append(desc[descInx]);
            msg.add(line.toString());
        }
    }
}

