/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdt.util.arg;

import com.sap.sdt.util.arg.AbstractArg;
import com.sap.sdt.util.arg.CommandIF;
import com.sap.sdt.util.arg.ParameterIF;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class Command
extends AbstractArg
implements CommandIF {
    public static final String RCSINFO = "$Id: //sdt/com.sap.sdt/0.1/src/_util/java/com/sap/sdt/util/arg/Command.java#2 $";
    private int numberOfParameters = 0;
    private List parameters = null;

    public Command() {
    }

    public Command(String name) {
        super(name);
    }

    public Command(String name, int params, String desc) {
        super(name, new String[]{desc});
        this.numberOfParameters = params;
    }

    public Command(String name, int params, String[] desc) {
        super(name, desc);
        this.numberOfParameters = params;
    }

    public Command(String name, String desc, ParameterIF[] params) {
        super(name, new String[]{desc});
        this.numberOfParameters = params.length;
        this.addAllParameters(params);
    }

    public Command(String name, String[] desc, ParameterIF[] params) {
        super(name, desc);
        this.numberOfParameters = params.length;
        this.addAllParameters(params);
    }

    public int getNumberOfParameters() {
        return this.numberOfParameters;
    }

    public void setNumberOfParameters(int params) {
        this.numberOfParameters = params;
    }

    public void addParameter(ParameterIF param) {
        if (this.parameters == null) {
            this.parameters = new ArrayList();
        }
        this.parameters.add(param);
    }

    public void addAllParameters(ParameterIF[] params) {
        if (this.parameters == null) {
            this.parameters = new ArrayList();
        }
        for (int i = 0; i < params.length; ++i) {
            this.parameters.add(params[i]);
        }
    }

    public void addAllParameters(List list) {
        if (this.parameters == null) {
            this.parameters = new ArrayList();
        }
        this.parameters.addAll(list);
    }

    public List getParameters() {
        return this.parameters;
    }

    public ParameterIF getParameter(String paramName) {
        Iterator it = this.parameters.iterator();
        while (it.hasNext()) {
            ParameterIF param = (ParameterIF)it.next();
            if (!paramName.equals(param.getName())) continue;
            return param;
        }
        return null;
    }

    public String getHelpStr() {
        String ret = "";
        ret = ret + this.getName();
        Iterator it = this.parameters.iterator();
        while (it.hasNext()) {
            ParameterIF p = (ParameterIF)it.next();
            if (p.isOptional()) {
                ret = ret + " [" + p.getName() + "]";
                continue;
            }
            ret = ret + " " + p.getName();
        }
        return ret;
    }

    public void writeHelpAppend(List msg, String ident1, String ident2) {
        StringBuffer line = new StringBuffer();
        String[] desc = null;
        if (msg == null) {
            return;
        }
        line.append(ident1);
        line.append(this.getName());
        desc = this.getDescription();
        if (line.length() <= ident2.length()) {
            while (line.length() < ident2.length()) {
                line.append(' ');
            }
        } else {
            msg.add(line.toString());
            line = new StringBuffer();
            line.append(ident2);
        }
        if (desc != null) {
            if (desc.length > 0) {
                line.append(desc[0]);
                msg.add(line.toString());
            }
            for (int descInx = 1; descInx < desc.length; ++descInx) {
                line = new StringBuffer();
                line.append(ident2);
                line.append(desc[descInx]);
            }
        }
    }

    public void writeHelp(List msg, String ident1, String ident2) {
        this.writeHelp(msg, ident1, ident2, true);
    }

    public void writeHelp(List msg, String ident1, String ident2, boolean withParams) {
        if (msg == null) {
            return;
        }
        msg.add(this.getHelpStr());
        msg.add("");
        msg.add("Description:");
        String[] desc = this.getDescription();
        for (int i = 0; i < desc.length; ++i) {
            msg.add(ident1 + desc[i]);
        }
        if (!withParams) {
            return;
        }
        msg.add("");
        this.appendParametersHelp(msg, ident1, ident2);
    }

    private void appendParametersHelp(List msg, String ident1, String ident2) {
        if (msg == null) {
            return;
        }
        if (this.parameters == null || this.parameters.size() == 0) {
            msg.add("Parameters:");
            msg.add(ident1 + "none");
            msg.add("");
            return;
        }
        msg.add("Parameters:");
        Iterator it = this.parameters.iterator();
        while (it.hasNext()) {
            ParameterIF param = (ParameterIF)it.next();
            param.writeHelpAppend(msg, ident1, ident2);
        }
        msg.add("");
    }
}

