/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdt.util.arg;

import com.sap.sdt.trace.ErrMsg;
import com.sap.sdt.trace.InfMsg;
import com.sap.sdt.trace.LogMsg;
import com.sap.sdt.util.arg.ArgIF;
import com.sap.sdt.util.arg.Command;
import com.sap.sdt.util.arg.CommandIF;
import com.sap.sdt.util.arg.Option;
import com.sap.sdt.util.arg.OptionIF;
import com.sap.sdt.util.arg.Parameter;
import com.sap.sdt.util.arg.ParameterIF;
import com.sap.sdt.util.string.SString;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public abstract class AbstractArguments {
    public static final String RCSINFO = "$Id: //sdt/com.sap.sdt/0.1/src/_util/java/com/sap/sdt/util/arg/AbstractArguments.java#2 $";
    private String[] argumentArray = null;
    static final char MINUS = '-';
    static final int TYPE_COMMAND = 0;
    static final int TYPE_PARAMETER = 1;
    static final int TYPE_OPTION = 2;
    private List unknownArgs = new ArrayList();
    private List invalidParams = new ArrayList();
    private CommandIF command = null;
    private String commName = null;
    private boolean commandFound = false;
    private int paramNr = 0;
    private int paramCnt = 0;
    private boolean noCommandSpecified = false;
    private boolean unknownCommand = false;
    private boolean notEnoughParameters = false;
    private boolean unknownOptions = false;
    private boolean tooManyParameters = false;
    private boolean wrongOptionValues = false;
    private int nrCommands = 1;
    private List commands = new ArrayList();
    private List parameters = new ArrayList();
    private List options = new ArrayList();
    protected CommandIF defaultCmd = null;
    private String descIdent = "                         ";
    private String ident = "     ";

    protected AbstractArguments() {
    }

    protected AbstractArguments(int _nrCommands) {
    }

    private void initialize() {
        this.unknownArgs = new ArrayList();
        this.invalidParams = new ArrayList();
        this.command = null;
        this.commName = null;
        this.commandFound = false;
        this.paramNr = 0;
        this.paramCnt = 0;
        this.noCommandSpecified = false;
        this.unknownCommand = false;
        this.notEnoughParameters = false;
        this.unknownOptions = false;
        this.wrongOptionValues = false;
        this.tooManyParameters = false;
        this.parameters = new ArrayList();
        this.options = new ArrayList();
    }

    private void rememberArgs(String[] args) {
        if (args == null) {
            this.argumentArray = new String[0];
        }
        this.argumentArray = new String[args.length];
        for (int i = 0; i < this.argumentArray.length; ++i) {
            this.argumentArray[i] = args[i];
        }
    }

    private String getArgString() {
        return SString.toSeparatedString(this.argumentArray, ' ');
    }

    public boolean parse(String[] args) {
        CommandIF knownCmd = null;
        ParameterIF parameter = null;
        OptionIF option = null;
        boolean firstParam = false;
        this.initialize();
        this.rememberArgs(args);
        firstParam = false;
        this.paramCnt = 0;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].charAt(0) == '-') {
                option = this.parseOption(args[i]);
                if (option != null) continue;
                this.unknownArgs.add(args[i]);
                this.unknownOptions = true;
                continue;
            }
            if (this.commName == null) {
                this.commName = args[i];
                firstParam = true;
            }
            if (firstParam) {
                firstParam = false;
                knownCmd = this.getKnownCommand(args[i]);
                this.command = this.parseCommand(knownCmd, args[i]);
                if (this.command != null) {
                    this.commandFound = true;
                    this.paramNr = this.command.getNumberOfParameters();
                    continue;
                }
                this.command = this.getDefault();
            }
            parameter = this.parseParameter(knownCmd, args[i], this.paramCnt);
            ++this.paramCnt;
            if (parameter.hasValidValue()) continue;
            this.invalidParams.add(parameter);
        }
        if (this.command == null) {
            this.command = this.getDefault();
        }
        if (this.command != null) {
            this.command.addAllParameters(this.parameters);
        }
        this.updateParameterStatus(this.paramCnt, this.paramNr);
        this.updateCommandStatus(this.command, this.commName);
        return this.argsHaveNoError();
    }

    private void updateParameterStatus(int paramCnt, int paramNr) {
        if (paramCnt < paramNr) {
            this.notEnoughParameters = true;
        } else if (paramCnt > paramNr) {
            this.tooManyParameters = true;
        }
    }

    private void updateCommandStatus(CommandIF command, String commName) {
        if (command == null) {
            this.noCommandSpecified = true;
            if (commName != null) {
                this.unknownCommand = true;
            }
        } else {
            this.noCommandSpecified = false;
        }
    }

    public List getCmdMessages() {
        ArrayList<LogMsg> messages = new ArrayList<LogMsg>();
        messages.add(new InfMsg("Command line: " + this.getArgString()));
        if (this.command == null) {
            if (this.commName == null) {
                if (this.nrCommands < 1) {
                    messages.add(new InfMsg("No command specified."));
                } else {
                    messages.add(new ErrMsg("No command specified!"));
                }
            } else {
                messages.add(new ErrMsg("Unknown command '" + this.commName + "'."));
            }
        } else if (this.paramCnt < this.paramNr) {
            messages.add(new ErrMsg("Not enough parameters!"));
            messages.add(new ErrMsg("Command \"" + (this.command != null ? this.command.getName() : "null") + "\" requires " + this.paramNr + " parameters,"));
            messages.add(new ErrMsg("you specified " + this.paramCnt + " parameters."));
        } else if (this.paramCnt > this.paramNr) {
            messages.add(new InfMsg("Too many parameters!"));
            messages.add(new InfMsg("Command \"" + (this.command != null ? this.command.getName() : "null") + "\" requires " + this.paramNr + " parameters,"));
            messages.add(new InfMsg("you specified " + this.paramCnt + " parameters."));
        }
        return messages;
    }

    public List getOptMessages() {
        ArrayList<InfMsg> messages = new ArrayList<InfMsg>();
        Iterator it = this.unknownArgs.iterator();
        while (it.hasNext()) {
            messages.add(new InfMsg("Unknown option '" + (String)it.next() + "'."));
            this.unknownOptions = true;
        }
        return messages;
    }

    public List getMessages() {
        List messages = null;
        List oMsgs = null;
        messages = this.getCmdMessages();
        oMsgs = this.getOptMessages();
        messages.addAll(oMsgs);
        return messages;
    }

    public boolean allArgsOk() {
        return (this.nrCommands <= 0 || !this.noCommandSpecified) && !this.unknownCommand && !this.notEnoughParameters && !this.tooManyParameters && !this.unknownOptions;
    }

    public boolean argsHaveNoError() {
        return (this.nrCommands <= 0 || !this.noCommandSpecified) && !this.unknownCommand && !this.notEnoughParameters;
    }

    public boolean isCmdSpecified() {
        return !this.noCommandSpecified;
    }

    public boolean isCmdKnown() {
        return !this.unknownCommand;
    }

    public boolean areEnoughParameters() {
        return !this.notEnoughParameters;
    }

    public boolean areKnownOptions() {
        return !this.unknownOptions;
    }

    private CommandIF parseCommand(CommandIF knownCommand, String arg) {
        if (knownCommand == null) {
            return null;
        }
        Command command = new Command(arg);
        command.setNumberOfParameters(knownCommand.getNumberOfParameters());
        command.setDescription(knownCommand.getDescription());
        this.commands.add(command);
        return command;
    }

    private CommandIF getDefault() {
        if (this.defaultCmd == null) {
            this.unknownCommand = true;
            return null;
        }
        Command command = new Command(this.defaultCmd.getName());
        command.setNumberOfParameters(this.defaultCmd.getNumberOfParameters());
        this.commands.add(command);
        return command;
    }

    private ParameterIF parseParameter(CommandIF knownCmd, String arg, int paramInx) {
        String[] part = SString.getPartsOfEquation(arg);
        Parameter nParam = null;
        if (part == null || part[1] != null) {
            nParam = new Parameter(part[0]);
            nParam.setValue(part[1]);
        } else {
            ParameterIF kParam = this.getKnownParameter(knownCmd, paramInx);
            nParam = kParam != null ? new Parameter(kParam.getName(), kParam.isOptional()) : new Parameter();
            nParam.setValue(arg);
        }
        nParam.setIndex(paramInx);
        this.parameters.add(nParam);
        return nParam;
    }

    private OptionIF parseOption(String arg) {
        Option option = new Option();
        option.parse(arg);
        OptionIF kno = this.getKnownOption(option);
        if (kno == null) {
            return null;
        }
        option.setDescription(kno.getDescription());
        if (!option.checkValue()) {
            this.wrongOptionValues = true;
        }
        this.options.add(option);
        return option;
    }

    private ParameterIF getKnownParameter(CommandIF cmd, int inx) {
        if (cmd == null) {
            return null;
        }
        List params = cmd.getParameters();
        if (params == null || inx < 0 || inx >= params.size()) {
            return null;
        }
        return (ParameterIF)params.get(inx);
    }

    private CommandIF getKnownCommand(CommandIF command) {
        return this.getKnownCommand(command.getName());
    }

    private CommandIF getKnownCommand(String name) {
        return (CommandIF)this.getKnownArg(name, 0);
    }

    private OptionIF getKnownOption(OptionIF option) {
        return this.getKnownOption(option.getName());
    }

    private OptionIF getKnownOption(String name) {
        return (OptionIF)this.getKnownArg(name, 2);
    }

    private ArgIF getKnownArg(String name, int type) {
        ArgIF[] known = null;
        switch (type) {
            case 0: {
                known = this.getAllKnownCommands();
                break;
            }
            case 2: {
                known = this.getAllKnownOptions();
                break;
            }
            default: {
                return null;
            }
        }
        if (known != null) {
            for (int i = 0; i < known.length; ++i) {
                if (!known[i].getName().equals(name)) continue;
                return known[i];
            }
        }
        return null;
    }

    public CommandIF getCommand() {
        return this.command;
    }

    public List getOptions() {
        return this.options;
    }

    public abstract CommandIF[] getAllKnownCommands();

    public abstract OptionIF[] getAllKnownOptions();

    public List getRelatedHelp() {
        if (this.command == null) {
            return this.printHelp();
        }
        return this.printHelp(this.command.getName());
    }

    public List printHelp() {
        return this.printHelp(null);
    }

    public List printHelp(String commandStr) {
        ArrayList msg = new ArrayList();
        CommandIF comm = null;
        if (commandStr != null) {
            comm = this.getKnownCommand(commandStr);
        }
        if (comm != null) {
            comm.writeHelp(msg, this.ident, this.descIdent);
        } else {
            this.appendGlobalHelp(msg);
        }
        this.appendOptionsHelp(msg);
        return msg;
    }

    private void appendGlobalHelp(List msg) {
        CommandIF[] cmd = this.getAllKnownCommands();
        if (cmd == null || cmd.length == 0) {
            msg.add("Commands:");
            msg.add(this.ident + "none");
            msg.add("");
            return;
        }
        msg.add("Commands:");
        for (int cmdInx = 0; cmdInx < cmd.length; ++cmdInx) {
            cmd[cmdInx].writeHelpAppend(msg, this.ident, this.descIdent);
        }
        msg.add("");
    }

    private void appendOptionsHelp(List msg) {
        OptionIF[] opt = this.getAllKnownOptions();
        if (opt == null || opt.length == 0) {
            msg.add("Options:");
            msg.add(this.ident + "none");
            msg.add("");
            return;
        }
        msg.add("Options:");
        for (int optInx = 0; optInx < opt.length; ++optInx) {
            opt[optInx].writeHelpAppend(msg, this.ident, this.descIdent);
        }
        msg.add("");
    }
}

