/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdt.trace;

import com.sap.sdt.trace.AbstractLogging;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.text.DecimalFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.Enumeration;
import java.util.Properties;

public class SapLoggingAdmin {
    public static final String RCSINFO = "$Id: //sdt/com.sap.sdt/0.1/src/_trace/java/com/sap/sdt/trace/SapLoggingAdmin.java#2 $";
    public static final String packageName = "com.sap.tc.logging";
    public static final String TOP_CATEGORY = "/System/Server/Upgrade";
    public static final String JUMP_CATEGORY = "Jump";
    public static final String DIALOG_CATEGORY = "Dialog";
    public static final String DATABASE_CATEGORY = "Database";
    public static final String PHASES_CATEGORY = "Phases";
    public static final String LOG_FILE_EXTENSION = "LOG";
    public static final String TRACE_FILE_EXTENSION = "TRC";
    public static final String[][] ALL_CATEGORIES = new String[][]{{"Jump", "JUMP.LOG"}, {"Dialog", "DIALOG.LOG"}};
    public static final String LOG_SEVERITY_KEY = "/System/Server/Upgrade.severity";
    public static final String LOG_SEVERITY_VALUE = "INFO";
    public static final String TOP_LOCATION = "com.sap.sdt";
    public static final String TRACE_FILE_NAME = "SDT.TRC";
    public static final String TRACE_SEVERITY_KEY = "com.sap.sdt.severity";
    public static final String TRACE_SEVERITY_VALUE = "ERROR";
    private static final String FORMATTER = "formatter[Jump]";
    public static final String FORMATTER_PATTERN = "%d [%s]: %-100l [%t]: %m";
    private static File traceFile = new File(".", "JUMP.TRC");
    private static File logDir = new File(".");

    public static final void configure() {
        SapLoggingAdmin.configure(SapLoggingAdmin.getProperties());
    }

    public static final void configure(String traceSeverity) {
        SapLoggingAdmin.configure(SapLoggingAdmin.getProperties(traceSeverity));
    }

    public static final void configure(Properties prop) {
        Properties mergedProps = SapLoggingAdmin.getProperties();
        Enumeration<?> enumeration = prop.propertyNames();
        while (enumeration.hasMoreElements()) {
            String name = (String)enumeration.nextElement();
            mergedProps.setProperty(name, prop.getProperty(name));
        }
        AbstractLogging.configure(mergedProps);
    }

    public static Properties getProperties() {
        return SapLoggingAdmin.getProperties(TRACE_SEVERITY_VALUE);
    }

    public static Properties getProperties(String traceSeverity) {
        Properties prop = new Properties();
        SapLoggingAdmin.setEntries(SapLoggingAdmin.getEntries(FORMATTER), prop);
        prop.setProperty(TRACE_SEVERITY_KEY, traceSeverity);
        SapLoggingAdmin.setTraceProperties(prop, "Trace", TOP_LOCATION, SapLoggingAdmin.getTraceFile(), FORMATTER);
        prop.setProperty(LOG_SEVERITY_KEY, LOG_SEVERITY_VALUE);
        for (int i = 0; i < ALL_CATEGORIES.length; ++i) {
            String name = ALL_CATEGORIES[i][0];
            String category = "/System/Server/Upgrade/" + name;
            File logFile = new File(SapLoggingAdmin.getLogDir(), ALL_CATEGORIES[i][1]);
            SapLoggingAdmin.setLogProperties(prop, name, category, logFile, FORMATTER);
        }
        return prop;
    }

    public static Properties getProperties(File logDir, File trcDir) {
        return SapLoggingAdmin.getProperties(logDir, trcDir, TRACE_SEVERITY_VALUE);
    }

    public static Properties getProperties(File logDir, File trcDir, String traceSeverity) {
        File trcFile = new File(trcDir, TRACE_FILE_NAME);
        Properties prop = new Properties();
        SapLoggingAdmin.setEntries(SapLoggingAdmin.getEntries(FORMATTER), prop);
        prop.setProperty(TRACE_SEVERITY_KEY, traceSeverity);
        SapLoggingAdmin.setTraceProperties(prop, "Trace", TOP_LOCATION, trcFile, FORMATTER);
        prop.setProperty(LOG_SEVERITY_KEY, LOG_SEVERITY_VALUE);
        for (int i = 0; i < ALL_CATEGORIES.length; ++i) {
            String name = ALL_CATEGORIES[i][0];
            String category = SapLoggingAdmin.getSubCategory(name);
            File logFile = new File(logDir, ALL_CATEGORIES[i][1]);
            SapLoggingAdmin.setLogProperties(prop, name, category, logFile, FORMATTER);
        }
        return prop;
    }

    public static void createLoggingPropertiesFile(File propFile, File logDir, File trcFile) throws FileNotFoundException {
        SapLoggingAdmin.setTraceFile(trcFile);
        PrintWriter out = new PrintWriter(new FileOutputStream(propFile));
        out.println("# Created by " + SapLoggingAdmin.class + " on " + new Date());
        out.println("### Set up Jump trace and logging format");
        SapLoggingAdmin.printEntries(SapLoggingAdmin.getEntries(FORMATTER), out);
        out.println("\n#### Set up tracing");
        out.println("com.sap.sdt.severity = ERROR");
        out.println("\n#### Set up logging");
        out.println("/System/Server/Upgrade.severity = INFO");
        out.println("");
        out.close();
    }

    public static File getTraceFile() {
        return traceFile;
    }

    public static void setTraceFile(File file) {
        traceFile = file;
    }

    public static File getLogDir() {
        return logDir;
    }

    public static void setLogDir(File dir) {
        logDir = dir;
    }

    private static String getSubCategory(String name) {
        return "/System/Server/Upgrade/" + name;
    }

    private static void printLogProperties(PrintWriter out, String name, String category, File logFile, String formatter) {
        out.println("#### Set up a FileLog for " + name + " logging");
        String logName = "log[" + name + "LogFile]";
        Entry[] entries = SapLoggingAdmin.getEntries(category, logName, logFile, formatter);
        SapLoggingAdmin.printEntries(entries, out);
    }

    private static void printTraceProperties(PrintWriter out, String name, String location, File trcFile, String formatter) {
        out.println("#### Set up a FileLog for " + name + " tracing");
        String traceName = "log[" + name + "LogFile]";
        Entry[] entries = SapLoggingAdmin.getEntries(location, traceName, trcFile, formatter);
        SapLoggingAdmin.printEntries(entries, out);
    }

    private static void setLogProperties(Properties prop, String name, String category, String formatter) {
        String logName = "log[" + name + "LogConsole]";
        Entry[] entries = SapLoggingAdmin.getEntries(category, logName, formatter);
        SapLoggingAdmin.setEntries(entries, prop);
    }

    private static void setLogProperties(Properties prop, String name, String category, File logFile, String formatter) {
        String logName = "log[" + name + "LogFile]";
        Entry[] entries = SapLoggingAdmin.getEntries(category, logName, logFile, formatter);
        SapLoggingAdmin.setEntries(entries, prop);
    }

    private static void setTraceProperties(Properties prop, String name, String location, String formatter) {
        String logName = "log[" + name + "LogConsole]";
        Entry[] entries = SapLoggingAdmin.getEntries(location, logName, formatter);
        SapLoggingAdmin.setEntries(entries, prop);
    }

    private static void setTraceProperties(Properties prop, String name, String location, File trcFile, String formatter) {
        String logName = "log[" + name + "LogFile]";
        Entry[] entries = SapLoggingAdmin.getEntries(location, logName, trcFile, formatter);
        SapLoggingAdmin.setEntries(entries, prop);
    }

    private static Entry[] getEntries(String id, String name, File file, String formatter) {
        Entry[] result = new Entry[]{new Entry(name, "FileLog"), new Entry(name + ".pattern", SapLoggingAdmin.toString(file)), new Entry(name + ".formatter", formatter), new Entry(id + ".logs", name)};
        return result;
    }

    private static Entry[] getEntries(String id, String name, String formatter) {
        Entry[] result = new Entry[]{new Entry(name, "ConsoleLog"), new Entry(name + ".formatter", formatter), new Entry(id + ".logs", name)};
        return result;
    }

    private static Entry[] getEntries(String formatter) {
        Entry[] result = new Entry[]{new Entry(formatter, "TraceFormatter"), new Entry(formatter + ".pattern", FORMATTER_PATTERN)};
        return result;
    }

    private static void setEntries(Entry[] entries, Properties prop) {
        for (int i = 0; i < entries.length; ++i) {
            entries[i].set(prop);
        }
    }

    private static void printEntries(Entry[] entries, PrintWriter out) {
        for (int i = 0; i < entries.length; ++i) {
            entries[i].println(out);
        }
    }

    private static String toString(File file) {
        String string = file.getAbsolutePath();
        if (File.separatorChar == '\\') {
            StringBuffer b = new StringBuffer();
            for (int i = 0; i < string.length(); ++i) {
                char c = string.charAt(i);
                if (c == File.separatorChar) {
                    b.append(File.separatorChar);
                }
                b.append(c);
            }
            string = b.toString();
        }
        return string;
    }

    public static File getUniqueFile(File file) {
        String fileName;
        String name = fileName = file.getName();
        String extension = "";
        int index = fileName.lastIndexOf(".");
        if (index > 0) {
            name = fileName.substring(0, index);
            extension = fileName.substring(index);
        }
        DecimalFormat df = SapLoggingAdmin.getDecimalFormat(99L);
        for (long suffix = 1L; suffix < Long.MAX_VALUE; ++suffix) {
            if (suffix > 99L) {
                df = SapLoggingAdmin.getDecimalFormat(suffix);
            }
            String newFileName = name + "_" + df.format(suffix) + extension;
            File newFile = new File(file.getParent(), newFileName);
            if (newFile.exists()) continue;
            return newFile;
        }
        return null;
    }

    public static void renameFiles(File logDir, String category) {
        for (int i = 0; i < ALL_CATEGORIES.length; ++i) {
            String catName = ALL_CATEGORIES[i][0];
            if (!category.equals(catName)) continue;
            String fileName = ALL_CATEGORIES[i][1];
            File logFile = new File(logDir, fileName);
            SapLoggingAdmin.rename(logFile);
            break;
        }
    }

    public static void renameFiles(File file) {
        if (file.isDirectory()) {
            String[] fileName = file.list();
            for (int i = 0; i < fileName.length; ++i) {
                SapLoggingAdmin.rename(new File(file, fileName[i]));
            }
        } else {
            SapLoggingAdmin.rename(file);
        }
    }

    private static void rename(File file) {
        if (file.exists()) {
            String fileName = file.getName();
            if (SapLoggingAdmin.isRenamedFileName(fileName)) {
                return;
            }
            int index = fileName.lastIndexOf(".");
            if (index > 0) {
                String name = fileName.substring(0, index);
                String extension = fileName.substring(index);
                DecimalFormat df = SapLoggingAdmin.getDecimalFormat(99L);
                for (long suffix = 1L; suffix < Long.MAX_VALUE; ++suffix) {
                    if (suffix > 99L) {
                        df = SapLoggingAdmin.getDecimalFormat(suffix);
                    }
                    String newFileName = name + "_" + df.format(suffix) + extension;
                    File newFile = new File(file.getParent(), newFileName);
                    if (newFile.exists()) continue;
                    file.renameTo(newFile);
                    return;
                }
            }
        }
    }

    private static boolean isRenamedFileName(String fileName) {
        int index = fileName.lastIndexOf(".");
        if (index > 0) {
            String name = fileName.substring(0, index);
            String extension = fileName.substring(index);
            char lastChar = name.charAt(name.length() - 1);
            if (Character.isDigit(lastChar) && (index = name.lastIndexOf("_")) > 0) {
                String s = name.substring(index + 1);
                try {
                    long suffix = Long.parseLong(s);
                    return true;
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
            }
        }
        return false;
    }

    private static DecimalFormat getDecimalFormat(long suffix) {
        if (suffix < 100L) {
            return new DecimalFormat("00");
        }
        int digits = String.valueOf(suffix).length();
        char[] zeroes = new char[digits];
        Arrays.fill(zeroes, '0');
        return new DecimalFormat(new String(zeroes));
    }

    private static class Entry {
        private String key;
        private String value;

        public Entry(String key, String value) {
            this.key = key;
            this.value = value;
        }

        public String getKey() {
            return this.key;
        }

        public String getValue() {
            return this.value;
        }

        public void println(PrintWriter out) {
            out.println(this.key + " = " + this.value);
        }

        public void set(Properties prop) {
            prop.setProperty(this.key, this.value);
        }
    }
}

