/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdt.trace;

import com.sap.sdt.trace.AbstractLogging;
import com.sap.sdt.trace.LoggableExceptionIF;
import com.sap.sdt.trace.LoggerIF;
import com.sap.tc.logging.Category;
import com.sap.tc.logging.FileLog;
import java.io.File;
import java.util.Iterator;

public class Logger
extends AbstractLogging
implements LoggerIF {
    public static final String RCSINFO = "$Id: //sdt/com.sap.sdt/0.1/src/_trace/java/com/sap/sdt/trace/Logger.java#2 $";
    private Category category;
    private FileLog logObject;

    public Logger(String category) {
        String fullCategory = "/System/Server/Upgrade/" + category;
        this.category = Category.getCategory(fullCategory);
        this.logObject = null;
    }

    public Logger(Category category) {
        this.category = category;
        this.logObject = null;
    }

    public Logger(String category, File file) {
        String fullCategory = "/System/Server/Upgrade/" + category;
        this.logObject = new FileLog(file.getAbsolutePath());
        this.logObject.setFormatter(traceFormatter);
        this.category = Category.getCategory(fullCategory);
        this.category.addLog(this.logObject);
        this.category.setEffectiveSeverity(INFO);
    }

    public Category getCategory() {
        return this.category;
    }

    public void fatal(Class clazz, String msg) {
        this.log(this.category, FATAL, clazz, msg, new Object[0]);
    }

    public void fatal(Class clazz, String msg, Object arg) {
        this.log(this.category, FATAL, clazz, msg, new Object[]{arg});
    }

    public void fatal(Class clazz, String msg, Object arg1, Object arg2) {
        this.log(this.category, FATAL, clazz, msg, new Object[]{arg1, arg2});
    }

    public void fatal(Class clazz, String msg, Object[] args) {
        this.log(this.category, FATAL, clazz, msg, args);
    }

    public void error(Class clazz, String msg) {
        this.log(this.category, ERROR, clazz, msg, new Object[0]);
    }

    public void error(Class clazz, String msg, Object arg) {
        this.log(this.category, ERROR, clazz, msg, new Object[]{arg});
    }

    public void error(Class clazz, String msg, Object arg1, Object arg2) {
        this.log(this.category, ERROR, clazz, msg, new Object[]{arg1, arg2});
    }

    public void error(Class clazz, String msg, Object[] args) {
        this.log(this.category, ERROR, clazz, msg, args);
    }

    public void error(Class clazz, LoggableExceptionIF ex) {
        StackTraceElement[] trace;
        if (ex.hasChilds()) {
            Iterator it = ex.getChilds();
            while (it.hasNext()) {
                LoggableExceptionIF child = (LoggableExceptionIF)it.next();
                this.error(clazz, child);
            }
        }
        if ((trace = ex.getStackTrace()) != null && trace.length > 0) {
            String loggedClassName = Logger.getLocation(trace[0]);
            this.log(this.category, ERROR, loggedClassName, ex.getLogMessage(), new Object[0]);
        } else {
            this.log(this.category, ERROR, clazz, ex.getLogMessage(), new Object[0]);
        }
        if (!ex.hasChilds()) {
            Logger.trace(ERROR, clazz, ex.getStackTraceString(), new Object[0]);
        }
    }

    public void warning(Class clazz, String msg) {
        this.log(this.category, WARNING, clazz, msg, new Object[0]);
    }

    public void warning(Class clazz, String msg, Object arg) {
        this.log(this.category, WARNING, clazz, msg, new Object[]{arg});
    }

    public void warning(Class clazz, String msg, Object arg1, Object arg2) {
        this.log(this.category, WARNING, clazz, msg, new Object[]{arg1, arg2});
    }

    public void warning(Class clazz, String msg, Object[] args) {
        this.log(this.category, WARNING, clazz, msg, args);
    }

    public void info(Class clazz, String msg) {
        this.log(this.category, INFO, clazz, msg, new Object[0]);
    }

    public void info(Class clazz, String msg, Object arg) {
        this.log(this.category, INFO, clazz, msg, new Object[]{arg});
    }

    public void info(Class clazz, String msg, Object arg1, Object arg2) {
        this.log(this.category, INFO, clazz, msg, new Object[]{arg1, arg2});
    }

    public void info(Class clazz, String msg, Object[] args) {
        this.log(this.category, INFO, clazz, msg, args);
    }

    public void close() {
        if (this.logObject != null) {
            this.logObject.close();
        }
    }
}

