/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdt.trace;

import com.sap.tc.logging.Category;
import com.sap.tc.logging.Location;
import com.sap.tc.logging.PropertiesConfigurator;
import com.sap.tc.logging.TraceFormatter;
import java.util.Properties;

public class AbstractLogging {
    public static final String RCSINFO = "$Id: //sdt/com.sap.sdt/0.1/src/_trace/java/com/sap/sdt/trace/AbstractLogging.java#2 $";
    private boolean evalStackTrace = false;
    private static boolean initialized = false;
    private static boolean configured = false;
    private static PropertiesConfigurator propertiesConfigurator;
    protected static TraceFormatter traceFormatter;
    protected static int FATAL;
    protected static int ERROR;
    protected static int WARNING;
    protected static int INFO;
    protected static int DEBUG;
    protected static int PATH;

    public static final void configure(Properties prop) {
        if (!initialized) {
            AbstractLogging.initialize(AbstractLogging.class.getClassLoader());
        }
        propertiesConfigurator.setProperties(prop);
        propertiesConfigurator.configure();
        configured = true;
    }

    public static final boolean isConfigured() {
        return configured;
    }

    public static final void initialize(ClassLoader cl) {
        propertiesConfigurator = new PropertiesConfigurator(new Properties());
        traceFormatter = new TraceFormatter("%d [%s]: %-100l [%t]: %m");
        initialized = true;
    }

    protected final boolean getEvalStackTrace() {
        return this.evalStackTrace;
    }

    protected final void setEvalStackTrace(boolean evalStackTrace) {
        this.evalStackTrace = evalStackTrace;
    }

    protected final void log(Category category, int severity, Class clazz, String msg, Object[] args) {
        Exception dummy;
        StackTraceElement[] stackTrace;
        msg = this.format(msg, args);
        boolean done = false;
        if (this.evalStackTrace && (stackTrace = (dummy = new Exception()).getStackTrace()) != null && stackTrace.length > 2) {
            String className = AbstractLogging.getLocation(stackTrace[2]);
            category.logT(severity, AbstractLogging.getLocation(className), msg, args);
            done = true;
        }
        if (!done) {
            category.logT(severity, AbstractLogging.getLocation(clazz), msg, args);
        }
    }

    protected final void log(Category category, int severity, String className, String msg, Object[] args) {
        msg = this.format(msg, args);
        category.logT(severity, AbstractLogging.getLocation(className), msg, args);
    }

    protected static final void trace(int severity, Class clazz, String msg, Object[] args) {
        AbstractLogging.getLocation(clazz).logT(severity, msg, args);
    }

    protected static final void _entering(Class clazz, String subLoc, Object[] args) {
        AbstractLogging.getLocation(clazz).entering(subLoc, args);
    }

    protected static final void _exiting(Class clazz) {
        AbstractLogging.getLocation(clazz).exiting();
    }

    private static Location getLocation(Class clazz) {
        return Location.getLocation(clazz);
    }

    private static Location getLocation(String className) {
        return Location.getLocation(className);
    }

    protected static final String getLocation(StackTraceElement elem) {
        StringBuffer b = new StringBuffer();
        b.append(elem.getClassName());
        b.append('.');
        b.append(elem.getMethodName());
        b.append('(');
        b.append(elem.getFileName());
        b.append(':');
        b.append(elem.getLineNumber());
        b.append(')');
        return b.toString();
    }

    protected String format(String msg, Object[] args) {
        return msg;
    }

    static {
        FATAL = 600;
        ERROR = 500;
        WARNING = 400;
        INFO = 300;
        DEBUG = 100;
        PATH = 200;
    }
}

