/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdt.server.ext.sapinst.controls;

import com.sap.sdt.engine.core.communication.Configuration;
import com.sap.sdt.engine.core.controls.SDTActionListenerIF;
import com.sap.sdt.engine.core.controls.SDTControlFactoryIF;
import com.sap.sdt.engine.ext.sapinst.controls.SAPinstLogBrowserConstants;
import com.sap.sdt.engine.ext.sapinst.controls.SAPinstLogBrowserIF;
import com.sap.sdt.server.core.controls.SDTActionListener;
import com.sap.sdt.server.core.controls.SDTComponent;
import com.sap.sdt.server.ext.sapinst.controls.SAPinstConstants;
import java.util.List;

public class SAPinstLogBrowser
extends SDTComponent
implements SAPinstLogBrowserConstants,
SAPinstConstants {
    public static final String RCSINFO = "$Id: //sdt/com.sap.sdt/0.1/src/_server/java/com/sap/sdt/server/ext/sapinst/controls/SAPinstLogBrowser.java#2 $";
    private static String[] actionNames = new String[3];
    static SAPinstLogBrowser instance;
    private SDTActionListener listener = null;
    private String severity = "INFO";
    private String currentFile = null;
    private List lines = null;
    private String text = null;

    public static SAPinstLogBrowser getInstance() {
        if (instance == null) {
            instance = new SAPinstLogBrowser();
        }
        return instance;
    }

    private SAPinstLogBrowser() {
    }

    public static int getAction(String name) {
        int action = -1;
        for (int i = 0; i < 3; ++i) {
            if (!name.equals(actionNames[i])) continue;
            action = i;
            break;
        }
        return action;
    }

    public int getType() {
        return 31;
    }

    public void updateControl() {
        this.severity = this.delegate().getSeverity();
    }

    public void setListener(SDTActionListener listener) {
        this.listener = listener;
        if (this.delegate != null) {
            this.delegate().setListener((SDTActionListenerIF)listener.getDelegate());
        }
    }

    public String getSeverity() {
        if (this.delegate != null) {
            this.updateControl();
        }
        return this.severity;
    }

    public void setInitialSeverity(String severity) {
        this.severity = severity;
    }

    public void setCurrentFile(String currentFile) {
        this.currentFile = currentFile;
        if (this.delegate != null) {
            this.delegate().setCurrentFile(currentFile);
        }
    }

    public boolean isSAPinstLog() {
        int index = this.currentFile.lastIndexOf(47);
        if (index != -1) {
            return this.currentFile.substring(index + 1).startsWith("sapinst");
        }
        return this.currentFile.startsWith("sapinst");
    }

    public void addLines(List list) {
        this.lines = list;
        if (this.delegate != null) {
            this.delegate().addLines(list);
        }
    }

    public void addText(String text) {
        this.text = text;
        if (this.delegate != null) {
            this.delegate().addText(text);
        }
    }

    public void clear() {
        this.lines = null;
        this.text = null;
        if (this.delegate != null) {
            this.delegate().clear();
        }
    }

    protected void createDelegate() {
        SDTControlFactoryIF factory = Configuration.getControlFactory();
        this.delegate = factory.createSAPinstLogBrowser();
        this.delegate().setInitialSeverity(this.severity);
        this.delegate().setListener((SDTActionListenerIF)this.listener.getDelegate());
        this.delegate().addLines(this.lines);
    }

    protected void deleteDelegate() {
        SDTControlFactoryIF factory = Configuration.getControlFactory();
        factory.delete(this.delegate);
    }

    private final SAPinstLogBrowserIF delegate() {
        return (SAPinstLogBrowserIF)this.delegate;
    }

    static {
        SAPinstLogBrowser.actionNames[0] = "Request";
        SAPinstLogBrowser.actionNames[1] = "Refresh";
        SAPinstLogBrowser.actionNames[2] = "Close";
    }
}

