/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdt.server.ext.sapinst.adapter;

import com.sap.sdt.engine.core.controls.SDTConstants;
import com.sap.sdt.engine.core.controls.table.SDTTableColumn;
import com.sap.sdt.engine.core.controls.table.SDTTableRow;
import com.sap.sdt.server.core.controls.SDTControl;
import com.sap.sdt.server.ext.sapinst.adapter.SAPinstAttrException;
import com.sap.sdt.server.ext.sapinst.adapter.SAPinstConstants;
import com.sap.sdt.server.ext.sapinst.adapter.SAPinstElemException;
import com.sap.sdt.server.ext.sapinst.adapter.SAPinstException;
import com.sap.sdt.server.ext.sapinst.adapter.SAPinstToolkit;
import com.sap.sdt.server.ext.sapinst.adapter.SAPinstValue;
import com.sap.sdt.util.diag.DiagException;
import com.sap.sdt.util.diag.JavaException;
import com.sap.sdt.util.xml.XMLElementIF;
import com.sap.sdt.util.xml.XMLException;
import java.util.Iterator;

abstract class SAPinstProtocolV3_0
implements SAPinstConstants {
    public static final String RCSINFO = "$Id: //sdt/com.sap.sdt/0.1/src/_server/java/com/sap/sdt/server/ext/sapinst/adapter/SAPinstProtocolV3_0.java#2 $";
    public static final int SAPINST_VALUE = 36;

    SAPinstProtocolV3_0() {
    }

    protected void process(Entry entry) throws SAPinstException {
        this.handleAttrs(entry);
        this.handleSubElems(entry);
    }

    protected void handleAttrs(Entry entry) throws SAPinstException {
        String attrName = null;
        try {
            Iterator iter = entry.getAttrNames();
            block34: while (iter.hasNext()) {
                attrName = (String)iter.next();
                int attrType = SAPinstToolkit.getAttrType(attrName);
                switch (attrType) {
                    case 0: {
                        this.handleVersion(entry);
                        continue block34;
                    }
                    case 1: {
                        this.handleSID(entry);
                        continue block34;
                    }
                    case 9: {
                        this.handleVisible(entry);
                        continue block34;
                    }
                    case 13: {
                        this.handleLayout(entry);
                        continue block34;
                    }
                    case 16: {
                        this.handleConfirm(entry);
                        continue block34;
                    }
                    case 23: {
                        this.handleEditable(entry);
                        continue block34;
                    }
                    case 17: {
                        this.handleType(entry);
                        continue block34;
                    }
                    case 18: {
                        this.handleRegexp(entry);
                        continue block34;
                    }
                    case 19: {
                        this.handleMinLen(entry);
                        continue block34;
                    }
                    case 20: {
                        this.handleMaxLen(entry);
                        continue block34;
                    }
                    case 21: {
                        this.handleMinVal(entry);
                        continue block34;
                    }
                    case 22: {
                        this.handleMaxVal(entry);
                        continue block34;
                    }
                    case 15: {
                        this.handleHighlight(entry);
                        continue block34;
                    }
                    case 10: {
                        this.handleEnabled(entry);
                        continue block34;
                    }
                    case 11: {
                        this.handleDepends(entry);
                        continue block34;
                    }
                    case 12: {
                        this.handleDependsNot(entry);
                        continue block34;
                    }
                    case 26: {
                        this.handleFixedRows(entry);
                        continue block34;
                    }
                    case 27: {
                        this.handleName(entry);
                        continue block34;
                    }
                    case 28: {
                        this.handleRowID(entry);
                        continue block34;
                    }
                    case 7: {
                        this.handleID(entry);
                        continue block34;
                    }
                    case 25: {
                        this.handleWindowTitle(entry);
                        continue block34;
                    }
                    case 29: 
                    case 30: 
                    case 31: 
                    case 32: 
                    case 33: 
                    case 34: 
                    case 35: 
                    case 36: 
                    case 37: 
                    case 38: 
                    case 39: {
                        continue block34;
                    }
                    case 40: {
                        this.handleDefault(entry);
                        continue block34;
                    }
                    case 41: {
                        continue block34;
                    }
                    case 42: {
                        this.handleDirectory(entry);
                        continue block34;
                    }
                    case 43: {
                        this.handleUpper(entry);
                        continue block34;
                    }
                    case 44: {
                        this.handleNumeric(entry);
                        continue block34;
                    }
                    case 6: {
                        this.handleAllDone(entry);
                        continue block34;
                    }
                    case 49: {
                        this.handleWidth(entry);
                        continue block34;
                    }
                }
                throw this.newAttrExc(attrName, entry.elem);
            }
        }
        catch (ClassCastException ccE) {
            throw this.newAttrExc(attrName, entry.elem, new JavaException(ccE));
        }
        catch (XMLException xmlE) {
            throw this.newAttrExc(attrName, entry.elem, xmlE);
        }
    }

    protected void handleSubElems(Entry entry) throws SAPinstException {
        try {
            Iterator iter = entry.getSubElems();
            block45: while (iter.hasNext()) {
                entry.setElement((XMLElementIF)iter.next());
                switch (entry.getElemType()) {
                    case 3: {
                        this.handleTitle(entry);
                        continue block45;
                    }
                    case 4: {
                        this.handleDescription(entry);
                        continue block45;
                    }
                    case 5: {
                        this.handleIcon(entry);
                        continue block45;
                    }
                    case 11: {
                        this.handleCatalog(entry);
                        continue block45;
                    }
                    case 44: {
                        this.handleCDName(entry);
                        continue block45;
                    }
                    case 12: {
                        this.handleDisplayName(entry);
                        continue block45;
                    }
                    case 13: {
                        this.handleUserInfo(entry);
                        continue block45;
                    }
                    case 15: {
                        this.handleComponentSet(entry);
                        continue block45;
                    }
                    case 16: {
                        this.handleComponent(entry);
                        continue block45;
                    }
                    case 17: {
                        this.handleStatus(entry);
                        continue block45;
                    }
                    case 6: {
                        continue block45;
                    }
                    case 9: {
                        this.handleHtmlText(entry);
                        continue block45;
                    }
                    case 8: {
                        this.handleFrame(entry);
                        continue block45;
                    }
                    case 10: {
                        this.handleButton(entry);
                        continue block45;
                    }
                    case 45: {
                        this.handleAction(entry);
                        continue block45;
                    }
                    case 46: {
                        this.handleToolTip(entry);
                        continue block45;
                    }
                    case 18: {
                        this.handleCaption(entry);
                        continue block45;
                    }
                    case 31: {
                        this.handleHelpText(entry);
                        continue block45;
                    }
                    case 52: {
                        this.handleHelpItem(entry);
                        continue block45;
                    }
                    case 32: 
                    case 33: {
                        this.handleStringValue(entry);
                        continue block45;
                    }
                    case 34: {
                        if (!entry.getElement().hasSubElements()) {
                            this.handleBoolValue(entry, false);
                            continue block45;
                        }
                        this.process(entry);
                        continue block45;
                    }
                    case 35: {
                        this.handleBoolValue(entry, true);
                        continue block45;
                    }
                    case 36: {
                        this.handleBoolValue(entry, false);
                        continue block45;
                    }
                    case 37: {
                        this.handleSelectValue(entry);
                        continue block45;
                    }
                    case 28: {
                        this.handleTable(entry);
                        continue block45;
                    }
                    case 42: {
                        this.handleColumn(entry);
                        continue block45;
                    }
                    case 43: {
                        this.handleRow(entry);
                        continue block45;
                    }
                    case 29: {
                        this.handleGrid(entry);
                        continue block45;
                    }
                    case 30: {
                        this.handleGridColumn(entry);
                        continue block45;
                    }
                    case 19: {
                        this.handleLabel(entry);
                        continue block45;
                    }
                    case 20: {
                        this.handleField(entry);
                        continue block45;
                    }
                    case 22: {
                        this.handleCheckBox(entry);
                        continue block45;
                    }
                    case 25: {
                        this.handleComboBox(entry);
                        continue block45;
                    }
                    case 23: {
                        this.handleRadioBox(entry);
                        continue block45;
                    }
                    case 24: {
                        this.handleRadioButton(entry);
                        continue block45;
                    }
                    case 21: {
                        this.handlePasswordField(entry);
                        continue block45;
                    }
                    case 26: {
                        this.handleFileBrowser(entry);
                        continue block45;
                    }
                    case 27: {
                        this.handleProgressBar(entry);
                        continue block45;
                    }
                    case 47: {
                        this.handleDialogStatus(entry);
                        continue block45;
                    }
                    case 48: {
                        this.handleProgressPanel(entry);
                        continue block45;
                    }
                    case 54: {
                        this.handleCurrentProgress(entry);
                        continue block45;
                    }
                }
                throw this.newElemExc(entry.getElement());
            }
        }
        catch (ClassCastException ccE) {
            throw this.newElemExc(entry.getElement(), new JavaException(ccE));
        }
    }

    protected abstract void handleVersion(Entry var1) throws XMLException;

    protected abstract void handleSID(Entry var1) throws XMLException;

    protected abstract void handleDirectory(Entry var1) throws XMLException;

    protected abstract void handleUpper(Entry var1) throws XMLException;

    protected abstract void handleNumeric(Entry var1) throws XMLException;

    protected abstract void handleAllDone(Entry var1) throws XMLException;

    protected abstract void handleWidth(Entry var1) throws XMLException;

    protected abstract void handleVisible(Entry var1) throws XMLException;

    protected abstract void handleLayout(Entry var1) throws SAPinstException;

    protected abstract void handleConfirm(Entry var1) throws XMLException;

    protected abstract void handleEditable(Entry var1) throws XMLException;

    protected abstract void handleType(Entry var1) throws SAPinstException;

    protected abstract void handleRegexp(Entry var1) throws XMLException;

    protected abstract void handleMinLen(Entry var1) throws SAPinstException;

    protected abstract void handleMaxLen(Entry var1) throws SAPinstException;

    protected abstract void handleMinVal(Entry var1) throws SAPinstException;

    protected abstract void handleMaxVal(Entry var1) throws SAPinstException;

    protected abstract void handleHighlight(Entry var1);

    protected abstract void handleEnabled(Entry var1) throws XMLException;

    protected abstract void handleDepends(Entry var1) throws XMLException;

    protected abstract void handleDependsNot(Entry var1) throws XMLException;

    protected abstract void handleFixedRows(Entry var1) throws XMLException;

    protected abstract void handleDefault(Entry var1) throws XMLException;

    protected abstract void handleName(Entry var1) throws XMLException;

    protected abstract void handleRowID(Entry var1) throws XMLException;

    protected abstract void handleID(Entry var1) throws XMLException;

    protected abstract void handleWindowTitle(Entry var1) throws XMLException;

    protected abstract void handleTitle(Entry var1);

    protected abstract void handleDescription(Entry var1);

    protected abstract void handleCatalog(Entry var1) throws SAPinstException;

    protected abstract void handleCDName(Entry var1);

    protected abstract void handleIcon(Entry var1);

    protected abstract void handleProgressPanel(Entry var1) throws SAPinstException;

    protected abstract void handleCurrentProgress(Entry var1);

    protected abstract void handleStatus(Entry var1);

    protected abstract void handleDisplayName(Entry var1);

    protected abstract void handleUserInfo(Entry var1);

    protected abstract void handleComponentSet(Entry var1) throws SAPinstException;

    protected abstract void handleComponent(Entry var1) throws SAPinstException;

    protected abstract void handleHtmlText(Entry var1);

    protected abstract void handleFrame(Entry var1) throws SAPinstException;

    protected abstract void handleButton(Entry var1) throws SAPinstException;

    protected abstract void handleAction(Entry var1);

    protected abstract void handleToolTip(Entry var1);

    protected abstract void handleHelpText(Entry var1);

    protected abstract void handleHelpItem(Entry var1) throws SAPinstException;

    protected abstract void handleCaption(Entry var1);

    protected abstract void handleStringValue(Entry var1) throws SAPinstException;

    protected abstract void handleBoolValue(Entry var1, boolean var2);

    protected abstract void handleSelectValue(Entry var1);

    protected abstract void handleTable(Entry var1) throws SAPinstException;

    protected abstract void handleColumn(Entry var1) throws SAPinstException;

    protected abstract void handleRow(Entry var1) throws SAPinstException;

    protected abstract void handleGrid(Entry var1) throws SAPinstException;

    protected abstract void handleGridColumn(Entry var1) throws SAPinstException;

    protected abstract void handleLabel(Entry var1);

    protected abstract void handleField(Entry var1) throws SAPinstException;

    protected abstract void handleCheckBox(Entry var1) throws SAPinstException;

    protected abstract void handleComboBox(Entry var1) throws SAPinstException;

    protected abstract void handleRadioBox(Entry var1) throws SAPinstException;

    protected abstract void handleRadioButton(Entry var1) throws SAPinstException;

    protected abstract void handlePasswordField(Entry var1) throws SAPinstException;

    protected abstract void handleFileBrowser(Entry var1) throws SAPinstException;

    protected abstract void handleProgressBar(Entry var1) throws SAPinstException;

    protected abstract void handleDialogStatus(Entry var1);

    protected SAPinstAttrException newAttrExc(String name, XMLElementIF elem) {
        return this.newAttrExc(name, elem, null);
    }

    protected SAPinstAttrException newAttrExc(String name, XMLElementIF elem, DiagException dE) {
        SAPinstAttrException aE = new SAPinstAttrException(name, elem);
        if (dE != null) {
            aE.addChild(dE);
        }
        return aE;
    }

    protected SAPinstElemException newElemExc(XMLElementIF elem) {
        return this.newElemExc(elem, null);
    }

    protected SAPinstElemException newElemExc(XMLElementIF elem, DiagException dE) {
        SAPinstElemException eE = new SAPinstElemException(elem);
        if (dE != null) {
            eE.addChild(dE);
        }
        return eE;
    }

    protected static class Entry
    implements SDTConstants {
        private Object obj = null;
        private XMLElementIF elem = null;

        protected Entry() {
        }

        final void setObject(Object obj) {
            this.obj = obj;
        }

        final void setElement(XMLElementIF elem) {
            this.elem = elem;
        }

        final int getObjType() {
            int type = -1;
            if (this.obj instanceof SDTControl) {
                type = this.getControl().getType();
            } else if (this.obj instanceof SDTTableColumn) {
                type = ((SDTTableColumn)this.obj).getType();
            } else if (this.obj instanceof SDTTableRow) {
                type = ((SDTTableRow)this.obj).getType();
            } else if (this.obj instanceof SAPinstValue) {
                type = 36;
            }
            return type;
        }

        final int getElemType() {
            return SAPinstToolkit.getElemType(this.elem.getName());
        }

        final Iterator getSubElems() {
            return this.elem.getSubElements();
        }

        final Iterator getAttrNames() {
            return this.elem.getAttrNames();
        }

        final Object getObject() {
            return this.obj;
        }

        final SDTControl getControl() {
            return (SDTControl)this.obj;
        }

        final XMLElementIF getElement() {
            return this.elem;
        }
    }
}

