/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdt.server.ext.sapinst.adapter;

import com.sap.sdt.server.ext.sapinst.adapter.SAPinstAdapter;
import com.sap.sdt.server.ext.sapinst.adapter.SAPinstConstants;
import com.sap.sdt.server.ext.sapinst.adapter.SAPinstLogListener;
import com.sap.sdt.server.ext.sapinst.adapter.SAPinstParserIF;
import com.sap.sdt.server.ext.sapinst.controls.SAPinstLogBrowser;
import com.sap.sdt.util.xml.XMLElementIF;
import com.sap.sdt.util.xml.XMLException;
import java.util.ArrayList;
import java.util.Iterator;

class SAPinstLogParser
implements SAPinstParserIF,
SAPinstConstants {
    public static final String RCSINFO = "$Id: //sdt/com.sap.sdt/0.1/src/_server/java/com/sap/sdt/server/ext/sapinst/adapter/SAPinstLogParser.java#2 $";
    protected SAPinstAdapter adapter = null;
    protected SAPinstLogBrowser logBrowser = null;

    SAPinstLogParser(SAPinstAdapter adapter) {
        this.adapter = adapter;
    }

    public void parse(XMLElementIF elem) {
        if (this.logBrowser == null) {
            this.logBrowser = SAPinstLogBrowser.getInstance();
            this.logBrowser.setListener(this.adapter.getLogListener());
            ((SAPinstLogListener)this.adapter.getLogListener()).setLogBrowser(this.logBrowser);
        }
        this.setCurrentFile(elem);
        if (!this.isAppend(elem)) {
            this.logBrowser.clear();
        }
        if (this.logBrowser.isSAPinstLog()) {
            ArrayList<String> lines = new ArrayList<String>();
            Iterator it = elem.getSubElements();
            while (it.hasNext()) {
                XMLElementIF subElem = (XMLElementIF)it.next();
                lines.add(subElem.getContent());
            }
            this.logBrowser.addLines(lines);
        } else {
            StringBuffer buffer = new StringBuffer();
            Iterator it = elem.getSubElements();
            while (it.hasNext()) {
                XMLElementIF subElem = (XMLElementIF)it.next();
                buffer.append(subElem.getContent());
            }
            this.logBrowser.addText(buffer.toString());
        }
        this.adapter.getDialog().showLogBrowser(this.logBrowser);
    }

    private void setCurrentFile(XMLElementIF elem) {
        try {
            this.logBrowser.setCurrentFile(elem.getAttrString("filename"));
        }
        catch (XMLException xmlE) {
            xmlE.printStackTrace();
            System.exit(1);
        }
    }

    private boolean isAppend(XMLElementIF elem) {
        boolean isAppend = true;
        try {
            isAppend = elem.getAttrBoolean("append");
        }
        catch (XMLException xMLException) {
            // empty catch block
        }
        return isAppend;
    }
}

