/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdt.server.ext.sapinst.adapter;

import com.sap.sdt.engine.core.controls.SDTConstants;
import com.sap.sdt.engine.core.controls.file.FileNode;
import com.sap.sdt.engine.core.controls.table.SDTTableColumn;
import com.sap.sdt.server.core.controls.SDTControl;
import com.sap.sdt.server.core.controls.SDTFileBrowser;
import com.sap.sdt.server.core.controls.SDTFileChooser;
import com.sap.sdt.server.core.controls.SDTTable;
import com.sap.sdt.server.ext.sapinst.adapter.SAPinstAdapter;
import com.sap.sdt.server.ext.sapinst.adapter.SAPinstBrowseListener;
import com.sap.sdt.server.ext.sapinst.adapter.SAPinstConstants;
import com.sap.sdt.server.ext.sapinst.adapter.SAPinstException;
import com.sap.sdt.server.ext.sapinst.adapter.SAPinstFileListener;
import com.sap.sdt.server.ext.sapinst.adapter.SAPinstParserIF;
import com.sap.sdt.server.ext.sapinst.adapter.SAPinstToolkit;
import com.sap.sdt.util.xml.XMLElementIF;
import com.sap.sdt.util.xml.XMLException;
import java.util.Iterator;
import java.util.Vector;

class SAPinstFileParser
implements SAPinstParserIF,
SAPinstConstants,
SDTConstants {
    public static final String RCSINFO = "$Id: //sdt/com.sap.sdt/0.1/src/_server/java/com/sap/sdt/server/ext/sapinst/adapter/SAPinstFileParser.java#2 $";
    protected SAPinstAdapter adapter = null;
    protected SDTFileChooser fileChooser = null;

    public SAPinstFileParser(SAPinstAdapter adapter) {
        this.adapter = adapter;
    }

    public void parse(XMLElementIF elem) throws SAPinstException {
        Vector<FileNode> children = new Vector<FileNode>();
        String baseDir = null;
        try {
            baseDir = elem.getAttrString("basedir");
        }
        catch (XMLException xmlE) {
            // empty catch block
        }
        Iterator it = elem.getSubElements();
        while (it.hasNext()) {
            XMLElementIF subElem = (XMLElementIF)it.next();
            String name = subElem.getContent();
            FileNode node = null;
            switch (SAPinstToolkit.getElemType(subElem.getName())) {
                case 50: {
                    node = new FileNode(name, false);
                    break;
                }
                case 51: {
                    node = new FileNode(name, true);
                    break;
                }
                case 53: {
                    System.out.println("sapinstfile error received");
                    break;
                }
            }
            children.add(node);
        }
        if (this.fileChooser != null) {
            this.fileChooser.setFileNodes(baseDir, children.toArray(new FileNode[children.size()]));
        }
    }

    void showFileChooser(SDTControl source) {
        this.fileChooser = new SDTFileChooser();
        this.fileChooser.addInternalListener(new SAPinstFileListener(this.adapter));
        this.fileChooser.addActionListener(new SAPinstBrowseListener(this.adapter, source, this.fileChooser));
        switch (source.getType()) {
            case 16: {
                SDTFileBrowser fileBrowser = (SDTFileBrowser)source;
                this.fileChooser.setDirectoriesOnly(fileBrowser.isDirectoriesOnly());
                this.fileChooser.setCurrentDirectory(fileBrowser.getText());
                break;
            }
            case 15: {
                SDTTable table = (SDTTable)source;
                SDTTableColumn column = table.getEditingColumn();
                if (column == null) {
                    return;
                }
                boolean dirsOnly = false;
                if (column.getType() == 4) {
                    dirsOnly = true;
                }
                this.fileChooser.setDirectoriesOnly(dirsOnly);
                this.fileChooser.setCurrentDirectory((String)table.getEditingCellValue());
            }
        }
        this.adapter.getDialog().showFileChooser(this.fileChooser);
    }
}

