/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdt.server.ext.sapinst.adapter;

import com.sap.sdt.engine.core.event.SDTInternalEvent;
import com.sap.sdt.server.core.controls.SDTInternalListener;
import com.sap.sdt.server.core.services.AdapterException;
import com.sap.sdt.server.ext.sapinst.adapter.SAPinstAdapter;
import com.sap.sdt.server.ext.sapinst.adapter.SAPinstConstants;
import com.sap.sdt.server.ext.sapinst.adapter.SAPinstListenerIF;
import com.sap.sdt.util.xml.XMLAdmin;
import com.sap.sdt.util.xml.XMLElementIF;

class SAPinstFileListener
extends SDTInternalListener
implements SAPinstListenerIF,
SAPinstConstants {
    public static final String RCSINFO = "$Id: //sdt/com.sap.sdt/0.1/src/_server/java/com/sap/sdt/server/ext/sapinst/adapter/SAPinstFileListener.java#2 $";
    protected static final int ACTION_TYPE_REQUEST_UNKNOWN = -1;
    protected static final int ACTION_TYPE_REQUEST_ROOTS = 0;
    protected static final int ACTION_TYPE_REQUEST_FILES = 1;
    protected static final int ACTION_TYPE_REQUEST_DIRECTORIES = 2;
    protected static final int ACTION_TYPE_REQUEST_LAST = 3;
    protected static String[] actions = new String[11];
    protected SAPinstAdapter adapter = null;

    SAPinstFileListener(SAPinstAdapter adapter) {
        this.adapter = adapter;
    }

    public void eventPerformed(SDTInternalEvent event) {
        switch (SAPinstFileListener.getType(event.getActionCommand())) {
            case 0: {
                this.requestRoots();
                break;
            }
            case 1: {
                this.requestFiles((String)event.getParameter());
                break;
            }
            case 2: {
                this.requestDirectories((String)event.getParameter());
                break;
            }
        }
    }

    public void write(XMLElementIF response) {
        try {
            this.adapter.send(response.toString());
        }
        catch (AdapterException e) {
            e.printStackTrace();
        }
    }

    private static int getType(String action) {
        int type = -1;
        for (int i = 0; i < 3; ++i) {
            if (!action.equals(actions[i])) continue;
            type = i;
            break;
        }
        return type;
    }

    private void requestRoots() {
        this.write(this.createRequest("", true));
    }

    private void requestDirectories(String dir) {
        this.request(dir, true);
    }

    private void requestFiles(String dir) {
        this.request(dir, false);
    }

    private void request(String dir, boolean dirsOnly) {
        this.write(this.createRequest(dir, dirsOnly));
    }

    private XMLElementIF createRequest(String path, boolean dirsOnly) {
        XMLElementIF rootElem = XMLAdmin.createXMLElement();
        rootElem.setName("sapinstfile");
        XMLElementIF request = XMLAdmin.createXMLElement();
        request.setName("dirrequest");
        request.setContent(path);
        request.setAttr("dirsonly", dirsOnly ? "yes" : "no");
        rootElem.add(request);
        return rootElem;
    }

    static {
        SAPinstFileListener.actions[0] = "ACTION_REQUEST_ROOTS";
        SAPinstFileListener.actions[1] = "ACTION_REQUEST_FILES";
        SAPinstFileListener.actions[2] = "ACTION_REQUEST_DIRECTORIES";
    }
}

