/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdt.server.ext.sapinst.adapter;

import com.sap.sdt.engine.core.controls.SDTConstants;
import com.sap.sdt.engine.core.controls.SDTInternalListenerIF;
import com.sap.sdt.engine.core.controls.table.SDTTableColumn;
import com.sap.sdt.engine.core.controls.table.SDTTableRow;
import com.sap.sdt.engine.core.help.SDTHelpCapableIF;
import com.sap.sdt.server.core.controls.SDTButton;
import com.sap.sdt.server.core.controls.SDTCaptionComponent;
import com.sap.sdt.server.core.controls.SDTCheckBox;
import com.sap.sdt.server.core.controls.SDTComboBox;
import com.sap.sdt.server.core.controls.SDTContainer;
import com.sap.sdt.server.core.controls.SDTControl;
import com.sap.sdt.server.core.controls.SDTFileBrowser;
import com.sap.sdt.server.core.controls.SDTMessageBox;
import com.sap.sdt.server.core.controls.SDTPanel;
import com.sap.sdt.server.core.controls.SDTPasswordField;
import com.sap.sdt.server.core.controls.SDTProgressBar;
import com.sap.sdt.server.core.controls.SDTProgressPanel;
import com.sap.sdt.server.core.controls.SDTRadioBox;
import com.sap.sdt.server.core.controls.SDTRadioButton;
import com.sap.sdt.server.core.controls.SDTStyledText;
import com.sap.sdt.server.core.controls.SDTTable;
import com.sap.sdt.server.core.controls.SDTTextField;
import com.sap.sdt.server.core.services.tool.views.SDTNetWeaverView;
import com.sap.sdt.server.ext.sapinst.adapter.SAPinstAdapter;
import com.sap.sdt.server.ext.sapinst.adapter.SAPinstConstants;
import com.sap.sdt.server.ext.sapinst.adapter.SAPinstException;
import com.sap.sdt.server.ext.sapinst.adapter.SAPinstMnemonicsDispatcher;
import com.sap.sdt.server.ext.sapinst.adapter.SAPinstParserIF;
import com.sap.sdt.server.ext.sapinst.adapter.SAPinstProtocolV3_0;
import com.sap.sdt.server.ext.sapinst.adapter.SAPinstToolkit;
import com.sap.sdt.server.ext.sapinst.adapter.SAPinstValue;
import com.sap.sdt.server.ext.sapinst.controls.SAPinstCatalog;
import com.sap.sdt.server.ext.sapinst.controls.SAPinstNode;
import com.sap.sdt.util.diag.JavaException;
import com.sap.sdt.util.misc.Base64Codec;
import com.sap.sdt.util.xml.XMLAdmin;
import com.sap.sdt.util.xml.XMLAttributeNotFoundException;
import com.sap.sdt.util.xml.XMLElementIF;
import com.sap.sdt.util.xml.XMLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public class SAPinstDialogParser
extends SAPinstProtocolV3_0
implements SAPinstParserIF,
SAPinstConstants,
SDTConstants {
    public static final String RCSINFO = "$Id: //sdt/com.sap.sdt/0.1/src/_server/java/com/sap/sdt/server/ext/sapinst/adapter/SAPinstDialogParser.java#5 $";
    protected SAPinstAdapter adapter = null;
    private static final String SID_INIT = "diInit";
    private static final String SID_SUMMARIZE = "diSummarize";
    private static final String SID_SUCCESS = "diSuccess";
    private boolean captionMisuseErrorHandled = false;
    private boolean regexpInvalidErrorHandled = false;
    private SDTProgressPanel progressPanel = null;
    private List progressList = null;
    private int currentProgressIndex = -1;
    private boolean isCatalog = false;

    public SAPinstDialogParser(SAPinstAdapter adapter) {
        this.adapter = adapter;
        this.progressList = new ArrayList();
    }

    public void parse(XMLElementIF rootElem) throws SAPinstException {
        boolean isProgress;
        boolean isInit = this.isInit(rootElem);
        if (this.isDiInit(rootElem) && !isInit) {
            return;
        }
        this.initializeMnemonics(rootElem);
        if (isInit) {
            this.rewriteInit(rootElem);
        }
        if (this.isDiSummarize(rootElem)) {
            this.rewriteSummary(rootElem);
        }
        if (this.isDiSuccess(rootElem)) {
            this.rewriteSuccess(rootElem);
        }
        if (isProgress = this.isProgress(rootElem)) {
            this.rewriteProgress(rootElem);
        }
        this.cleanUp(rootElem);
        SAPinstProtocolV3_0.Entry entry = new SAPinstProtocolV3_0.Entry();
        this.adapter.clear();
        SDTNetWeaverView dialog = this.adapter.getDialog();
        dialog.removeButtons();
        if (!isProgress || this.progressPanel == null) {
            dialog.clear();
            this.progressPanel = null;
        }
        entry.setElement(rootElem);
        entry.setObject(dialog);
        this.process(entry);
        this.adapter.checkDependencies();
        this.adapter.storeDefaultValues();
        this.adapter.updateDependencies();
        dialog.refresh();
        dialog.setWaitCursor(false);
    }

    protected void handleProgressPanel(SAPinstProtocolV3_0.Entry entry) throws SAPinstException {
        boolean isInitial = false;
        SDTNetWeaverView dialog = (SDTNetWeaverView)entry.getControl();
        Object subElem = null;
        this.progressList.clear();
        boolean bl = isInitial = this.progressPanel == null;
        if (isInitial) {
            this.progressPanel = new SDTProgressPanel(this.adapter.getResourcePool());
            this.progressPanel.setTextDelay(120000L);
            this.progressPanel.setImageDelay(120000L);
        }
        entry.setObject(this.progressPanel);
        this.process(entry);
        if (isInitial) {
            String[] list = new String[this.progressList.size()];
            for (int i = 0; i < this.progressList.size(); ++i) {
                list[i] = (String)this.progressList.get(i);
            }
            this.progressPanel.setProgressList(list);
            dialog.add(this.progressPanel);
            dialog.setMainPanel(this.progressPanel);
        }
        this.progressPanel.setProgressListIndex(this.currentProgressIndex);
        entry.setObject(dialog);
    }

    protected void handleCurrentProgress(SAPinstProtocolV3_0.Entry entry) {
        SDTControl parent = entry.getControl();
        try {
            int current = entry.getElement().getAttrInteger("current");
            int total = entry.getElement().getAttrInteger("total");
            this.progressPanel.setMinimum(0);
            this.progressPanel.setMaximum(total);
            this.progressPanel.setCurrent(current);
        }
        catch (XMLException xmlE) {
            return;
        }
        boolean imageAvailable = entry.getElement().isAttributeExisting("image-id");
        boolean textAvailable = entry.getElement().isAttributeExisting("text-id");
        String imageID = "";
        String textID = "";
        if (imageAvailable) {
            imageID = entry.getElement().getAttrStringNull("image-id");
            if (!textAvailable) {
                this.progressPanel.setImage(imageID);
            }
        }
        if (textAvailable) {
            textID = entry.getElement().getAttrStringNull("text-id");
            if (!imageAvailable) {
                this.progressPanel.setText(textID);
            } else {
                String oldImageID = this.progressPanel.getImage();
                String oldTextID = this.progressPanel.getText();
                if (!imageID.equals(oldImageID) || !textID.equals(oldTextID)) {
                    this.progressPanel.setImage(imageID);
                    this.progressPanel.setText(textID);
                }
            }
        }
    }

    protected void handleVersion(SAPinstProtocolV3_0.Entry entry) throws XMLException {
        SDTNetWeaverView dialog = (SDTNetWeaverView)entry.getControl();
        dialog.setVersion(entry.getElement().getAttrString("version"));
    }

    protected void handleSID(SAPinstProtocolV3_0.Entry entry) throws XMLException {
        this.adapter.add(entry.getElement().getAttrString("sid"), entry.getControl());
    }

    protected void handleDirectory(SAPinstProtocolV3_0.Entry entry) throws XMLException {
        SDTFileBrowser fB = (SDTFileBrowser)entry.getControl();
        boolean isDirectory = entry.getElement().getAttrBoolean("directory");
        fB.setDirectoriesOnly(isDirectory);
    }

    protected void handleUpper(SAPinstProtocolV3_0.Entry entry) throws XMLException {
        SDTTableColumn column = (SDTTableColumn)entry.getObject();
        boolean isUpper = entry.getElement().getAttrBoolean("upper");
        column.setConstraint(2, isUpper);
    }

    protected void handleNumeric(SAPinstProtocolV3_0.Entry entry) throws XMLException {
        SDTTableColumn column = (SDTTableColumn)entry.getObject();
        boolean isNumeric = entry.getElement().getAttrBoolean("numeric");
        column.setConstraint(1, isNumeric);
    }

    protected void handleAllDone(SAPinstProtocolV3_0.Entry entry) throws XMLException {
        SDTProgressPanel panel = (SDTProgressPanel)entry.getControl();
        if (entry.getElement().getAttrBoolean("alldone")) {
            panel.done();
        }
    }

    protected void handleWidth(SAPinstProtocolV3_0.Entry entry) throws XMLException {
        SDTComboBox comboBox = (SDTComboBox)entry.getControl();
        int width = entry.getElement().getAttrInteger("width");
        comboBox.setWidth(width);
    }

    protected void handleVisible(SAPinstProtocolV3_0.Entry entry) throws XMLException {
        int border = 0;
        SDTPanel frame = (SDTPanel)entry.getControl();
        if (entry.getElement().getAttrBoolean("visible")) {
            border = 1;
        }
        frame.setBorder(border);
    }

    protected void handleLayout(SAPinstProtocolV3_0.Entry entry) throws SAPinstException {
        SDTPanel frame = (SDTPanel)entry.getControl();
        String str = null;
        try {
            str = entry.getElement().getAttrString("alignment");
        }
        catch (XMLException xmlE) {
            throw this.newAttrExc("alignment", entry.getElement(), xmlE);
        }
        int type = SAPinstToolkit.getValueType(str);
        switch (type) {
            case 2: {
                frame.setLayout(0);
                break;
            }
            case 1: {
                frame.setLayout(1);
                break;
            }
            default: {
                throw this.newAttrExc("alignment", entry.getElement());
            }
        }
    }

    protected void handleConfirm(SAPinstProtocolV3_0.Entry entry) throws XMLException {
        SDTPasswordField pwd = (SDTPasswordField)entry.getControl();
        pwd.setConfirm(entry.getElement().getAttrBoolean("confirm"));
    }

    protected void handleEditable(SAPinstProtocolV3_0.Entry entry) throws XMLException {
        SDTComboBox comboBox = (SDTComboBox)entry.getControl();
        comboBox.setEditable(entry.getElement().getAttrBoolean("edit"));
    }

    protected void handleType(SAPinstProtocolV3_0.Entry entry) throws SAPinstException {
        XMLElementIF elem = entry.getElement();
        switch (entry.getObjType()) {
            case 18: {
                SDTTableColumn column = (SDTTableColumn)entry.getObject();
                column.setColumnType(this.translateColumnType(elem));
                break;
            }
            case 36: {
                SAPinstValue value = (SAPinstValue)entry.getObject();
                try {
                    value.setType(elem.getAttrString("type"));
                    break;
                }
                catch (XMLException xmlE) {
                    throw this.newAttrExc("type", elem, xmlE);
                }
            }
        }
    }

    protected void handleRegexp(SAPinstProtocolV3_0.Entry entry) throws XMLException {
        String regexp;
        SAPinstValue value;
        block3: {
            value = (SAPinstValue)entry.getObject();
            regexp = entry.getElement().getAttrString("regexp");
            if (regexp != null) {
                try {
                    Pattern.compile(regexp);
                }
                catch (PatternSyntaxException psynex) {
                    regexp = null;
                    if (this.regexpInvalidErrorHandled) break block3;
                    this.regexpInvalidErrorHandled = true;
                    SDTMessageBox popup = new SDTMessageBox();
                    popup.setMessageText("<html><font color='#A3240F'>The dialog is unable to validate input completely.</font><p><u>Reason:</u><br>Syntax error in regular expression pattern:<br><pre>" + psynex.getMessage() + "</pre><br>" + "<u>Action:</u><br>Correct the syntax of the regular expression or create a OSS message in component BC-INS.<html>");
                    SDTButton button = new SDTButton();
                    button.addActionListener(this.adapter.getAlertListener());
                    button.setCaption("OK", 'O');
                    button.setDefault(true);
                    popup.addButton(button);
                    popup.setTitle("Warning");
                    popup.setModal(true);
                    this.adapter.getDialog().showPopup(popup);
                }
            }
        }
        value.setRegexp(regexp);
    }

    protected void handleMinLen(SAPinstProtocolV3_0.Entry entry) throws SAPinstException {
        int minL;
        block7: {
            minL = 0;
            String str = null;
            try {
                str = entry.getElement().getAttrString("minlength");
                minL = Integer.parseInt(str);
            }
            catch (XMLException xmlE) {
                throw this.newAttrExc("minlength", entry.getElement(), xmlE);
            }
            catch (NumberFormatException nfE) {
                if (str.equals("")) break block7;
                JavaException jE = new JavaException(nfE);
                throw this.newAttrExc("minlength", entry.getElement(), jE);
            }
        }
        switch (entry.getObjType()) {
            case 18: {
                SDTTableColumn c = (SDTTableColumn)entry.getObject();
                c.setConstraintValue(0, minL);
                break;
            }
            case 36: {
                ((SAPinstValue)entry.getObject()).setMinLength(minL);
                break;
            }
            default: {
                throw this.newAttrExc("minlength", entry.getElement());
            }
        }
    }

    protected void handleMaxLen(SAPinstProtocolV3_0.Entry entry) throws SAPinstException {
        int maxL;
        block7: {
            maxL = Integer.MAX_VALUE;
            String str = null;
            try {
                str = entry.getElement().getAttrString("maxlength");
                maxL = Integer.parseInt(str);
            }
            catch (XMLException xmlE) {
                throw this.newAttrExc("maxlength", entry.getElement(), xmlE);
            }
            catch (NumberFormatException nfE) {
                if (str.equals("")) break block7;
                JavaException jE = new JavaException(nfE);
                throw this.newAttrExc("maxlength", entry.getElement(), jE);
            }
        }
        switch (entry.getObjType()) {
            case 18: {
                SDTTableColumn c = (SDTTableColumn)entry.getObject();
                c.setConstraintValue(1, maxL);
                break;
            }
            case 36: {
                ((SAPinstValue)entry.getObject()).setMaxLength(maxL);
                break;
            }
            default: {
                throw this.newAttrExc("minlength", entry.getElement());
            }
        }
    }

    protected void handleMinVal(SAPinstProtocolV3_0.Entry entry) throws SAPinstException {
        int minVal = Integer.MIN_VALUE;
        try {
            minVal = entry.getElement().getAttrInteger("min");
        }
        catch (XMLException xmlE) {
            throw this.newAttrExc("min", entry.getElement(), xmlE);
        }
        switch (entry.getObjType()) {
            case 18: {
                SDTTableColumn c = (SDTTableColumn)entry.getObject();
                c.setConstraintValue(2, minVal);
                break;
            }
            case 36: {
                ((SAPinstValue)entry.getObject()).setMinValue(minVal);
                break;
            }
            default: {
                throw this.newAttrExc("min", entry.getElement());
            }
        }
    }

    protected void handleMaxVal(SAPinstProtocolV3_0.Entry entry) throws SAPinstException {
        int maxVal = Integer.MAX_VALUE;
        try {
            maxVal = entry.getElement().getAttrInteger("max");
        }
        catch (XMLException xmlE) {
            throw this.newAttrExc("max", entry.getElement(), xmlE);
        }
        switch (entry.getObjType()) {
            case 18: {
                SDTTableColumn c = (SDTTableColumn)entry.getObject();
                c.setConstraintValue(3, maxVal);
                break;
            }
            case 36: {
                ((SAPinstValue)entry.getObject()).setMaxValue(maxVal);
                break;
            }
            default: {
                throw this.newAttrExc("max", entry.getElement());
            }
        }
    }

    protected void handleHighlight(SAPinstProtocolV3_0.Entry entry) {
    }

    protected void handleEnabled(SAPinstProtocolV3_0.Entry entry) throws XMLException {
        boolean isEnabled = entry.getElement().getAttrBoolean("enabled");
        switch (entry.getObjType()) {
            case 18: {
                ((SDTTableColumn)entry.getObject()).setEnabled(isEnabled);
                break;
            }
            case 19: {
                break;
            }
            case 36: {
                break;
            }
            case 3: {
                break;
            }
            default: {
                entry.getControl().setEnabled(isEnabled);
            }
        }
    }

    protected void handleDepends(SAPinstProtocolV3_0.Entry entry) throws XMLException {
        String sid = entry.getElement().getAttrString("depends");
        this.adapter.addDependency(sid, entry.getControl(), true);
    }

    protected void handleDependsNot(SAPinstProtocolV3_0.Entry entry) throws XMLException {
        String sid = entry.getElement().getAttrString("dependsNot");
        this.adapter.addDependency(sid, entry.getControl(), false);
    }

    protected void handleFixedRows(SAPinstProtocolV3_0.Entry entry) throws XMLException {
        SDTTable table = (SDTTable)entry.getControl();
        table.enableAddRemove(entry.getElement().getAttrBoolean("fixedrows"));
    }

    protected void handleDefault(SAPinstProtocolV3_0.Entry entry) throws XMLException {
        SDTButton button = (SDTButton)entry.getControl();
        button.setDefault(entry.getElement().getAttrBoolean("default"));
    }

    protected void handleName(SAPinstProtocolV3_0.Entry entry) throws XMLException {
        switch (entry.getObjType()) {
            case 34: {
                break;
            }
            case 18: {
                SDTTableColumn column = (SDTTableColumn)entry.getObject();
                column.setColumnID(entry.getElement().getAttrString("name"));
                break;
            }
        }
    }

    protected void handleRowID(SAPinstProtocolV3_0.Entry entry) throws XMLException {
        SDTTableRow row = (SDTTableRow)entry.getObject();
        row.setRowID(entry.getElement().getAttrString("rowId"));
    }

    protected void handleID(SAPinstProtocolV3_0.Entry entry) throws XMLException {
        SAPinstNode node = (SAPinstNode)entry.getControl();
        node.setID(entry.getElement().getAttrString("id"));
    }

    protected void handleWindowTitle(SAPinstProtocolV3_0.Entry entry) throws XMLException {
        SDTNetWeaverView dialog = (SDTNetWeaverView)entry.getControl();
        dialog.setGuiTitle(entry.getElement().getAttrString("windowtitle"));
    }

    protected void handleTitle(SAPinstProtocolV3_0.Entry entry) {
        SDTNetWeaverView dialog = (SDTNetWeaverView)entry.getControl();
        dialog.setTitle(entry.getElement().getContent());
        this.resetInternalErrorState();
    }

    protected void handleDescription(SAPinstProtocolV3_0.Entry entry) {
        SDTNetWeaverView dialog = (SDTNetWeaverView)entry.getControl();
        dialog.setDescription(entry.getElement().getContent());
    }

    protected void handleCatalog(SAPinstProtocolV3_0.Entry entry) throws SAPinstException {
        this.isCatalog = true;
        SDTNetWeaverView dialog = (SDTNetWeaverView)entry.getControl();
        SAPinstCatalog panel = new SAPinstCatalog();
        entry.setObject(panel.getRootNode());
        this.process(entry);
        dialog.add(panel);
        dialog.setMainPanel(panel);
        entry.setObject(dialog);
    }

    protected void handleCDName(SAPinstProtocolV3_0.Entry entry) {
        SAPinstNode rootNode = (SAPinstNode)entry.getControl();
        rootNode.setDisplayName(entry.getElement().getContent());
    }

    protected void handleIcon(SAPinstProtocolV3_0.Entry entry) {
        SDTNetWeaverView dialog = (SDTNetWeaverView)entry.getControl();
        String icon = entry.getElement().getContent();
        dialog.setIcon(Base64Codec.decode(icon.toCharArray()));
    }

    protected void handleComponent(SAPinstProtocolV3_0.Entry entry) throws SAPinstException {
        switch (entry.getObjType()) {
            case 34: {
                this.addInitComponent(entry);
                break;
            }
            case 33: {
                this.addProgressComponent(entry);
                break;
            }
        }
    }

    protected void handleStatus(SAPinstProtocolV3_0.Entry entry) {
        this.adapter.getDialog().setStatus(entry.getElement().getContent());
    }

    protected void handleDisplayName(SAPinstProtocolV3_0.Entry entry) {
        SAPinstNode node = (SAPinstNode)entry.getControl();
        node.setDisplayName(entry.getElement().getContent());
    }

    protected void handleUserInfo(SAPinstProtocolV3_0.Entry entry) {
        SAPinstNode node = (SAPinstNode)entry.getControl();
        node.setUserInfo(entry.getElement().getContent());
    }

    protected void handleComponentSet(SAPinstProtocolV3_0.Entry entry) throws SAPinstException {
        SAPinstNode parent = (SAPinstNode)entry.getControl();
        SAPinstNode node = new SAPinstNode();
        entry.setObject(node);
        this.process(entry);
        parent.addChild(node);
        entry.setObject(parent);
    }

    protected void handleHtmlText(SAPinstProtocolV3_0.Entry entry) {
        SDTContainer parent = (SDTContainer)entry.getControl();
        SDTStyledText sT = new SDTStyledText(true);
        sT.setText(entry.getElement().getContent());
        parent.add(sT);
        if (parent instanceof SDTNetWeaverView) {
            ((SDTNetWeaverView)parent).setMainPanel(sT);
        }
    }

    protected void handleFrame(SAPinstProtocolV3_0.Entry entry) throws SAPinstException {
        SDTContainer parent = (SDTContainer)entry.getControl();
        SDTPanel frame = new SDTPanel();
        entry.setObject(frame);
        this.process(entry);
        parent.add(frame);
        if (parent instanceof SDTNetWeaverView) {
            ((SDTNetWeaverView)parent).setMainPanel(frame);
        }
        entry.setObject(parent);
    }

    protected void handleButton(SAPinstProtocolV3_0.Entry entry) throws SAPinstException {
        SDTNetWeaverView dialog = (SDTNetWeaverView)entry.getControl();
        SDTButton button = new SDTButton();
        button.addActionListener(this.adapter.getDialogListener());
        entry.setObject(button);
        this.process(entry);
        dialog.addButton(button);
        if (this.isCatalog && button.getCaption().equals("Next")) {
            this.isCatalog = false;
            button.setEnabled(false);
        }
        entry.setObject(dialog);
    }

    protected void handleAction(SAPinstProtocolV3_0.Entry entry) {
        SDTButton button = (SDTButton)entry.getControl();
        button.setActionCommand(entry.getElement().getContent());
    }

    protected void handleToolTip(SAPinstProtocolV3_0.Entry entry) {
        SDTButton button = (SDTButton)entry.getControl();
        button.setToolTip(entry.getElement().getContent());
    }

    protected void handleHelpText(SAPinstProtocolV3_0.Entry control) {
        String help = control.getElement().getContent();
        ((SDTHelpCapableIF)control.getObject()).setHelp(help);
    }

    protected void handleHelpItem(SAPinstProtocolV3_0.Entry control) throws SAPinstException {
        try {
            String id = control.getElement().getAttrString("id");
            SDTHelpCapableIF hC = (SDTHelpCapableIF)control.getObject();
            hC.setResolver((SDTInternalListenerIF)this.adapter.getHelpResolver().getDelegate());
            hC.setHelpItemID(id);
        }
        catch (XMLException xmlE) {
            throw this.newAttrExc("id", control.getElement(), xmlE);
        }
    }

    protected void handleCaption(SAPinstProtocolV3_0.Entry entry) {
        String caption = entry.getElement().getContent();
        if (caption == null || caption.length() == 0) {
            if (entry.getObjType() != 3 && !this.captionMisuseErrorHandled) {
                this.captionMisuseErrorHandled = true;
                SDTMessageBox popup = new SDTMessageBox();
                popup.setMessageText("<html><font color='#A3240F'>The dialog violates against accessibility requirements that must be fulfilled with SAP NetWeaver.</font><p><u>Reason:</u><br>One or more input control captions are not set.<p><u>Action:</u><br>Check the dialog for empty caption tags or redesign the entire dialog in cases of improper use of layout facilities such as a grid with labels for captions.<br>Or create a OSS message in component BC-INS.<html>");
                SDTButton button = new SDTButton();
                button.addActionListener(this.adapter.getAlertListener());
                button.setCaption("OK", 'O');
                button.setDefault(true);
                popup.addButton(button);
                popup.setTitle("Warning");
                popup.setModal(true);
                this.adapter.getDialog().showPopup(popup);
            }
            return;
        }
        char mnemonic = SAPinstMnemonicsDispatcher.getInstance().getMnemonic(caption);
        switch (entry.getObjType()) {
            case 3: {
                ((SDTPanel)entry.getControl()).setBorderTitle(caption);
                break;
            }
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 16: 
            case 20: {
                ((SDTCaptionComponent)entry.getControl()).setCaption(caption, mnemonic);
                break;
            }
            case 9: {
                SAPinstToolkit.setCaption((SDTButton)entry.getControl(), caption);
                break;
            }
            case 18: {
                ((SDTTableColumn)entry.getObject()).setCaption(caption);
                break;
            }
        }
    }

    protected void handleStringValue(SAPinstProtocolV3_0.Entry entry) throws SAPinstException {
        Object parent = entry.getObject();
        SAPinstValue value = new SAPinstValue();
        entry.setObject(value);
        this.handleAttrs(entry);
        value.setText(entry.getElement().getContent());
        entry.setObject(parent);
        switch (entry.getObjType()) {
            case 7: {
                this.setFieldValue((SDTTextField)parent, value);
                break;
            }
            case 8: {
                this.setPasswordValue((SDTPasswordField)parent, value);
                break;
            }
            case 12: {
                this.setComboBoxValue((SDTComboBox)parent, value);
                break;
            }
            case 16: {
                this.setFileBrowserValue((SDTFileBrowser)parent, value);
                break;
            }
            case 18: {
                SDTTableColumn column = (SDTTableColumn)parent;
                if (column.getColumnType() == 2) {
                    column.addValue(entry.getElement().getContent());
                    break;
                }
                this.setColumnValue((SDTTableColumn)parent, value);
                break;
            }
            case 19: {
                this.setRowValue((SDTTableRow)parent, value);
                break;
            }
        }
    }

    protected void handleBoolValue(SAPinstProtocolV3_0.Entry entry, boolean value) {
        switch (entry.getObjType()) {
            case 11: {
                ((SDTCheckBox)entry.getControl()).setSelected(value);
                break;
            }
            case 10: {
                ((SDTRadioButton)entry.getControl()).setSelected(value);
                break;
            }
            case 19: {
                ((SDTTableRow)entry.getObject()).add(new Boolean(value));
                break;
            }
        }
    }

    protected void handleSelectValue(SAPinstProtocolV3_0.Entry entry) {
        SDTComboBox comboBox = (SDTComboBox)entry.getControl();
        String value = entry.getElement().getContent();
        if (value != null) {
            boolean found = false;
            Iterator it = comboBox.getItems().iterator();
            while (it.hasNext()) {
                if (!value.equals((String)it.next())) continue;
                found = true;
                break;
            }
            if (!found) {
                comboBox.addItem(value);
            }
            comboBox.setSelectedItem(value);
        }
    }

    protected void handleTable(SAPinstProtocolV3_0.Entry entry) throws SAPinstException {
        SDTContainer parent = (SDTContainer)entry.getControl();
        SDTTable table = new SDTTable();
        table.setResolver((SDTInternalListenerIF)this.adapter.getHelpResolver().getDelegate());
        parent.add(table);
        entry.setObject(table);
        this.process(entry);
        entry.setObject(parent);
        this.reviseTable(table);
    }

    protected void handleColumn(SAPinstProtocolV3_0.Entry entry) throws SAPinstException {
        SDTTable table = (SDTTable)entry.getControl();
        SDTTableColumn column = new SDTTableColumn();
        entry.setObject(column);
        this.handleAttrs(entry);
        if (column.getColumnType() == 4 || column.getColumnType() == 3) {
            table.addBrowseListener("ACTION_BROWSE", this.adapter.getDialogListener());
        }
        this.handleSubElems(entry);
        String help = column.getHelp();
        String helpItemID = column.getHelpItemID();
        if (!(help != null && help.length() != 0 || helpItemID != null && helpItemID.length() != 0)) {
            column.setHelp(table.getHelp());
            column.setHelpItemID(table.getHelpItemID());
        }
        entry.setObject(table);
        table.addColumn(column);
    }

    protected void handleRow(SAPinstProtocolV3_0.Entry entry) throws SAPinstException {
        SDTTable table = (SDTTable)entry.getControl();
        SDTTableRow row = new SDTTableRow();
        entry.setObject(row);
        this.process(entry);
        entry.setObject(table);
        table.addRow(row);
    }

    protected void handleGrid(SAPinstProtocolV3_0.Entry entry) throws SAPinstException {
        SDTContainer parent = (SDTContainer)entry.getControl();
        SDTPanel grid = new SDTPanel();
        grid.setLayout(3);
        entry.setObject(grid);
        this.process(entry);
        parent.add(grid);
        entry.setObject(parent);
    }

    protected void handleGridColumn(SAPinstProtocolV3_0.Entry entry) throws SAPinstException {
        SDTContainer parent = (SDTContainer)entry.getControl();
        SDTPanel column = new SDTPanel();
        column.setLayout(0);
        entry.setObject(column);
        this.process(entry);
        parent.add(column);
        entry.setObject(parent);
    }

    protected void handleLabel(SAPinstProtocolV3_0.Entry entry) {
        SDTPanel parent = (SDTPanel)entry.getControl();
        SDTStyledText label = new SDTStyledText(false);
        label.setResolver((SDTInternalListenerIF)this.adapter.getHelpResolver().getDelegate());
        String content = entry.getElement().getContent();
        boolean isBold = false;
        try {
            isBold = entry.getElement().getAttrBoolean("bold");
        }
        catch (XMLException xmlE) {
            // empty catch block
        }
        if (content != null) {
            label.setText(content, isBold);
        }
        parent.add(label);
    }

    protected void handleField(SAPinstProtocolV3_0.Entry entry) throws SAPinstException {
        SDTPanel parent = (SDTPanel)entry.getControl();
        SDTTextField field = new SDTTextField();
        parent.add(field);
        entry.setObject(field);
        this.process(entry);
        entry.setObject(parent);
    }

    protected void handleCheckBox(SAPinstProtocolV3_0.Entry entry) throws SAPinstException {
        SDTPanel parent = (SDTPanel)entry.getControl();
        SDTCheckBox checkBox = new SDTCheckBox();
        checkBox.addItemListener(this.adapter.getDepListener());
        parent.add(checkBox);
        entry.setObject(checkBox);
        this.process(entry);
        entry.setObject(parent);
    }

    protected void handleComboBox(SAPinstProtocolV3_0.Entry entry) throws SAPinstException {
        SDTPanel parent = (SDTPanel)entry.getControl();
        SDTComboBox comboBox = new SDTComboBox();
        parent.add(comboBox);
        entry.setObject(comboBox);
        this.process(entry);
        entry.setObject(parent);
        List items = comboBox.getItems();
        if (comboBox.getSelectedItem() == null && !items.isEmpty()) {
            comboBox.setSelectedItem(items.get(0));
        }
    }

    protected void handleRadioBox(SAPinstProtocolV3_0.Entry entry) throws SAPinstException {
        SDTPanel parent = (SDTPanel)entry.getControl();
        SDTRadioBox radioBox = new SDTRadioBox();
        parent.add(radioBox);
        entry.setObject(radioBox);
        this.process(entry);
        entry.setObject(parent);
    }

    protected void handleRadioButton(SAPinstProtocolV3_0.Entry entry) throws SAPinstException {
        SDTRadioBox radioBox = (SDTRadioBox)entry.getControl();
        SDTRadioButton radioButton = new SDTRadioButton();
        radioButton.addItemListener(this.adapter.getDepListener());
        radioBox.add(radioButton);
        entry.setObject(radioButton);
        this.process(entry);
        entry.setObject(radioBox);
    }

    protected void handlePasswordField(SAPinstProtocolV3_0.Entry entry) throws SAPinstException {
        SDTPanel parent = (SDTPanel)entry.getControl();
        SDTPasswordField pwdField = new SDTPasswordField();
        parent.add(pwdField);
        entry.setObject(pwdField);
        this.process(entry);
        entry.setObject(parent);
    }

    protected void handleFileBrowser(SAPinstProtocolV3_0.Entry entry) throws SAPinstException {
        SDTPanel parent = (SDTPanel)entry.getControl();
        SDTFileBrowser fB = new SDTFileBrowser();
        fB.setDirectoriesOnly(false);
        fB.addBrowseListener("ACTION_BROWSE", this.adapter.getDialogListener());
        parent.add(fB);
        entry.setObject(fB);
        this.process(entry);
        entry.setObject(parent);
    }

    protected void handleProgressBar(SAPinstProtocolV3_0.Entry entry) throws SAPinstException {
        SDTPanel parent = (SDTPanel)entry.getControl();
        SDTProgressBar progressBar = new SDTProgressBar();
        parent.add(progressBar);
        entry.setObject(progressBar);
        this.process(entry);
        entry.setObject(parent);
    }

    protected void handleDialogStatus(SAPinstProtocolV3_0.Entry entry) {
        SDTNetWeaverView dialog = (SDTNetWeaverView)entry.getControl();
        dialog.setStatus(entry.getElement().getContent());
    }

    private void initializeMnemonics(XMLElementIF elem) throws SAPinstException {
        SAPinstMnemonicsDispatcher.getInstance().clear();
        Iterator it = elem.getSubElements();
        while (it.hasNext()) {
            XMLElementIF subElem = (XMLElementIF)it.next();
            int elemType = SAPinstToolkit.getElemType(subElem.getName());
            if (elemType != 10) continue;
            String caption = null;
            try {
                caption = subElem.getElement("caption").getContent();
                int index = caption.indexOf(38);
                if (index == -1) continue;
                char m = caption.charAt(index + 1);
                SAPinstMnemonicsDispatcher.getInstance().addTaken(m);
            }
            catch (XMLException xmlE) {
                throw this.newElemExc(subElem);
            }
        }
    }

    private boolean isInit(XMLElementIF elem) throws SAPinstException {
        boolean isInit = false;
        try {
            String value = elem.getAttrString("init");
            if (value.equals("true") || value.equals("nosmart")) {
                isInit = true;
            }
            elem.removeAttr("init");
        }
        catch (XMLAttributeNotFoundException anfE) {
        }
        catch (XMLException xmlE) {
            throw this.newAttrExc("init", elem, xmlE);
        }
        return isInit;
    }

    private boolean isProgress(XMLElementIF elem) throws SAPinstException {
        boolean isProgress = false;
        try {
            isProgress = elem.getAttrBoolean("progress");
            elem.removeAttr("progress");
        }
        catch (XMLAttributeNotFoundException anfE) {
        }
        catch (XMLException xmlE) {
            throw this.newAttrExc("progress", elem, xmlE);
        }
        return isProgress;
    }

    private boolean isDiInit(XMLElementIF elem) {
        return this.isSpecialDialog(elem, SID_INIT);
    }

    private boolean isDiSummarize(XMLElementIF elem) {
        return this.isSpecialDialog(elem, SID_SUMMARIZE);
    }

    private boolean isDiSuccess(XMLElementIF elem) {
        return this.isSpecialDialog(elem, SID_SUCCESS);
    }

    private boolean isSpecialDialog(XMLElementIF elem, String sid) {
        boolean isSpecial = true;
        try {
            if (!elem.getAttrString("sid").equals(sid)) {
                isSpecial = false;
            }
        }
        catch (XMLException xmlE) {
            isSpecial = false;
        }
        return isSpecial;
    }

    private void rewriteInit(XMLElementIF elem) {
        Vector v = this.getComponents(elem);
        XMLElementIF catalog = XMLAdmin.createXMLElement();
        catalog.setName("catalog");
        XMLElementIF catName = XMLAdmin.createXMLElement();
        catName.setName("display-name");
        catalog.add(catName);
        this.setComponents(elem, catalog, v);
    }

    private void rewriteSummary(XMLElementIF elem) throws SAPinstException {
        String color = " bgcolor=#d4d0c8";
        String oldC = null;
        String newC = null;
        XMLElementIF html = null;
        try {
            html = elem.getElement("htmltext");
        }
        catch (XMLException xmlE) {
            throw this.newElemExc(elem, xmlE);
        }
        oldC = html.getContent();
        newC = oldC.replaceAll(color, "");
        html.setContent(newC);
    }

    private void rewriteSuccess(XMLElementIF elem) throws SAPinstException {
        String color = " bgcolor=#d4d0c8><p";
        String head = "<html><head>";
        String style = "<style type=\"text/css\">body {padding: 10px}</style>";
        String oldC = null;
        String newC = null;
        XMLElementIF html = null;
        try {
            html = elem.getElement("htmltext");
        }
        catch (XMLException xmlE) {
            throw this.newElemExc(elem, xmlE);
        }
        oldC = html.getContent();
        newC = oldC.replaceAll(color, "").replaceAll(head, head + style);
        html.setContent(newC);
    }

    private void rewriteProgress(XMLElementIF elem) {
        XMLElementIF progress = XMLAdmin.createXMLElement();
        progress.setName("progress-panel");
        try {
            XMLElementIF currentProgressElem = elem.getElement("currentprogress");
            progress.add(currentProgressElem);
        }
        catch (XMLException xmlE) {
            // empty catch block
        }
        Vector v = this.getComponents(elem);
        try {
            String allDone = elem.getAttrString("alldone");
            progress.setAttr("alldone", allDone);
        }
        catch (XMLException xmlE) {
            // empty catch block
        }
        this.removeIDs(v);
        this.setComponents(elem, progress, v);
    }

    private Vector getComponents(XMLElementIF elem) {
        Vector<XMLElementIF> v = new Vector<XMLElementIF>();
        Vector<XMLElementIF> toBeRemoved = new Vector<XMLElementIF>();
        Iterator it = elem.getSubElements();
        block4: while (it.hasNext()) {
            XMLElementIF subElem = (XMLElementIF)it.next();
            switch (SAPinstToolkit.getElemType(subElem.getName())) {
                case 16: {
                    v.add(subElem);
                    continue block4;
                }
                case 3: 
                case 4: 
                case 10: {
                    continue block4;
                }
            }
            toBeRemoved.add(subElem);
        }
        for (int i = 0; i < toBeRemoved.size(); ++i) {
            elem.remove((XMLElementIF)toBeRemoved.get(i));
        }
        return v;
    }

    private void removeIDs(Vector v) {
        for (int i = 0; i < v.size(); ++i) {
            XMLElementIF comp = (XMLElementIF)v.get(i);
            comp.removeAttr("id");
        }
    }

    private void setComponents(XMLElementIF elem, XMLElementIF target, Vector v) {
        for (int i = 0; i < v.size(); ++i) {
            XMLElementIF comp = (XMLElementIF)v.get(i);
            elem.remove(comp);
            XMLElementIF dispName = XMLAdmin.createXMLElement();
            dispName.setName("display-name");
            dispName.setContent(comp.getContent());
            comp.setContent(null);
            comp.add(dispName);
            target.add(comp);
        }
        elem.add(target);
    }

    private void cleanUp(XMLElementIF elem) {
        elem.removeAttr("init");
        elem.removeAttr("smart");
        elem.removeAttr("review");
        elem.removeAttr("progress");
        elem.removeAttr("alldone");
    }

    private void addInitComponent(SAPinstProtocolV3_0.Entry entry) throws SAPinstException {
        SAPinstNode parent = (SAPinstNode)entry.getControl();
        SAPinstNode node = new SAPinstNode();
        entry.setObject(node);
        this.process(entry);
        parent.addChild(node);
        entry.setObject(parent);
    }

    private void addProgressComponent(SAPinstProtocolV3_0.Entry entry) {
        try {
            XMLElementIF cN = entry.getElement().getElement("display-name");
            String item = cN.getContent();
            this.progressList.add(item);
            if (entry.getElement().getAttrBoolean("current")) {
                this.currentProgressIndex = this.progressList.size() - 1;
            }
        }
        catch (XMLException xMLException) {
            // empty catch block
        }
    }

    private void setColumnValue(SDTTableColumn column, SAPinstValue value) {
        switch (column.getColumnType()) {
            case 0: 
            case 3: 
            case 4: {
                column.setDefaultValue(value.getText());
                break;
            }
            case 1: {
                column.setDefaultValue(Boolean.valueOf(value.getText()));
                break;
            }
        }
    }

    private void setRowValue(SDTTableRow row, SAPinstValue value) {
        row.add(value.getText());
    }

    private void setFileBrowserValue(SDTFileBrowser fB, SAPinstValue value) {
        fB.setText(value.getText());
    }

    private void setComboBoxValue(SDTComboBox comboBox, SAPinstValue value) {
        String content = value.getText();
        if (content == null) {
            content = "";
        }
        comboBox.addItem(content);
    }

    private void setPasswordValue(SDTPasswordField pwd, SAPinstValue value) {
        pwd.setMaxLength(value.getMaxLength());
        pwd.setMinLength(value.getMinLength());
        pwd.setText(value.getText());
    }

    private void setFieldValue(SDTTextField field, SAPinstValue value) {
        this.setBooleanConstraints(field, value);
        field.setMaxLength(value.getMaxLength());
        field.setMinLength(value.getMinLength());
        field.setMaxValue(value.getMaxValue());
        field.setMinValue(value.getMinValue());
        field.setRegexp(value.getRegexp());
        field.setText(value.getText());
    }

    private void setBooleanConstraints(SDTTextField field, SAPinstValue value) {
        switch (SAPinstToolkit.getValueType(value.getType())) {
            case 3: {
                field.setNumeric(true);
                break;
            }
            case 4: {
                field.setUpperCase(true);
                break;
            }
            case 5: {
                break;
            }
        }
    }

    private int translateColumnType(XMLElementIF elem) throws SAPinstException {
        int result = -1;
        String vT = null;
        try {
            vT = elem.getAttrString("type");
        }
        catch (XMLException xmlE) {
            throw this.newAttrExc("type", elem, xmlE);
        }
        switch (SAPinstToolkit.getValueType(vT)) {
            case 6: {
                result = 0;
                break;
            }
            case 7: {
                result = 2;
                break;
            }
            case 8: {
                result = 1;
                break;
            }
            case 9: {
                result = 4;
                break;
            }
            case 10: {
                result = 3;
                break;
            }
            default: {
                throw this.newAttrExc("type", elem);
            }
        }
        return result;
    }

    private void reviseTable(SDTTable table) {
        for (int i = 0; i < table.getRowCount(); ++i) {
            SDTTableRow row = table.getRow(i);
            for (int j = 0; j < table.getColumnCount(); ++j) {
                Object value;
                SDTTableColumn column = table.getColumn(j);
                if (column.getColumnType() == 1) continue;
                List cells = row.getCells();
                if (j >= cells.size() || cells.get(j) == null) {
                    value = column.getDefaultValue();
                    if (j < cells.size()) {
                        cells.remove(j);
                    }
                    cells.add(j, value);
                    continue;
                }
                value = cells.get(j);
                if (column.getColumnType() != 2) continue;
                boolean found = false;
                List values = column.getValues();
                if (column.getValues() != null) {
                    for (int k = 0; k < values.size(); ++k) {
                        if (!value.equals((String)values.get(k))) continue;
                        found = true;
                        break;
                    }
                }
                if (found) continue;
                column.addValue(value);
            }
        }
    }

    private void resetInternalErrorState() {
        this.captionMisuseErrorHandled = false;
        this.regexpInvalidErrorHandled = false;
    }
}

