/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdt.server.ext.sapinst.adapter;

import com.sap.sdt.engine.core.controls.SDTConstants;
import com.sap.sdt.engine.core.controls.table.SDTTableColumn;
import com.sap.sdt.engine.core.controls.table.SDTTableRow;
import com.sap.sdt.engine.core.event.SDTActionEvent;
import com.sap.sdt.server.core.controls.SDTButton;
import com.sap.sdt.server.core.controls.SDTCheckBox;
import com.sap.sdt.server.core.controls.SDTComboBox;
import com.sap.sdt.server.core.controls.SDTComponent;
import com.sap.sdt.server.core.controls.SDTContainer;
import com.sap.sdt.server.core.controls.SDTControl;
import com.sap.sdt.server.core.controls.SDTFileBrowser;
import com.sap.sdt.server.core.controls.SDTMessageBox;
import com.sap.sdt.server.core.controls.SDTPasswordField;
import com.sap.sdt.server.core.controls.SDTRadioBox;
import com.sap.sdt.server.core.controls.SDTRadioButton;
import com.sap.sdt.server.core.controls.SDTTable;
import com.sap.sdt.server.core.controls.SDTTextField;
import com.sap.sdt.server.core.controls.SDTView;
import com.sap.sdt.server.core.services.tool.views.SDTNetWeaverView;
import com.sap.sdt.server.ext.sapinst.adapter.AbstractListener;
import com.sap.sdt.server.ext.sapinst.adapter.SAPinstAdapter;
import com.sap.sdt.server.ext.sapinst.adapter.SAPinstToolkit;
import com.sap.sdt.server.ext.sapinst.controls.SAPinstCatalog;
import com.sap.sdt.server.ext.sapinst.controls.SAPinstLogBrowser;
import com.sap.sdt.util.xml.XMLAdmin;
import com.sap.sdt.util.xml.XMLElementIF;
import java.util.Iterator;
import java.util.Vector;

class SAPinstDialogListener
extends AbstractListener
implements SDTConstants {
    public static final String RCSINFO = "$Id: //sdt/com.sap.sdt/0.1/src/_server/java/com/sap/sdt/server/ext/sapinst/adapter/SAPinstDialogListener.java#2 $";

    SAPinstDialogListener(SAPinstAdapter adapter) {
        super(adapter);
    }

    public void actionPerformed(SDTActionEvent e) {
        this.adapter.lockDialog();
        switch (SAPinstToolkit.getActionType(e.getActionCommand())) {
            case 0: {
                this.actionNext();
                break;
            }
            case 1: {
                this.actionBack();
                break;
            }
            case 4: {
                this.actionCancel();
                break;
            }
            case 8: {
                this.actionLogoff();
                break;
            }
            case 3: {
                this.actionLog();
                break;
            }
            case 10: {
                this.actionBrowse(e);
                break;
            }
            default: {
                this.adapter.getDialog().hidePopup();
                this.adapter.unlockDialog();
            }
        }
    }

    private void actionNext() {
        SDTNetWeaverView toolView = this.adapter.getDialog();
        if (!toolView.validate()) {
            this.showErrorPopup();
            return;
        }
        toolView.updateControl();
        XMLElementIF response = this.createResponse();
        this.writeAction("ACTION_NEXT", response);
        this.writeDialog(this.adapter.getDialog(), response);
        this.write(response);
    }

    private void actionBack() {
        this.actionGeneric("ACTION_PREV");
    }

    private void actionCancel() {
        this.actionGeneric("ACTION_CANCEL");
    }

    private void actionLogoff() {
        XMLElementIF logoff = XMLAdmin.createXMLElement();
        logoff.setName("sapinstguilogon");
        logoff.setAttr("version", "3.1");
        XMLElementIF version = XMLAdmin.createXMLElement();
        version.setName("logoff");
        logoff.add(version);
        this.write(logoff);
        this.adapter.exit();
    }

    private void actionLog() {
        XMLElementIF elem = XMLAdmin.createXMLElement();
        String severity = "INFO";
        SAPinstLogBrowser.getInstance().setInitialSeverity(severity);
        elem.setName("sapinstlog");
        elem.setAttr("version", "1.0");
        elem.setAttr("filename", "");
        elem.setAttr("severity", severity);
        this.write(elem);
    }

    private void actionBrowse(SDTActionEvent e) {
        SDTControl source = (SDTControl)e.getSource();
        this.adapter.showFileChooser(source);
    }

    private void showErrorPopup() {
        SDTMessageBox popup = new SDTMessageBox();
        StringBuffer errorText = new StringBuffer(256);
        errorText.append("<html>");
        errorText.append("<b>Diagnosis</b><br>");
        errorText.append("You have entered an invalid value in the highlighted field.<br><br>");
        errorText.append("<b>What to do</b><br>");
        errorText.append("Correct the value.<br>");
        errorText.append("Consult the online documentation (F1 help) for details about valid values for this field.");
        errorText.append("</html>");
        SDTButton button = new SDTButton();
        button.addActionListener(this);
        button.setActionCommand("Foo");
        button.setCaption("OK", '#');
        button.setDefault(true);
        popup.setMessageText(errorText.toString());
        popup.addButton(button);
        popup.setTitle("Error during Input Validation");
        popup.setModal(false);
        this.adapter.getDialog().showPopup(popup);
    }

    private void writeDialog(SDTView dialog, XMLElementIF parent) {
        String sid = this.adapter.getSID(dialog);
        XMLElementIF elem = XMLAdmin.createXMLElement();
        elem.setName("dialog");
        elem.setAttr("sid", sid);
        this.writeComposite(dialog, elem);
        parent.add(elem);
    }

    private void writeComposite(SDTContainer cont, XMLElementIF parent) {
        Vector controls = cont.getControls();
        block7: for (int i = 0; i < controls.size(); ++i) {
            SDTControl control = (SDTControl)controls.get(i);
            switch (control.getType()) {
                case 7: 
                case 8: 
                case 10: 
                case 11: 
                case 12: 
                case 16: {
                    this.writeComponent((SDTComponent)control, parent);
                    continue block7;
                }
                case 20: {
                    this.writeRadioBox((SDTRadioBox)control, parent);
                    continue block7;
                }
                case 15: {
                    this.writeTable((SDTTable)control, parent);
                    continue block7;
                }
                case 3: {
                    this.writeComposite((SDTContainer)control, parent);
                    continue block7;
                }
                case 30: {
                    this.writeCatalog((SAPinstCatalog)control, parent);
                    continue block7;
                }
            }
        }
    }

    private void writeComponent(SDTComponent comp, XMLElementIF parent) {
        String sid = this.adapter.getSID(comp);
        XMLElementIF elem = XMLAdmin.createXMLElement();
        elem.setName(this.getNameTag(comp));
        elem.setAttr("sid", sid);
        elem.setAttr("enabled", comp.isEnabled() ? "true" : "false");
        elem.add(this.getValue(comp));
        parent.add(elem);
    }

    private void writeCatalog(SAPinstCatalog catalog, XMLElementIF parent) {
        String id = catalog.getSelectedID();
        XMLElementIF elem = XMLAdmin.createXMLElement();
        elem.setName("component");
        elem.setAttr("id", id);
        parent.add(elem);
    }

    private void writeRadioBox(SDTRadioBox rB, XMLElementIF parent) {
        String sid = this.adapter.getSID(rB);
        XMLElementIF elem = XMLAdmin.createXMLElement();
        elem.setName("radiobox");
        elem.setAttr("sid", sid);
        elem.setAttr("enabled", rB.isEnabled() ? "true" : "false");
        Iterator it = rB.getButtons().iterator();
        while (it.hasNext()) {
            SDTRadioButton button = (SDTRadioButton)it.next();
            this.writeComponent(button, elem);
        }
        parent.add(elem);
    }

    private void writeTable(SDTTable table, XMLElementIF parent) {
        String sid = this.adapter.getSID(table);
        XMLElementIF elem = XMLAdmin.createXMLElement();
        elem.setName("table");
        elem.setAttr("sid", sid);
        int columns = table.getColumnCount();
        for (int i = 0; i < columns; ++i) {
            SDTTableColumn column = table.getColumn(i);
            String name = (String)column.getColumnID();
            XMLElementIF cE = XMLAdmin.createXMLElement();
            cE.setName("column");
            cE.setAttr("name", name);
            elem.add(cE);
        }
        int rows = table.getRowCount();
        for (int i = 0; i < rows; ++i) {
            SDTTableRow row = table.getRow(i);
            String rowID = (String)row.getRowID();
            XMLElementIF rE = XMLAdmin.createXMLElement();
            rE.setName("row");
            if (rowID != null) {
                rE.setAttr("rowId", rowID);
            }
            int j = 0;
            Iterator it = row.getCells().iterator();
            while (it.hasNext()) {
                XMLElementIF value = XMLAdmin.createXMLElement();
                String name = null;
                Object content = null;
                switch (table.getColumn(j).getColumnType()) {
                    case 0: 
                    case 2: 
                    case 3: 
                    case 4: {
                        name = "value";
                        value.setContent((String)it.next());
                        break;
                    }
                    case 1: {
                        name = "boolvalue";
                        Boolean b = (Boolean)it.next();
                        value.add(this.getBoolValue(b));
                        break;
                    }
                }
                value.setName(name);
                rE.add(value);
                ++j;
            }
            elem.add(rE);
        }
        parent.add(elem);
    }

    private String getNameTag(SDTControl control) {
        String tag = null;
        switch (control.getType()) {
            case 7: {
                tag = "field";
                break;
            }
            case 8: {
                tag = "password";
                break;
            }
            case 11: {
                tag = "check";
                break;
            }
            case 10: {
                tag = "radio";
                break;
            }
            case 12: {
                tag = "pulldown";
                break;
            }
            case 16: {
                tag = "filebrowser";
            }
        }
        return tag;
    }

    private String getValueTag(SDTComponent component) {
        String tag = null;
        switch (component.getType()) {
            case 7: 
            case 16: {
                tag = "value";
                break;
            }
            case 8: {
                tag = "encrvalue";
                break;
            }
            case 10: 
            case 11: {
                tag = "boolvalue";
                break;
            }
            case 12: {
                tag = "selectvalue";
            }
        }
        return tag;
    }

    private XMLElementIF getValue(SDTComponent comp) {
        XMLElementIF value = XMLAdmin.createXMLElement();
        value.setName(this.getValueTag(comp));
        switch (comp.getType()) {
            case 7: {
                value.setContent(((SDTTextField)comp).getText().trim());
                break;
            }
            case 8: {
                value.setContent(((SDTPasswordField)comp).getText());
                break;
            }
            case 11: {
                value.add(this.getBoolValue(((SDTCheckBox)comp).isSelected()));
                break;
            }
            case 10: {
                value.add(this.getBoolValue(((SDTRadioButton)comp).isSelected()));
                break;
            }
            case 12: {
                String c = (String)((SDTComboBox)comp).getSelectedItem();
                value.setContent(c);
                break;
            }
            case 16: {
                value.setContent(((SDTFileBrowser)comp).getText());
            }
        }
        return value;
    }

    private XMLElementIF getBoolValue(boolean value) {
        XMLElementIF bV = XMLAdmin.createXMLElement();
        bV.setName(value ? "true" : "false");
        return bV;
    }
}

